<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'ARISTA AR SA DE CV')); ?></title>

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">

        <link rel="shortcut icon" href="<?php echo e(asset('favicon/favicon-Naranja.ico')); ?>">

        <!-- Styles -->
        <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('plugins/fontawesome/css/all.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('plugins/toastr/toastr.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('plugins/select2/css/select2.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('plugins/select2/css/select2-bootstrap.min.css')); ?>">
        
        <link href="<?php echo e(asset('plugins/DataTables/datatables.css')); ?>" rel="stylesheet">
        <link rel="stylesheet" href="<?php echo e(asset('css/estilos.css')); ?>">

        <?php echo $__env->yieldPushContent('styles'); ?>
        <?php echo \Livewire\Livewire::styles(); ?>

    </head>
    <body class="font-sans antialiased bg-light">
        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'jetstream::components.banner','data' => []]); ?>
<?php $component->withName('jet-banner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('navigation-menu')->html();
} elseif ($_instance->childHasBeenRendered('jhNzIiB')) {
    $componentId = $_instance->getRenderedChildComponentId('jhNzIiB');
    $componentTag = $_instance->getRenderedChildComponentTagName('jhNzIiB');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('jhNzIiB');
} else {
    $response = \Livewire\Livewire::mount('navigation-menu');
    $html = $response->html();
    $_instance->logRenderedChild('jhNzIiB', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>

        <!-- Page Heading -->
        <header class="d-flex py-1 bg-white shadow-sm border-bottom">
            <div class="container">
                <?php echo e($header); ?>

            </div>
        </header>

        <!-- Page Content -->
        <main class="container-fluid my-2">
            <?php echo e($slot); ?>

        </main>

        <?php echo $__env->yieldPushContent('modals'); ?>

        <!-- Scripts -->
        <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
        <script src="<?php echo e(asset('plugins/jquery/jquery-3.7.0.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/sweetalert2/sweetalert2-11.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/tinymce/tinymce.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/toastr/toastr.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/select2/js/libs_select2.min.js')); ?>" defer></script>
        <script src="<?php echo e(asset('plugins/select2/js/select2.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/select2/js/i18n/es.js')); ?>"></script>

        
        <script src="<?php echo e(asset('plugins/DataTables/datatables.js')); ?>"></script>

        <script src="<?php echo e(asset('plugins2/momentjs/moment.js')); ?>"></script>




        <script src="https://cdn.jsdelivr.net/npm/datatables-buttons-excel-styles@1.2.0/js/buttons.html5.styles.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/datatables-buttons-excel-styles@1.2.0/js/buttons.html5.styles.templates.min.js"></script>

        <?php echo $__env->yieldPushContent('scripts'); ?>
        <?php echo \Livewire\Livewire::scripts(); ?>

    </body>
</html>
<?php /**PATH /var/www/html/arista_app/resources/views/layouts/app.blade.php ENDPATH**/ ?>