<?php

use App\Http\Controllers\Admin\IngenierosController;
use App\Http\Controllers\Admin\IvaImpuestoController;
use App\Http\Controllers\Admin\ObrasController;
use App\Http\Controllers\Admin\OrdenesComprasController;
use App\Http\Controllers\Admin\OrdenesComprasSinSolicitudController;
use App\Http\Controllers\Admin\PagosProveedoresController;
use App\Http\Controllers\Admin\ProductosController;
use App\Http\Controllers\Admin\ProveedoresController;
use App\Http\Controllers\Admin\UnidadesController;
use Illuminate\Support\Facades\Route;
use Laravel\Fortify\Http\Controllers\RegisteredUserController;
use App\Http\Controllers\Admin\SolicitudComprasController;
use App\Http\Controllers\Admin\EstatusController;
use App\Http\Controllers\Admin\TipoPagoController;
use App\Http\Controllers\Admin\ExportExcelController;

Route::get('/', function () {
    //return view('welcome');
    return view('auth.login');
});

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified'
])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    Route::get('register', [RegisteredUserController::class, 'create'])->name('register');
    Route::post('register', [RegisteredUserController::class, 'store']);

    //Catalogo de Proveedores
    Route::resource('catalogo-de-proveedores', ProveedoresController::class);
    Route::get('get-lista-proveedores', [ProveedoresController::class, 'get_Lista_Proveedores'])->name('catalogo-de-proveedores.get-lista-proveedores');
    Route::get('get-lista-proveedores-select', [ProveedoresController::class, 'get_Lista_Proveedores_Select'])->name('catalogo-de-proveedores.get-lista-proveedores-select');
    Route::get('get-proveedor-byId/{id}', [ProveedoresController::class, 'getProveedorById'])->name('catalogo-de-proveedores.get-proveedor-byId')
        ->where('id', '[0-9]+');


    //Catalogo de Obras
    Route::resource('catalogo-de-obras', ObrasController::class);
    Route::get('get-lista-obras', [ObrasController::class, 'get_Lista_Obras'])->name('catalogo-de-obras.get-lista-obras');
    Route::get('get-lista-obras-select', [ObrasController::class, 'get_Lista_Obras_Select'])->name('catalogo-de-obras.get-lista-obras-select');

    //Catalogo de Ingenieros
    Route::resource('catalogo-de-ingenieros', IngenierosController::class);
    Route::get('get-lista-ingenieros', [IngenierosController::class, 'get_Lista_Ingenieros'])->name('catalogo-de-ingenieros.get-lista-ingenieros');
    Route::get('get-lista-ingenieros-select', [IngenierosController::class, 'get_Lista_Ingenieros_Select'])->name('catalogo-de-ingenieros.get-lista-ingenieros-select');

    //Catalogo de unidades
    Route::resource('catalogo-de-unidades', UnidadesController::class);
    Route::get('get-lista-unidades', [UnidadesController::class, 'get_Lista_Unidades'])->name('catalogo-de-unidades.get-lista-unidades');
    Route::get('get-lista-unidades-select', [UnidadesController::class, 'get_Lista_Unidades_Select'])->name('catalogo-de-unidades.get-lista-unidades-select');

    //Catalogo de Productos
    Route::resource('catalogo-de-productos', ProductosController::class);
    Route::get('get-lista-productos', [ProductosController::class, 'get_Lista_Productos'])->name('catalogo-de-productos.get-lista-productos');
    Route::get('get-lista-productos-select', [ProductosController::class, 'get_Lista_Productos_Select'])->name('catalogo-de-productos.get-lista-productos-select');
    Route::get('get-productoById/{id}', [ProductosController::class, 'getProductoById'])->name('catalogo-de-productos.get-productoById');
    Route::post('catalogo-de-productos.crear-material', [ProductosController::class, 'crearMaterial'])->name('catalogo-de-productos.crear-material');

    //Catalogo de IvaImpuesto
    Route::resource('catalogo-de-iva-impuesto', IvaImpuestoController::class);
    Route::get('get-lista-iva-impuesto', [IvaImpuestoController::class, 'get_Lista_Iva'])->name('catalogo-de-iva-impuesto.get-lista-iva-impuesto');
    Route::get('get-lista-iva-impuesto-select', [IvaImpuestoController::class, 'get_Lista_Iva_Impuesto_Select'])
        ->name('catalogo-de-iva-impuesto.get-lista-iva-impuesto-select');
    Route::get('get-lista-iva-select-simple', [IvaImpuestoController::class, 'get_Lista_Iva_Select_Simple'])
        ->name('catalogo-de-iva-impuesto.get-lista-iva-select-simple');

    //Catalogo de Estatus
    Route::get('get-lista-estatus-select', [EstatusController::class, 'get_Lista_Estatus_Select'])->name('get-lista-estatus-select');

    //Catalogo de Tipo Pago
    Route::get('get-lista-tipo-pago-select', [TipoPagoController::class, 'get_Lista_Tipo_Pago_Select'])->name('get-lista-tipo-pago-select');


    //Solicitud de compras
    Route::resource('solicitud-de-compras', SolicitudComprasController::class);
    Route::get('solicitud-de-compras/{solicitud_id}/{clonSolicitud?}', [SolicitudComprasController::class, 'show'])
        ->name('solicitud-de-compras.show.clon-solicitud')->where('solicitud_id', '[0-9]+');
    Route::get('get-lista-solicitud-compras', [SolicitudComprasController::class, 'get_Lista_solicitud_compras'])->name('solicitud-de-compras.get-lista-solicitud-compras');
    Route::get('get-lista-solicitud-compras-select', [SolicitudComprasController::class, 'get_Lista_solicitud_compras_Select'])->name('solicitud-de-compras.get-lista-solicitud-compras-select');
    Route::get('get-producto-unidad-xclave/{id_producto}/{id_unidad}', [SolicitudComprasController::class, 'getProductoAndUnidadById'])
        ->where('id_producto', '[0-9]+')->where('id_unidad', '[0-9]+')
        ->name('solicitud-de-compras.get-producto-unidad-xclave');
    Route::get('get-solicitud-de-compra-byid/{id}', [SolicitudComprasController::class, 'getSolicitudCompraById'])
        ->where('id', '[0-9]+')
        ->name('solicitud-de-compras.get-solicitud-de-compra-byid');
    Route::get('solicitud-de-compras-print-pdf/{id}/{enviar_correo?}', [SolicitudComprasController::class, 'print_pdf'])
        ->where('id', '[0-9]+')->name('solicitud-de-compras.solicitud-de-compras-print-pdf');
    Route::delete('solicitud-de-compra-eliminar-material/{id_material}', [SolicitudComprasController::class, 'eliminar_material_bd'])
        ->where('id_material', '[0-9]+');
    Route::post('solicitud-de-compras-print-pdf-list-selected', [SolicitudComprasController::class, 'print_pdf_list_selected'])->name('solicitud-de-compras.solicitud-de-compras-print-pdf-list-selected');
    Route::post('solicitud-de-compra-estatus-autorizado', [SolicitudComprasController::class, 'actualizar_estatus_autorizado'])->name('solicitud-de-compra-estatus-autorizado');
    Route::get('get-lista-materiales-by-solicitud-select/{solicitud_id}', [SolicitudComprasController::class, 'get_Lista_Materiales_By_Solicitud_Id_Select'])
        ->where('solicitud_id', '[0-9]+')->name('catalogo-de-productos.get-lista-materiales-by-solicitud-select');
    Route::post('solicitud-de-compras-store-comentario-material', [SolicitudComprasController::class, 'saveComentarioGrupal'])->name('solicitud-de-compras.solicitud-de-compras-store-comentario-material');
    Route::get('get-comentario-grupal-xclave/{id_comentario_material}', [SolicitudComprasController::class, 'getComentarioGrupalById'])
        ->where('id_comentario_material', '[0-9]+')->name('solicitud-de-compras.get-comentario-grupal-xclave');
    Route::put('solicitud-de-compras-update-comentario-material/{comentario_material_id}', [SolicitudComprasController::class, 'updateComentarioGrupal'])
        ->where('comentario_material_id', '[0-9]+')->name('solicitud-de-compras.solicitud-de-compras-update-comentario-material');
    Route::post('solicitud-de-compra-estatus-finalizado', [SolicitudComprasController::class, 'cambiarEstatusFinalizado'])->name('solicitud-de-compra-estatus-finalizado');
    Route::post('solicitud-de-compras-save-clon', [SolicitudComprasController::class, 'saveClonSolicitud'])->name('solicitud-de-compras-save-clon');
    Route::get('solicitud-de-compras-print-excel/{id?}', [ExportExcelController::class, 'exportar_excel_solicitud'])
        ->where('id', '[0-9]+')->name('solicitud-de-compras.solicitud-de-compras-print-excel');

    //Ordenes de compras
    Route::resource('ordenes-de-compras', OrdenesComprasController::class);
    Route::get('ordenes-de-compras/create/{usarSolicitud?}', [OrdenesComprasController::class, 'create'])
        ->name('ordenes-de-compras.create.with-solicitud');
    Route::get('get-lista-ordenes-compras', [OrdenesComprasController::class, 'get_Lista_Ordenes_Compras'])->name('ordenes-de-compras.get-lista-ordenes-compras');
    Route::get('delete-archivo-pdf/{id}', [OrdenesComprasController::class, 'delete_Archivo_Pdf'])->name('ordenes-de-compras.delete-archivo-pdf');
    Route::post('orden-de-compra-update-estatus', [OrdenesComprasController::class, 'actualizar_Estatus_Autorizado'])->name('orden-de-compra-update-estatus');
    Route::get('get-lista-ordenes-de-compras-select', [OrdenesComprasController::class, 'get_Lista_Orden_Select'])->name('ordenes-de-compras.get-lista-ordenes-de-compras-select');
    Route::get('ordenes-de-compras-print-pdf/{id}/{enviar_correo?}/{solo_requisicion_compras?}', [OrdenesComprasController::class, 'print_pdf'])
        ->where('id', '[0-9]+')->name('ordenes-de-compras.ordenes-de-compras-print-pdf');
    Route::post('/ordenes-de-compras/upload-pdf', [OrdenesComprasController::class, 'uploadPDF'])->name('ordenes.uploadPDF');
    Route::put('/ordenes-de-compras/{id}/update-with-pdf', [OrdenesComprasController::class, 'updateOrderWithPDF'])->name('ordenes.updateWithPDF');
    Route::delete('/ordenes-de-compras/{id}/delete-pdf', [OrdenesComprasController::class, 'deletePDF'])->name('ordenes.deletePDF');
    Route::post('ordenes-de-compras-print-pdf-list-selected', [OrdenesComprasController::class, 'print_pdf_list_selected'])->name('ordenes-de-compras.ordenes-de-compras-print-pdf-list-selected');
    Route::post('orden-de-compra-update-estatus-por-autorizar', [OrdenesComprasController::class, 'actualizar_estatus_por_autorizar'])->name('orden-de-compra-update-estatus-por-autorizar');
    Route::delete('orden-de-compra-eliminar-material-precio/{solicitud_compra_id}/{producto_id}/{orden_compra_id?}', [OrdenesComprasController::class, 'eliminarMaterialYPrecio'])
        ->where('solicitud_compra_id', '[0-9]+')->where('producto_id', '[0-9]+')->where('orden_compra_id', '[0-9]+');


    // //Pagos a proveedores
    Route::resource('pagos-a-proveedores', PagosProveedoresController::class);
    Route::get('get-lista-pagos-proveedores', [PagosProveedoresController::class, 'get_Lista_Pagos_Proveedores'])->name('pagos-a-proveedores.get-lista-pagos-proveedores');
    Route::get('delete-archivo-pago-pdf/{id}', [PagosProveedoresController::class, 'delete_Archivo_Pago_Pdf'])
        ->where('id', '[0-9]+')->name('pagos-a-proveedores.delete-archivo-pago-pdf');
    Route::get('pagos-a-proveedores-print-pdf/{id}/{enviar_correo?}', [PagosProveedoresController::class, 'print_pdf'])
        ->where('id', '[0-9]+')->name('pagos-a-proveedores.pagos-a-proveedores-print-pdf');
    Route::get('pagos-a-proveedores-print-pdf-all', [PagosProveedoresController::class, 'print_pdf_all_list'])->name('pagos-a-proveedores.pagos-a-proveedores-print-pdf-all');
    Route::post('pago-update-estatus', [PagosProveedoresController::class, 'actualizar_estatus'])
        ->name('pago-update-estatus');
    Route::post('pagos-a-proveedores-upload-pdf/{type}', [PagosProveedoresController::class, 'uploadPdf'])->name('pagos-a-proveedores.uploadPdf');
    Route::post('pagos-a-proveedores-print-pdf-list-selected', [PagosProveedoresController::class, 'print_pdf_list_selected'])->name('pagos-a-proveedores.pagos-a-proveedores-print-pdf-list-selected');

});
