<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'ARISTA AR SA DE CV') }}</title>

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">
{{--        <link rel="icon" type="image/png" sizes="16x16" href="{{ url('favicon/favicon-Naranja.ico') }}">--}}
        <link rel="shortcut icon" href="{{ asset('favicon/favicon-Naranja.ico') }}">

        <!-- Styles -->
        <link rel="stylesheet" href="{{ asset('css/app.css') }}">
        <link rel="stylesheet" href="{{ asset('plugins/fontawesome/css/all.min.css') }}">
        <link rel="stylesheet" href="{{ asset('plugins/toastr/toastr.min.css') }}">
        <link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}">
        <link rel="stylesheet" href="{{ asset('plugins/select2/css/select2-bootstrap.min.css') }}">
        {{-- Datatable --}}
        <link href="{{ asset('plugins/DataTables/datatables.css') }}" rel="stylesheet">
        <link rel="stylesheet" href="{{ asset('css/estilos.css') }}">

        @stack('styles')
        @livewireStyles
    </head>
    <body class="font-sans antialiased bg-light">
        <x-jet-banner />
        @livewire('navigation-menu')

        <!-- Page Heading -->
        <header class="d-flex py-1 bg-white shadow-sm border-bottom">
            <div class="container">
                {{ $header }}
            </div>
        </header>

        <!-- Page Content -->
        <main class="container-fluid my-2">
            {{ $slot }}
        </main>

        @stack('modals')

        <!-- Scripts -->
        <script src="{{ asset('js/app.js') }}" defer></script>
        <script src="{{ asset('plugins/jquery/jquery-3.7.0.js') }}"></script>
        <script src="{{ asset('plugins/sweetalert2/sweetalert2-11.js') }}"></script>
        <script src="{{ asset('plugins/tinymce/tinymce.min.js') }}"></script>
        <script src="{{ asset('plugins/toastr/toastr.min.js') }}"></script>
        <script src="{{ asset('plugins/select2/js/libs_select2.min.js') }}" defer></script>
        <script src="{{ asset('plugins/select2/js/select2.min.js') }}"></script>
        <script src="{{ asset('plugins/select2/js/i18n/es.js') }}"></script>

        {{-- Datatables js --}}
        <script src="{{ asset('plugins/DataTables/datatables.js') }}"></script>

        <script src="{{asset('plugins2/momentjs/moment.js')}}"></script>
{{--        <script src="{{ asset('plugins/momentjs/moment-precise-range.js') }}"></script>--}}
{{--        <script src="{{asset('moment-precise-range-plugin/moment-precise-range.js')}}"></script>--}}

{{--        Para Estilos en Excel--}}
        <script src="https://cdn.jsdelivr.net/npm/datatables-buttons-excel-styles@1.2.0/js/buttons.html5.styles.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/datatables-buttons-excel-styles@1.2.0/js/buttons.html5.styles.templates.min.js"></script>

        @stack('scripts')
        @livewireScripts
    </body>
</html>
