@inject('carbon', 'Carbon\Carbon')
@inject('Functions', 'App\Http\Helpers\FunctionsHelper')
    <!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Solicitud de compra</title>

    <link rel="stylesheet" href="{{ base_path('public/css/app.css') }}">
    <link href="{{ base_path('public/css/prints-report-solicitud.css') }}" media="all" rel="stylesheet" type="text/css" />
</head>
<body>
@php
    $obra = $solicitud_compra->obra;
    $ingeniero = $solicitud_compra->ingeniero;
    $lista_materiales = $solicitud_compra->solicitudCompraProducto;
@endphp

<div class="container">
{{--    <header>--}}
        <div class="row">
            <div class="col-12">
                <div class="mb-1">
                    <table class="table tabla_sin_border">
                        <tbody>
                            <tr style="padding-bottom: 0!important;">
                                <td width="15%" class="no_border">
                                    <img class="img-logo" src="{{ public_path('Logotipo/Logotipo_Original.png') }}" style="width: 100px!important; height: 100px!important;">
                                </td>
                                <td width="55%" class="no_border">
                                    <h1 class="titulo_arista">ARISTA AR SA DE CV</h1>
                                    <p class="direccion_arista">CALLE 19 X 56 NUMERO 363 PLAN DE AYALA NORTE, YUCATAN, CP. 97118</p>
                                    <p class="direccion_arista">RFC: AAR080509D22</p>
                                    <p class="direccion_arista">Tel.:999 944 5327</p>
                                </td>
                                <td width="30%" class="no_border">
                                    <table class="table tabla_con_border" style="margin-bottom: 0!important;">
                                        <thead>
                                            <tr>
                                                <th colspan="2"><p class="_title_requisicion_">REQUISICIÓN DE COMPRA</p></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">REQUISICIÓN SEMANAL N.</p></td>
                                                <td>
                                                    <p class="_requisicion_dato_">{{ $solicitud_compra->codigo }}</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">OBRA:</p></td>
                                                <td>
                                                    <p class="_requisicion_dato_">{{ $obra->nombre }}</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">ELABORÓ:</p></td>
                                                <td>
                                                    <p class="_requisicion_dato_">{{ $ingeniero->nombre }}</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">FECHA SOLICITADA:</p></td>
                                                <td>
                                                    <p class="_requisicion_dato_">{{ $Functions->formatDateFormat2($solicitud_compra->fecha_solicitud) }}</p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
{{--    </header>--}}

    {{-- Lista materiales --}}
{{--    <section>--}}
        <div class="row">
            <div class="col-12">
                <div class="mt-1">
                    <table class="table tabla_con_border">
                        <thead>
                            <tr class="table_thead_bg_naranja">
                                <th scope="col">No.</th>
                                <th scope="col">CÓDIGO</th>
                                <th scope="col">MATERIAL</th>
                                <th scope="col">UNIDAD</th>
                                <th scope="col">CANTIDAD</th>
                                <th scope="col">ÁREA DE USO</th>
                                <th scope="col">MARCA
                                <th scope="col">MODELO</th>
                                <th scope="col">OBSERVACIONES</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($lista_materiales as $key => $material)
                            <tr>
                                <td class="_padding_tb_ text-center">{{ $key + 1 }}</td>
                                <td class="_padding_tb_ text-center">{{ $material->producto->codigo }}</td>
                                <td class="_padding_tb_">{{ $material->producto->nombre }}</td>
                                <td class="_padding_tb_ text-center">{{ $material->unidad->nombre }}</td>
                                <td class="_padding_tb_ text-center">{{ $material->cantidad }}</td>
                                <td class="_padding_tb_ text-center">{{ $material->area_de_uso }}</td>
                                <td class="_padding_tb_ text-center">{{ $material->marca }}</td>
                                <td class="_padding_tb_ text-center">{{ $material->modelo }}</td>
                                <td class="_padding_tb_ text-center">{{ $material->observaciones }}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

{{--    </section>--}}
    {{-- End-Lista materiales --}}

    <section>
        <div class="mt-1">
            <table class="table tabla_con_border">
                <tbody>
                <tr>
                    <td width="70%">
                        <p class="">{{ $solicitud_compra->observaciones }}</p>
                    </td>
                    <td style="background-color: #ff9933;">
                        <p class="footer_oc_">FECHA DE ENTREGA SOLICITADA</p>
                        <p class="text-center">{{ $Functions->formatDateFormat2($solicitud_compra->fecha_entrega) }}</p>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </section>

</div>

</body>
</html>
