<x-app-layout>
    <x-slot name="header">
        <h3 class="text-center">
            {{ __('Nueva Solicitud de compra') }}
        </h3>
    </x-slot>

    @push('styles')
        <link rel="stylesheet" href="{{asset('plugins2/bootstrap-datepicker/css/bootstrap-datepicker.min.css')}}">
    @endpush

    <div class="bg-white overflow-hidden mt-4">

        {{-- Form --}}
        <div class="mt-4">
            <form id="form_solicitud_compra">
                <div class="shadow">

                    {{-- Datos generales--}}
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="obra_id" class="form-label">Obra <span class="_required_">*</span></label>
                                <select class="form-control save-required @error('obra_id') is-invalid @enderror" id="obra_id" name="obra_id" style="width: 100%;" tabindex="1"></select>
                                <x-jet-input-error for="obra_id" />
                            </div>
                            @can('solicitud_de_compras_create_select_ing_catalogo')
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                    <label for="ingeniero_id" class="form-label">ING. <span class="_required_">*</span></label>
                                    <select class="form-control save-required @error('ingeniero_id') is-invalid @enderror" id="ingeniero_id" name="ingeniero_id" style="width: 100%;" tabindex="2"></select>
                                    <x-jet-input-error for="ingeniero_id" />
                                </div>
                            @else
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                    <label for="ingeniero_id" class="form-label">ING. <span class="_required_">*</span></label>
                                    <select class="form-control save-required @error('ingeniero_id') is-invalid @enderror" id="ingeniero_id" name="ingeniero_id" style="width: 100%;" tabindex="2" disabled>
                                        @if($ingeniero)
                                            <option value="{{ $ingeniero->id }}" selected="selected">{{ $ingeniero->nombre }}</option>
                                        @endif
                                    </select>
                                </div>
                            @endcan

                        </div>
                    </div>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-6 col-lg-6">
                                <label for="fecha_entrega" class="form-label">Fecha de entrega</label>
                                <div class="input-group date">
                                    <input type="text" class="form-control" name="fecha_entrega" id="fecha_entrega" autocomplete="off" placeholder="dd/mm/yyyy" tabindex="3" readonly>
                                    <div class="input-group-addon">
                                        <i class="fa-regular fa-calendar-days"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-6 col-lg-6">
                                <label for="observaciones" class="form-label">Comentarios adicionales</label>
                                <textarea class="form-control @error('observaciones') is-invalid @enderror" name="observaciones" id="observaciones" autocomplete="off" placeholder="Agregar Comentarios" tabindex="4"></textarea>
                                <x-jet-input-error for="observaciones" />
                            </div>
                        </div>
                    </div>
                    {{-- End-Datos generales--}}

                    {{-- Materiales--}}
                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Materiales</b></h5>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-6 col-sm-3 col-md-3 col-lg-2">
                                <p><button type="button" id="addRow" class="btn btn-primary text-white mb-2 me-1" title="Agregar material" data-bs-toggle="modal" data-bs-target="#modalNewProducto"><i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Agregar material</button></p>
                            </div>
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="productos-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                        <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Clave de Material</th>
                                            <th>Material</th>
                                            <th>Clave de Unidad</th>
                                            <th>Unidad</th>
                                            <th>Cantidad</th>
                                            <th>Área de uso</th>
                                            <th>Marca</th>
                                            <th>Modelo</th>
                                            <th>Observaciones</th>
                                            <th>No. duplicado orden</th>
                                            <th>Acciones</th>
                                        </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- End-Materiales--}}

                    {{-- Emails --}}
                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Envio de correo</b></h5>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <label for="emails" class="form-label">Email</label>
                                <input type="text" class="form-control" name="emails" id="emails" autocomplete="off" placeholder="Agregar Emails" tabindex="5">
                                <small>Ejemplo: demo@hotmail.com,demo2@gmail.com</small>
                            </div>
                            <div class="col-12">
                                <label for="email_asunto" class="form-label">Asunto</label>
                                <input type="text" class="form-control" name="email_asunto" id="email_asunto" autocomplete="off" placeholder="Agregar asunto" tabindex="6">
                            </div>
                            <div class="col-12">
                                <label for="email_contenido" class="form-label">Contenido</label>
                                <textarea class="form-control" name="email_contenido" id="email_contenido" placeholder="Agregar contenido" rows="3" tabindex="7"></textarea>

                            </div>
                        </div>
                    </div>
                    {{-- End-Emails --}}

                    <hr>
                    <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                        <a href="{{ route('solicitud-de-compras.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Cancelar</a>
                        <button type="button" id="guardarSolicitudForm" class="btn btn-primary text-white" tabindex="8"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar</button>
                    </div>
                </div>
            </form>
        </div>
        {{-- End-Form --}}

    </div>

    <!-- Modal -->
    <div class="modal fade" id="modalNewProducto" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Agregar Material</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="newFormModal">
                        <div class="px-4 py-1">
                            <div class="row">
                                <div class="col">
                                    <label for="producto_id" class="form-label">Material <span class="_required_">*</span></label>
                                    <div class="row">
                                        <div class="@can('catalogo_de_productos_create') col-10 @else col-12 @endcan">
                                            <select class="form-control save-required is-invalid" id="producto_id" name="producto_id" style="width: 100%;" tabindex="1"></select>
                                        </div>
                                        {{-- Ing no tiene permiso de crear material--}}
                                        @can('catalogo_de_productos_create')
                                        <div class="col-2">
                                            <button type="button" id="btn_crear_material" class="btn btn-primary text-white mb-2 me-1" title="Crear Material"><i class="fa-sharp fa-solid fa-plus"></i></button>
                                        </div>
                                        @endcan
                                    </div>
                                </div>
                                <div class="col">
                                    <label for="unidad_id" class="form-label">Unidad <span class="_required_">*</span></label>
                                    <select class="form-control save-required" id="unidad_id" name="unidad_id" style="width: 100%;" tabindex="2"></select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="cantidad" class="form-label">Cantidad <span class="_required_">*</span></label>
                                    <input type="text" class="form-control precio_decimal save-required" name="cantidad" id="cantidad" autocomplete="off" placeholder="Agregar Cantidad" tabindex="3">
                                </div>
                                <div class="col">
                                    <label for="area_de_uso" class="form-label">Área de uso</label>
                                    <input type="text" class="form-control" name="area_de_uso" id="area_de_uso" autocomplete="off" placeholder="Agregar área de uso" tabindex="4">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="marca" class="form-label">Marca</label>
                                    <input type="text" class="form-control" name="marca" id="marca" autocomplete="off" placeholder="Agregar marca" tabindex="5">
                                </div>
                                <div class="col">
                                    <label for="modelo" class="form-label">Modelo</label>
                                    <input type="text" class="form-control" name="modelo" id="modelo" autocomplete="off" placeholder="Agregar modelo" tabindex="6">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="observaciones_prod" class="form-label">Observaciones</label>
                                    <input type="text" class="form-control" name="observaciones_prod" id="observaciones_prod" autocomplete="off" placeholder="Agregar observaciones" tabindex="7">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i>&nbsp;Cerrar</button>
                    <button type="button" id="saveProductoNew" class="btn btn-primary text-white" tabindex="8"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Agregar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Fin-Modal -->

    <!-- Modal-Crear-Material -->
    <div class="modal fade" id="crearMaterialModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Crear Material</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div id="crearMaterial_Form_Modal" class="modal-body">
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <label for="crear_material_nombre" class="form-label">Nombre <span class="_required_">*</span></label>
                                <textarea class="form-control save-required" name="crear_material_nombre" id="crear_material_nombre" placeholder="Agregar nombre" rows="3" tabindex="1"></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="crear_material_descripcion" class="form-label">Descripción</label>
                                <textarea class="form-control" name="crear_material_descripcion" id="crear_material_descripcion" placeholder="Agregar descripción" rows="3" tabindex="2"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i>&nbsp;Cerrar</button>
                    <button type="button" id="bntCrearMaterial" class="btn btn-primary text-white"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Fin-Modal-Crear-Material -->

    @push('scripts')
        <script src="{{ asset('plugins/inputmask/jquery.inputmask.min.js') }}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/locales/bootstrap-datepicker.es.min.js')}}"></script>
        <script src="{{asset('js/admin.js')}}"></script>
        <script type="text/javascript">
            var APP_URL = {!! json_encode(url('/')) !!};
            var productosDT = null;

            $(document).ready(function($){
                productosDT = new DataTable('#productos-datatable', {
                    "dom": '<"top"f><"datatable-scroll"rt><"bottom"ip><"clear">',
                    pageLength: 6,
                    responsive: true,
                    scrollX: false,
                    "language": {
                        "url": APP_URL + "/plugins/DataTables/language.MX.json"
                    },
                    columnDefs: [{ visible: false, targets: [1,3,10] }],
                    createdRow: function(row, data, dataIndex) {
                        $(row).attr('id', data[0]);
                        $(row).attr('rowIndex', dataIndex);
                        var botones = '<button id="btn-eliminar-'+ data[0] +'" data-id="' + data[0] + '" class="btn_delete_registro btn btn-danger text-white mb-2 me-1" title="Eliminar"><i class="fa-sharp fa-solid fa-trash-can"></i>&nbsp;Eliminar</button>';
                        $('td:eq(-1)', row).html(botones);
                    },
                });
                let counter = 1;

                $('#obra_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    ajax: {
                        dataType: 'json',
                        url: "/get-lista-obras-select",
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term
                            }
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                        }
                    },
                    cache: true
                });

                $('#ingeniero_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    ajax: {
                        dataType: 'json',
                        url: "/get-lista-ingenieros-select",
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term
                            }
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                        }
                    },
                    cache: true
                });

                $('#fecha_entrega').datepicker({
                    language: 'es',
                    autoclose: true,
                    format: "dd/mm/yyyy",
                    todayHighlight: true,
                    startDate: new Date()
                });

                $('#producto_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    ajax: {
                        dataType: 'json',
                        url: "/get-lista-productos-select",
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term
                            }
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                        }
                    },
                    cache: true,
                    dropdownParent: $('#modalNewProducto .modal-content')
                });

                $('#unidad_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    ajax: {
                        dataType: 'json',
                        url: "/get-lista-unidades-select",
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term
                            }
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                        }
                    },
                    cache: true,
                    dropdownParent: $('#modalNewProducto .modal-content')
                });

                // $('#cantidad').inputmask({
                //     alias: 'numeric',
                //     allowMinus: false,
                //     digits: 0,
                // });

                $("#cantidad").inputmask({
                    alias: 'decimal',
                    allowMinus: false,
                    digits: 2,
                    rightAlign: true,
                });

                const myModalEl = document.getElementById('modalNewProducto')
                myModalEl.addEventListener('hidden.bs.modal', event => {
                    $('#producto_id').val(null).change();
                    $('#unidad_id').val(null).change();
                    $("#cantidad").val("");
                    $("#area_de_uso").val("");
                    $("#marca").val("");
                    $("#modelo").val("");
                    $("#observaciones_prod").val("");
                });

                $('#saveProductoNew').off('click');
                $('#saveProductoNew').on('click', function (){
                    var idform = '#newFormModal';
                    if(validateForm(idform)){

                        var url_prod = APP_URL + '/get-producto-unidad-xclave/'+$('#producto_id').val() +'/'+$('#unidad_id').val();
                        axios.get(url_prod)
                            .then(response => {
                                var resp = response.data;
                                if(!resp.error){

                                    var data = {
                                        producto_id: $('#producto_id').val(),
                                        producto_nombre: resp.producto.nombre,
                                        unidad_id: $('#unidad_id').val(),
                                        unidad_nombre: resp.unidad.nombre,
                                        cantidad: $('#cantidad').val(),
                                        area_de_uso: $('#area_de_uso').val(),
                                        marca: $('#marca').val(),
                                        modelo: $('#modelo').val(),
                                        observaciones_prod: $('#observaciones_prod').val(),
                                        num_duplicado_order: 0,
                                    };

                                    var materialesRows = productosDT.rows().data().toArray();
                                    if(materialesRows.length > 0){
                                        let duplicado = encontrarDuplicadosPorIdMaterial(materialesRows, data);
                                        if (Object.keys(duplicado).length > 0){
                                            addNewRow(duplicado);
                                        } else {
                                            addNewRow(data);
                                        }
                                    } else {
                                        addNewRow(data);
                                    }
                                    $("#modalNewProducto").modal('hide');

                                }else{
                                    toastr.warning('No se pudo obtener el material.');
                                }
                            }).catch(e => {
                            console.log(e);
                            toastr.error('Ocurrio un error inesperado.');
                        });
                    }
                });

                function addNewRow(data) {
                    productosDT.row
                        .add([
                            counter,
                            data.producto_id,
                            data.producto_nombre,
                            data.unidad_id,
                            data.unidad_nombre,
                            data.cantidad,
                            data.area_de_uso,
                            data.marca,
                            data.modelo,
                            data.observaciones_prod,
                            data.num_duplicado_order,
                            ''
                        ])
                        .draw(false);

                    counter++;
                }

                $('#productos-datatable tbody').off('click', '.btn_delete_registro');
                $('#productos-datatable tbody').on('click', '.btn_delete_registro', function (e)
                {
                    e.preventDefault();
                    var row = $(this).parents('tr');
                    Swal.fire({
                        title: "¿Está seguro que desea eliminar el Material?",
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#3085d6",
                        cancelButtonColor: "#d33",
                        confirmButtonText: "Si, eliminar!",
                        cancelButtonText: "No, cancelar!",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            if (row) {
                                productosDT.row(row).remove().draw(false);
                            } else {
                                toastr.warning('Debe seleccionar un material para eliminarlo.');
                            }
                        }
                    });
                });

                /**
                 * Guardar Solicitud de compras
                 */
                $('#guardarSolicitudForm').off('click');
                $('#guardarSolicitudForm').on('click', function (){
                    var id_form_sol = '#form_solicitud_compra';
                    if(validateForm(id_form_sol)){

                        var materialesRows = productosDT.rows().data().toArray();
                        if(materialesRows.length === 0){
                            toastr.warning('Debe agregar al menos un material.');
                        }else{
                            $('#guardarSolicitudForm').attr("disabled", true);
                            var data = {
                                obra_id: $('#obra_id').val(),
                                ingeniero_id: $('#ingeniero_id').val(),
                                fecha_entrega: $('#fecha_entrega').val(),
                                observaciones: $('#observaciones').val(),
                                productos_data: materialesRows,
                                emails: $('#emails').val(),
                                email_asunto: $('#email_asunto').val(),
                                email_contenido: $('#email_contenido').val(),
                            };
                            createSolicitudCompra(data);
                        }
                    }
                });

                //===== Crear Material =====
                $("#btn_crear_material").off('click');
                $("#btn_crear_material").on("click", function (){
                    $('#crearMaterialModal').modal('show');
                });

                $("#bntCrearMaterial").off('click');
                $("#bntCrearMaterial").on("click", function (){
                    $('#bntCrearMaterial').attr("disabled", true); //Disabled
                    var idform = '#crearMaterialModal #crearMaterial_Form_Modal';
                    if (validateForm(idform)) {
                        var data = {
                            nombre: $('#crear_material_nombre').val(),
                            descripcion: $('#crear_material_descripcion').val()
                        };

                        var url_save = APP_URL + '/catalogo-de-productos.crear-material';
                        axios.post(url_save, data)
                            .then(response => {
                                var resp = response.data;
                                if(!resp.error) {
                                    toastr.success(resp.message);
                                    var new_material = resp.data; //Producto

                                    // create the option and append to Select2
                                    var option = new Option(new_material.nombre, new_material.id, true, true);
                                    $('#producto_id').append(option).trigger('change');

                                    $('#crearMaterialModal').modal('hide');
                                    //limpia form
                                    $('#crear_material_nombre').val('');
                                    $('#crear_material_descripcion').val('');
                                    $('#bntCrearMaterial').attr("disabled", false); //habilitar
                                } else {
                                    toastr.warning(resp.message);
                                    $('#bntCrearMaterial').attr("disabled", false); //habilitar
                                }
                            }).catch(e => {
                            console.log(e);
                            toastr.warning('No se puede guardar el Material');
                        });
                    } else {
                        $('#bntCrearMaterial').attr("disabled", false); //habilitar
                    }
                });
                //===== Fin-Crear Material =====

            }); //End-document-ready


            function createSolicitudCompra(data){
                if(data !== null && data !== false){
                    var url_save = APP_URL + '/solicitud-de-compras';
                    axios.post(url_save, data)
                        .then(response =>{
                            var resp = response.data;
                            if(!resp.error){
                                toastr.success(resp.message);
                                setTimeout(function (){
                                    window.location.href = APP_URL + '/solicitud-de-compras';
                                }, 1000);
                            }else{
                                toastr.warning(resp.message);
                                $('#guardarSolicitudForm').attr("disabled", false);
                            }
                        }).catch(e => {
                        console.log(e);
                        toastr.error('Ocurrió un error inesperado, contacte al administrador de la aplicación.');
                    });
                }else{
                    toastr.warning('No se puede guardar la solicitud de compra');
                }
            }

            function encontrarDuplicadosPorIdMaterial(listaMateriales, data_new) {
                let contador = 0;
                let duplicado_new = {};

                for (const item_old of listaMateriales) {
                    let idProducto_old = item_old[1]; //producto_id en tabla
                    let idProducto_New = data_new.producto_id;

                    if (idProducto_old == idProducto_New) {
                        contador++;
                        duplicado_new = {...data_new, num_duplicado_order: contador};
                    }
                }

                return duplicado_new;
            }

        </script>
    @endpush

</x-app-layout>
