<x-app-layout>
    <x-slot name="header">
        <h3 class="text-center">
            @if($clonSolicitud == 1) {{ __('Clonar Solicitud de compra') }} @else {{ __('Ver Solicitud de compra') }} @endif
        </h3>
    </x-slot>

    @push('styles')
        <link rel="stylesheet" href="{{asset('plugins2/bootstrap-datepicker/css/bootstrap-datepicker.min.css')}}">
    @endpush

    <div class="bg-white overflow-hidden mt-4">

        @php
        $fecha_solicitud = '';
        $fecha_entrega = '';
        $solicitud_compra_id = 0;
        @endphp

        @if(!empty($solicitud_compra))
            @php
                $fecha_solicitud = $solicitud_compra->fecha_solicitud;
                $fecha_entrega = $solicitud_compra->fecha_entrega;
                $solicitud_compra_id = $solicitud_compra->id;
            @endphp
        {{-- Form --}}
        <div class="mt-4">
            <form id="form_solicitud_compra">
                <div class="shadow">

                    {{-- Datos generales--}}
                    <div class="px-4 py-1">
                        @if($clonSolicitud == 1)
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="codigo" class="form-label">Solicitud compra a clonar</label>
                                <input type="text" class="form-control" name="codigo" id="codigo" value="{{ $solicitud_compra->codigo }}" autocomplete="off" placeholder="Agregar código" tabindex="3" disabled>
                                <x-jet-input-error for="codigo" />
                            </div>
                        </div>
                        @endif
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="obra_id" class="form-label">Obra <span class="_required_">*</span></label>
                                <select class="form-control save-required" id="obra_id" name="obra_id" style="width: 100%;" tabindex="1" disabled>
                                    @if($solicitud_compra->obra)
                                        <option value="{{ $solicitud_compra->obra->id }}" selected="selected">{{ $solicitud_compra->obra->nombre }}</option>
                                    @endif
                                </select>
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="ingeniero_id" class="form-label">ING. <span class="_required_">*</span></label>
                                <select class="form-control save-required" id="ingeniero_id" name="ingeniero_id" style="width: 100%;" tabindex="2" disabled>
                                    @if($solicitud_compra->ingeniero)
                                        <option value="{{ $solicitud_compra->ingeniero->id }}" selected="selected">{{ $solicitud_compra->ingeniero->nombre }}</option>
                                    @endif
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="px-4 py-1">
                        @if($clonSolicitud == 0)
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="codigo" class="form-label">Código</label>
                                <input type="text" class="form-control" name="codigo" id="codigo" value="{{ $solicitud_compra->codigo }}" autocomplete="off" placeholder="Agregar código" tabindex="3" disabled>
                                <x-jet-input-error for="codigo" />
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="fecha_solicitud" class="form-label">Fecha de solicitud</label>
                                <div class="input-group date">
                                    <input type="text" class="form-control" name="fecha_solicitud" id="fecha_solicitud" autocomplete="off" placeholder="dd/mm/yyyy" tabindex="4" readonly disabled>
                                    <div class="input-group-addon">
                                        <i class="fa-regular fa-calendar-days"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="fecha_entrega" class="form-label">Fecha de entrega</label>
                                <div class="input-group date">
                                    <input type="text" class="form-control" name="fecha_entrega" id="fecha_entrega" autocomplete="off" placeholder="dd/mm/yyyy" tabindex="5" @if($clonSolicitud == 0) readonly disabled @endif>
                                    <div class="input-group-addon">
                                        <i class="fa-regular fa-calendar-days"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="observaciones" class="form-label">Comentarios adicionales</label>
                                <textarea class="form-control" name="observaciones" id="observaciones" tabindex="6" disabled>{{ $solicitud_compra->observaciones }}</textarea>
                            </div>
                        </div>
                    </div>
                    {{-- End-Datos generales--}}

                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Materiales</b></h5>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="productos-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                        <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Clave de registro</th>
                                            <th>Clave de Material</th>
                                            <th>Material</th>
                                            <th>Clave de Unidad</th>
                                            <th>Unidad</th>
                                            <th>Cantidad</th>
                                            <th>Área de uso</th>
                                            <th>Marca</th>
                                            <th>Modelo</th>
                                            <th>Observaciones</th>
                                            <th>Clave Comentario Grupal</th>
                                            <th>Comentario Grupal</th>
                                        </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Emails --}}
                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Envio de correo</b></h5>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <label for="emails" class="form-label">Email</label>
                                <input type="text" class="form-control" name="emails" id="emails" value="{{ $solicitud_compra->emails }}" autocomplete="off" placeholder="Agregar Emails" tabindex="7" readonly disabled>
                                <small>Ejemplo: demo@hotmail.com,demo2@gmail.com</small>
                            </div>
                            <div class="col-12">
                                <label for="email_asunto" class="form-label">Asunto</label>
                                <input type="text" class="form-control" name="email_asunto" id="email_asunto" value="{{ $solicitud_compra->email_asunto }}" autocomplete="off" placeholder="Agregar asunto" tabindex="8" readonly disabled>
                            </div>
                            <div class="col-12">
                                <label for="email_contenido" class="form-label">Contenido</label>
                                <textarea class="form-control" name="email_contenido" id="email_contenido" placeholder="Agregar contenido" rows="3" tabindex="9" readonly disabled>{{ $solicitud_compra->email_contenido }}</textarea>

                            </div>
                        </div>
                    </div>
                    {{-- End-Emails --}}

                    <hr>
                    <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                        <a href="{{ route('solicitud-de-compras.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Cancelar</a>
                        @if($clonSolicitud == 1)
                        <button type="button" id="guardarClonSolicitud" class="btn btn-primary text-white" tabindex="10"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar clon</button>
                        @endif
                    </div>
                </div>
            </form>
        </div>
        {{-- End-Form --}}
        @else
            <div class="alert alert-warning" role="alert">
                <h5>La Solicitud de Compra no puede editarse porque ya no se encuentra en estatus pendiente.</h5>
            </div>
            <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                <a href="{{ route('solicitud-de-compras.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Regresar</a>
            </div>
        @endif

    </div>

    @push('scripts')
        <script src="{{ asset('plugins/inputmask/jquery.inputmask.min.js') }}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/locales/bootstrap-datepicker.es.min.js')}}"></script>
        <script src="{{asset('js/admin.js')}}"></script>
        <script type="text/javascript">
            var APP_URL = {!! json_encode(url('/')) !!};
            var $solicitud_compra_id = @json($solicitud_compra_id);

            $(document).ready(function($){
                const productosDT = new DataTable('#productos-datatable', {
                    "dom": '<"top"f><"datatable-scroll"rt><"bottom"ip><"clear">',
                    pageLength: 10,
                    responsive: true,
                    scrollX: false,
                    "language": {
                        "url": APP_URL + "/plugins/DataTables/language.MX.json"
                    },
                    columnDefs: [{ visible: false, targets: [1,2,4,11] }],
                });
                let counter = 1;

                $('#obra_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    minimumResultsForSearch: -1,
                    cache: false,
                });

                $('#ingeniero_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    minimumResultsForSearch: -1,
                    cache: false,
                });

                $('#fecha_solicitud').datepicker({
                    language: 'es',
                    autoclose: true,
                    format: "dd/mm/yyyy",
                    todayHighlight: true,
                    startDate: new Date()
                });
                var fSolicitud = moment('{{ $fecha_solicitud }}').format("DD-MM-YYYY");
                $('#fecha_solicitud').datepicker( 'setDate', fSolicitud );

                $('#fecha_entrega').datepicker({
                    language: 'es',
                    autoclose: true,
                    format: "dd/mm/yyyy",
                    todayHighlight: true,
                    startDate: new Date()
                });

                let fFechaEntrega = '{{ $fecha_entrega }}';
                if(fFechaEntrega){
                    var fEntrega = moment('{{ $fecha_entrega }}').format("DD-MM-YYYY");
                    $('#fecha_entrega').datepicker( 'setDate', fEntrega );
                }

                function addNewRow(data) {
                    var comentarios_material = (data.rel_solicitud_producto_comentario_material) ? data.rel_solicitud_producto_comentario_material.comentarios_material.comentario : "";
                    var comentarios_material_clave = (data.rel_solicitud_producto_comentario_material) ? data.rel_solicitud_producto_comentario_material.comentarios_material.id : "";

                    productosDT.row
                        .add([
                            counter,
                            data.id,
                            data.producto_id,
                            data.producto.nombre,
                            data.unidad_id,
                            data.unidad.nombre,
                            data.cantidad,
                            data.area_de_uso,
                            data.marca,
                            data.modelo,
                            data.observaciones,
                            comentarios_material_clave,
                            comentarios_material,
                        ])
                        .draw(false);
                    counter++;
                }

                //Lista de Productos guardados
                let data_solicitud = @json($solicitud_compra);
                if(data_solicitud != null && data_solicitud != ''){
                    let data_solicitud_compra_producto = data_solicitud.solicitud_compra_producto;
                    $.each(data_solicitud_compra_producto, function (index, val){
                        addNewRow(val);
                    });
                }

                $('#guardarClonSolicitud').off('click');
                $('#guardarClonSolicitud').on('click', function (){
                    $('#guardarClonSolicitud').attr("disabled", true);
                    var id_form_sol = '#form_solicitud_compra';
                    if(validateForm(id_form_sol)){
                        var data = {solicitud_compra_id: $solicitud_compra_id};
                        console.log('data -> ', data);

                        var url_save = APP_URL + '/solicitud-de-compras-save-clon';
                        axios.post(url_save, data)
                            .then(response =>{
                                var resp = response.data;
                                if(!resp.error){
                                    toastr.success(resp.message);
                                    setTimeout(function (){
                                        window.location.href = APP_URL + '/solicitud-de-compras';
                                    }, 1200);
                                }else{
                                    toastr.warning(resp.message);
                                    $('#guardarClonSolicitud').attr("disabled", false);
                                }
                            }).catch(e => {
                            console.log(e);
                            toastr.error('Ocurrió un error inesperado, contacte al administrador de la aplicación.');
                        });
                    }
                });

            }); //End-document-ready

        </script>
    @endpush

</x-app-layout>
