@inject('carbon', 'Carbon\Carbon')
@inject('Functions', 'App\Http\Helpers\FunctionsHelper')
    <!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Pago a proveedor</title>

    @if(env('APP_ENV') == 'production')
        <link rel="stylesheet" href="http://aristamid.com/css/app.css">
        <link href="http://aristamid.com/css/prints-solicitud-pdf.css" media="all" rel="stylesheet" type="text/css" />
    @else
        <link rel="stylesheet" href="{{ base_path('public/css/app.css') }}">
        <link href="{{ base_path('public/css/prints-solicitud-pdf.css') }}" media="all" rel="stylesheet" type="text/css" />
    @endif
</head>
<body>
@foreach($pagos_a_proveedores as $key => $pago_proveedor)

@php
    $obra = $pago_proveedor->obra;
    $proveedor = $pago_proveedor->proveedor;
    $ordenCompra = isset($pago_proveedor->ordenCompra) ? $pago_proveedor->ordenCompra : null;
@endphp

<div class="container-fluid">
{{--    <header>--}}
        <div class="row">
            <div class="col-12">
                <div class="mb-1">
                    <table class="table tabla_sin_border">
                        <tbody>
                            <tr style="padding-bottom: 0!important;">
                                <td width="15%" class="no_border">
                                    @if(env('APP_ENV') == 'production')
{{--                                        <img class="img-logo" src="http://aristamid.com/Logotipo/Logotipo_Original.png" style="width: 100px!important; height: 100px!important;">--}}
                                        <img class="img-logo" src="{{ public_path('Logotipo/Logotipo_Original.png') }}" style="width: 100px!important; height: 100px!important;">
                                    @else
                                        <img class="img-logo" src="{{ public_path('Logotipo/Logotipo_Original.png') }}" style="width: 100px!important; height: 100px!important;">
                                    @endif
                                </td>
                                <td width="55%" class="no_border">
                                    <h1 class="titulo_arista">ARISTA AR SA DE CV</h1>
                                    <p class="direccion_arista">CALLE 19 X 56 NUMERO 363 PLAN DE AYALA NORTE, YUCATAN, CP. 97118</p>
                                    <p class="direccion_arista">RFC: AAR080509D22</p>
                                    <p class="direccion_arista">Tel.:999 944 5327</p>
                                </td>
                                <td width="30%" class="no_border">
                                    <table class="table tabla_con_border" style="margin-bottom: 0!important;">
                                        <thead>
                                            <tr>
                                                <th colspan="2"><p class="_title_requisicion_">PAGO A PROVEEDOR</p></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">N<sup>o</sup></p></td>
                                                <td>
                                                    <p class="_requisicion_dato_">{{ $pago_proveedor->codigo }}</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">OBRA:</p></td>
                                                <td>
                                                    <p class="_requisicion_dato_">{{ $obra->nombre }}</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">ORDEN DE COMPRA:</p></td>
                                                <td>
                                                    <p class="_requisicion_dato_">@if($ordenCompra) {{ $ordenCompra->codigo }}/{{ \Carbon\Carbon::parse($ordenCompra->fecha_orden)->format('Y') }} @else -- @endif</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">FECHA ACTUAL:</p></td>
                                                <td>
                                                    <p class="_requisicion_dato_">{{ $carbon->now()->format('d/m/Y') }}</p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
{{--    </header>--}}

{{--    <section>--}}
        <div class="row">
            <div class="col-12">
                <div class="mt-1">
                    <table class="table tabla_con_border">
                        <thead>
                            <tr class="table_thead_bg_naranja">
                                <th scope="col">CÓDIGO</th>
                                <th scope="col">FECHA DE PAGO</th>
                                <th scope="col">ORDEN DE COMPRA</th>
                                <th scope="col">PROVEEDOR</th>
                                <th scope="col">OBRA</th>
                                <th scope="col">CONCEPTO</th>
                                <th scope="col">IMPORTE</th>
                                <th scope="col">ESTATUS</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="_padding_tb_ text-center">{{ $pago_proveedor->codigo }}</td>
                                <td class="_padding_tb_">{{ $Functions->formatDate($pago_proveedor->fecha_pago) }}</td>
                                <td class="_padding_tb_ text-center">@if($ordenCompra) {{ $ordenCompra->codigo }} @else -- @endif</td>
                                <td class="_padding_tb_ text-center">{{ $proveedor->razon_social }}</td>
                                <td class="_padding_tb_ text-center">{{ $obra->nombre }}</td>
                                <td class="_padding_tb_ text-center">{{ $pago_proveedor->conceptos_materiales }}</td>
                                <td class="_padding_tb_ text-center"><strong>${{ number_format($pago_proveedor->importe, 2) }}</strong></td>
                                <td class="_padding_tb_ text-center">{{ $pago_proveedor->estatus->estatus }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

{{--    </section>--}}

    @if($pago_proveedor->comentarios)
    <section>
        <div class="mt-1">
            <table class="table tabla_con_border">
                <tbody>
                <tr>
                    <td>
                        <p class="text-start">{{ $pago_proveedor->comentarios }}</p>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </section>
    @endif

</div>


@if(!$loop->last)
    <div class="nueva-pagina"></div>
@endif

@endforeach
</body>
</html>
