@inject('carbon', 'Carbon\Carbon')
@inject('Functions', 'App\Http\Helpers\FunctionsHelper')
    <!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Solicitud de compra</title>

    <link rel="stylesheet" href="{{ base_path('public/css/app.css') }}">
    <link href="{{ base_path('public/css/prints-report-solicitud.css') }}" media="all" rel="stylesheet" type="text/css" />
</head>
<body>

<div class="container">

    @foreach($pagos_proveedores as $key => $pago_proveedor)
        @php
            $obra = $pago_proveedor->obra;
            $proveedor = $pago_proveedor->proveedor;
            $ordenCompra = $pago_proveedor->ordenCompra;
        @endphp

        <div class="row">
            <div class="col-12">
                <div class="mb-1">
                    <table class="table tabla_sin_border_">
                        <tbody>
                            <tr style="padding-bottom: 0!important;">
                                <td width="15%" class="no_border" style="border-right-color:#ffffff; border-bottom-color: #ffffff; padding-bottom: 0!important;">
                                    <img class="img-logo" src="{{ public_path('Logotipo/Logotipo_Original.png') }}" style="width: 100px!important; height: 100px!important;">
                                </td>
                                <td width="55%" class="no_border" style="border-right-color:#ffffff; border-bottom-color: #ffffff; padding-bottom: 0!important;">
                                    <h1 class="titulo_arista">ARISTA AR SA DE CV</h1>
                                    <p class="direccion_arista">CALLE 19 X 56 NUMERO 363 PLAN DE AYALA NORTE, YUCATAN, CP. 97118</p>
                                    <p class="direccion_arista">RFC: AAR080509D22</p>
                                    <p class="direccion_arista">Tel.:999 944 5327</p>
                                </td>
                                <td width="30%" class="no_border" style="border-bottom-color: #ffffff; padding-top: 0!important; padding-right: 0!important; padding-bottom: 0!important;">
                                    <table class="table tabla_con_border" style="margin-bottom: 0!important;">
                                        <thead>
                                            <tr>
                                                <th colspan="2"><p class="_title_requisicion_">PAGO A PROVEEDOR</p></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">N<sup>o</sup></p></td>
                                                <td style="border-right-color:#ffffff !important;">
                                                    <p class="_requisicion_dato_">{{ $pago_proveedor->codigo }}</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">OBRA:</p></td>
                                                <td style="border-right-color:#ffffff !important;">
                                                    <p class="_requisicion_dato_">{{ $obra->nombre }}</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">ORDEN DE COMPRA:</p></td>
                                                <td style="border-right-color:#ffffff !important;">
                                                    <p class="_requisicion_dato_">{{ $ordenCompra->codigo }}</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">FECHA ACTUAL:</p></td>
                                                <td style="border-right-color:#ffffff !important;">
                                                    <p class="_requisicion_dato_">{{ $carbon->now()->format('d/m/Y') }}</p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="mt-1">
                    <table class="table tabla_con_borderxxx">
                        <thead>
                            <tr class="table_thead_bg_naranja">
                                <th scope="col">CÓDIGO</th>
                                <th scope="col">FECHA DE PAGO</th>
                                <th scope="col">ORDEN DE COMPRA</th>
                                <th scope="col">PROVEEDOR</th>
                                <th scope="col">OBRA</th>
                                <th scope="col">FACTURA</th>
                                <th scope="col">CONCEPTO</th>
                                <th scope="col">IMPORTE</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="pd_ text-center">{{ $pago_proveedor->codigo }}</td>
                                <td class="pd_">{{ $Functions->formatDate($pago_proveedor->fecha_pago) }}</td>
                                <td class="pd_ text-center">{{ $ordenCompra->codigo }}</td>
                                <td class="pd_ text-center">{{ $proveedor->razon_social }}</td>
                                <td class="pd_ text-center">{{ $obra->nombre }}</td>
                                <td class="pd_ text-center">{{ $pago_proveedor->factura }}</td>
                                <td class="pd_ text-center">{{ $pago_proveedor->conceptos_materiales }}</td>
                                <td class="pd_ text-center"><strong>${{ number_format($pago_proveedor->importe, 2) }}</strong></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>


        @if($pago_proveedor->comentarios)
    <section>
        <div class="mt-1">
            <table class="table">
                <tbody>
                <tr>
                    <td>
                        <p class="text-start">{{ $pago_proveedor->comentarios }}</p>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </section>
    @endif

    @endforeach

</div>

</body>
</html>
