<x-app-layout>
    <x-slot name="header">
        <h3 class="text-center">
            {{ __('Nuevo pago a proveedor') }}
        </h3>
    </x-slot>

    @push('styles')
        <link rel="stylesheet" href="{{asset('plugins2/bootstrap-datepicker/css/bootstrap-datepicker.min.css')}}">
    @endpush

    <div class="bg-white overflow-hidden mt-4">

        {{-- Form --}}
        <div class="mt-4">
            <form id="form_pago_a_proveedor">
                <div class="shadow">

                    {{-- Datos generales--}}
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="orden_compra_id" class="form-label">Orden de compra<span class="_required_">*</span></label>
                                <select class="form-control save-required" id="orden_compra_id" name="orden_compra_id" style="width: 100%;" tabindex="1"></select>
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="fecha_pago" class="form-label">Fecha de pago <span class="_required_">*</span></label>
                                <div class="input-group date">
                                    <input type="text" class="form-control save-required" name="fecha_pago" id="fecha_pago" autocomplete="off" placeholder="dd/mm/yyyy" tabindex="2" readonly>
                                    <div class="input-group-addon">
                                        <i class="fa-regular fa-calendar-days"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <label for="conceptos_materiales" class="form-label">Concepto <span class="_required_">*</span></label>
                                <textarea class="form-control save-required" name="conceptos_materiales" id="conceptos_materiales" placeholder="Agregar concepto" rows="3" tabindex="3"></textarea>
                                <x-jet-input-error for="conceptos_materiales" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="comentarios" class="form-label">Comentario</label>
                                <input type="text" class="form-control" name="comentarios" id="comentarios" autocomplete="off" placeholder="Agregar comentario" tabindex="4">
                            </div>
                        </div>
                    </div>
                    {{-- End-Datos generales--}}

                    {{-- Archivo --}}
                    <div class="px-4 py-1">
                        <div class="row text-center d-flex justify-content-center">
                            <div class="col-12">
                                <label class="form-label">Comprimir archivo PDF</label>
                                <a href="https://www.ilovepdf.com/es/comprimir_pdf" target="_blank">Comprimir archivo</a>
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <!-- <label class="form-label">Subir Archivos</label> -->
                                <input id="url_factura_pdf" name="url_factura_pdf" type="hidden" class="form-control"  >
                                <input id="url_resumen_pdf" name="url_resumen_pdf" type="hidden" class="form-control"  >
                                <form id="uploadForm" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <div class="form-group">
                                        <label for="factura">Subir Factura (PDF)</label>
                                        <div id="dropzone-factura" class="dropzone"></div>
                                    </div>
                                    <div class="form-group">
                                        <label for="resumen">Subir Resumen (PDF)</label>
                                        <div id="dropzone-resumen" class="dropzone"></div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    {{-- End-Archivo --}}

                    {{-- Emails --}}
                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Envio de correo</b></h5>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <label for="emails" class="form-label">Email</label>
                                <input type="text" class="form-control" name="emails" id="emails" autocomplete="off" placeholder="Agregar Emails" tabindex="7">
                                <small>Ejemplo: demo@hotmail.com,demo2@gmail.com</small>
                            </div>
                            <div class="col-12">
                                <label for="email_asunto" class="form-label">Asunto</label>
                                <input type="text" class="form-control" name="email_asunto" id="email_asunto" autocomplete="off" placeholder="Agregar asunto" tabindex="8">
                            </div>
                            <div class="col-12">
                                <label for="email_contenido" class="form-label">Contenido</label>
                                <textarea class="form-control" name="email_contenido" id="email_contenido" placeholder="Agregar contenido" rows="3" tabindex="9"></textarea>

                            </div>
                        </div>
                    </div>
                    {{-- End-Emails --}}

                    <hr>
                    <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                        <a href="{{ route('pagos-a-proveedores.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Cancelar</a>
                        <button type="button" id="guardarPago" class="btn btn-primary text-white" tabindex="10"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar</button>
                    </div>
                </div>
            </form>
        </div>
        {{-- End-Form --}}

    </div>


    @push('scripts')
        <script src="{{ asset('plugins/inputmask/jquery.inputmask.min.js') }}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/locales/bootstrap-datepicker.es.min.js')}}"></script>
        <script src="{{asset('js/admin.js')}}"></script>
        <script type="text/javascript">
            var APP_URL = {!! json_encode(url('/')) !!};

            let currentFileF = null;
            let currentFileP = null;
            $(document).ready(function($){
                Dropzone.autoDiscover = false;
                const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                const dropzoneFactura = new Dropzone("#dropzone-factura", {
                    url: "/pagos-a-proveedores-upload-pdf/factura",
                    maxFiles: 1,
                    acceptedFiles: ".pdf",
                    addRemoveLinks: true,
                    dictDefaultMessage: "Arrastra aquí la factura (PDF) o haz clic para subir",
                    headers: {
                        'X-CSRF-TOKEN': csrfToken,
                    },
                    autoProcessQueue: true,
                    init: function () {
                        this.on("sending", function (file, xhr, formData) {
                            toastr.info("Subiendo archivo.");
                            $('#guardarBtn').attr('disabled', true);
                        });

                        this.on("addedfile", function (file) {
                            if (currentFileF) {
                                const confirmReplace = confirm("Ya tienes un archivo subido. ¿Quieres reemplazarlo?");
                                if (!confirmReplace) {
                                    this.removeFile(file);
                                    return;
                                }
                                this.removeFile(currentFileF);
                                currentFileF = null;
                            }
                            currentFileF = file;
                            this.processQueue();
                        });

                        this.on("complete", function (file) {
                            console.log("Operación completada.");
                            $('#guardarBtn').attr('disabled', false);
                        });
                    },

                    success: function (file, response) {
                        console.log("Factura subida:", response.filePath);
                        toastr.success("Factura subida");
                        $('#url_factura_pdf').val(response.filePath);
                    },
                    removedfile: function (file) {
                        console.log("Factura eliminada:", file);
                        $('#url_factura_pdf').val('');
                        file.previewElement.remove();
                    },
                    error: function (file, errorMessage) {
                        console.error("Error al subir la factura:", errorMessage);
                        toastr.warning("No se pudo subir el archivo al proveedor");
                    },
                });

                const dropzoneResumen = new Dropzone("#dropzone-resumen", {
                    url: "/pagos-a-proveedores-upload-pdf/resumen",
                    maxFiles: 1,
                    acceptedFiles: ".pdf",
                    addRemoveLinks: true,
                    dictDefaultMessage: "Arrastra aquí el resumen (PDF) o haz clic para subir",
                    headers: {
                        'X-CSRF-TOKEN': csrfToken,
                    },
                    init: function () {
                        this.on("sending", function (file, xhr, formData) {
                            toastr.info("Subiendo archivo.");
                            $('#guardarBtn').attr('disabled', true);
                        });

                        this.on("addedfile", function (file) {
                            if (currentFileP) {
                                const confirmReplace = confirm("Ya tienes un archivo subido. ¿Quieres reemplazarlo?");
                                if (!confirmReplace) {
                                    this.removeFile(file);
                                    return;
                                }
                                this.removeFile(currentFileP);
                                currentFileP = null;
                            }
                            currentFileP = file;
                            this.processQueue();
                        });

                        this.on("complete", function (file) {
                            console.log("Operación completada.");
                            $('#guardarBtn').attr('disabled', false);
                        });
                    },
                    success: function (file, response) {
                        console.log("Archivo de resumen subido.:", response.filePath);
                        toastr.success("Archivo resumen subido.");
                        $('#url_resumen_pdf').val(response.filePath);
                    },
                    removedfile: function (file) {
                        console.log("Resumen eliminado:", file);
                        $('#url_resumen_pdf').val('');
                        file.previewElement.remove();
                    },
                    error: function (file, errorMessage) {
                        console.error("Error al subir resumen:", errorMessage);
                        toastr.warning("No se pudo subir el archivo resumen");
                    },
                });

                $('#orden_compra_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    ajax: {
                        dataType: 'json',
                        url: APP_URL + "/get-lista-ordenes-de-compras-select",
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term,
                                type: 'enviar_a_pago_proveedor'
                            }
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                        }
                    },
                    cache: true
                });

                $('#fecha_pago').datepicker({
                    language: 'es',
                    autoclose: true,
                    format: "dd/mm/yyyy",
                    todayHighlight: true,
                    //startDate: new Date()
                });

                $('#guardarPago').off('click');
                $('#guardarPago').on('click', function (){
                    var id_form_ = '#form_pago_a_proveedor';
                    if(validateForm(id_form_)){
                        $('#guardarPago').attr("disabled", true);

                        var data = {
                            orden_compra_id: $('#orden_compra_id').val(),
                            fecha_pago: $('#fecha_pago').val(),
                            conceptos_materiales: $('#conceptos_materiales').val(),
                            comentarios: $('#comentarios').val(),
                            url_factura_pdf: $('#url_factura_pdf').val(),
                            url_resumen_pdf: $('#url_resumen_pdf').val(),
                            emails: $('#emails').val(),
                            email_asunto: $('#email_asunto').val(),
                            email_contenido: $('#email_contenido').val(),
                        };
                        createPagoProveedorServer(data);
                    }
                });

            }); //End-document-ready

            function createPagoProveedorServer(data) {
                if(data !== null && data !== false) {
                    var url_save = APP_URL + '/pagos-a-proveedores';
                    axios.post(url_save, data)
                        .then(response =>{
                            var resp = response.data;
                            if(!resp.error){
                                toastr.success(resp.message);
                                setTimeout(function (){
                                    window.location.href = APP_URL + '/pagos-a-proveedores';
                                }, 1000);
                            }else{
                                toastr.warning(resp.message);
                                $('#guardarPago').attr("disabled", false); //habilitar
                            }
                        }).catch(e => {
                        console.log(e);
                    });
                } else {
                    toastr.warning('No se puede guardar el pago a proveedor');
                }
            }
        </script>

        @if (session()->has('success'))
            <script>
                toastr.success("{{ session('success') }}");
            </script>
        @endif

        @if (session()->has('message'))
            <script>
                toastr.error('Ocurrio un error inesperado.');
            </script>
        @endif

    @endpush

</x-app-layout>
