@inject('carbon', 'Carbon\Carbon')
@inject('Functions', 'App\Http\Helpers\FunctionsHelper')
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Orden de compra</title>

    <link rel="stylesheet" href="{{ base_path('public/css/app.css') }}">
    <script src="{{ base_path('public/js/app.js') }}" defer></script>
    <link href="{{ base_path('public/css/prints-reports.css') }}" media="all" rel="stylesheet" type="text/css" />

</head>
<body>
@php
    $proveedor = $orden_compra->proveedor;
    $lista_materiales = $orden_compra->solicitudCompra->solicitudCompraProducto;
    $lista_anticipos = $orden_compra->ordenCompraAnticipo;
@endphp

<div class="container">
    <section>
        <div class="mb-1">
            <table class="table tabla_sin_border">
                <tbody>
                    <tr>
                        <td width="15%" class="no_border">
                            <img class="img-logo" src="{{ public_path('Logotipo/Logotipo_Original.png') }}" style="width: 100px!important; height: 100px!important;">
                        </td>
                        <td width="55%" class="no_border">
                            <h1 class="titulo_arista">ARISTA AR SA DE CV</h1>
                            <p class="direccion_arista">CALLE 19 X 56 NUMERO 363 PLAN DE AYALA NORTE, YUCATAN, CP. 97118</p>
                            <p class="direccion_arista">RFC: AAR080509D22</p>
                            <p class="direccion_arista">Tel.:999 944 5327</p>
                        </td>
                        <td width="30%" class="no_border">
                            <h1 class="title_oc_header">ORDEN DE COMPRA</h1>
                            <p class="subtitle_oc_header">{{ $orden_compra->codigo }}/{{ \Carbon\Carbon::parse($orden_compra->fecha_orden)->format('Y') }}</p>
                            <h1 class="title_oc_header">OBRA</h1>
                            <p class="subtitle_oc_header">{{ $orden_compra->solicitudCompra->obra->nombre }}</p>
                            <h1 class="title_oc_header">N<sup>o</sup> CONTROL</h1>
                            <p class="subtitle_oc_header">{{ $orden_compra->solicitudCompra->obra->no_control }}</p>
                            <h1 class="title_oc_header">FECHA</h1>
                            <p class="subtitle_oc_header" style="font-weight: normal;">{{ $Functions->formatDateFormat2($orden_compra->fecha_orden) }}</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        {{-- Proveedor datos --}}
        <div class="mt-3">
            <h2 class="title_proveedor_">PROVEEDOR</h2>
            <table class="table tabla_sin_border">
                <tbody>
                    <tr>
                        <td style="width: 50%" class="no_border">
                            <table class="table tabla_sin_border">
                                <tbody>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">NOMBRE:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_" style="font-weight: bold;">{{ $proveedor->razon_social }}</p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">DIRECIÓN:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_">{{ $proveedor->direccion }}</p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">TELÉFONO:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_">{{ $proveedor->telefono }}</p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">CORREO:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_">{{ $proveedor->email }}</p></td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td style="width: 50%" class="no_border">
                            <table class="table tabla_sin_border">
                                <tbody>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">RFC:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_">{{ $proveedor->rfc }}</p></td>
                                    </tr>
                                    <tr>
                                        <th class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">CONTACTO:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_">{{ $proveedor->contacto }}</p></td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        {{-- End-Proveedor-datos --}}

        {{-- Datos Orden de compra --}}
        <div class="mt-3">
            <table class="table tabla_sin_border">
                <tbody>
                    <tr>
                        <td style="width: 40%" class="no_border">
                            <table class="table tabla_sin_border">
                                <tbody>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">L.A.B.:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_"></p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">VÍA:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_"></p>{{ $orden_compra->metodo_envio }}</td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">CONDICIONES DE PAGO:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_"></p>{{ $orden_compra->conticiones_de_pago }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td style="width: 30%" class="no_border">
                            <table class="table tabla_sin_border">
                                <tbody>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">FECHA DE ENTREGA:</p></th>
                                        <td class="no_border">
                                            @if($orden_compra->fecha_entrega)
                                                <p class="oc_datos_text_">{{ $Functions->formatDate($orden_compra->fecha_entrega) }}</p>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">FECHA DE EMBARQUE:</p></th>
                                        <td class="no_border">
                                            @if($orden_compra->fecha_embarque)
                                                <p class="oc_datos_text_">{{ $Functions->formatDate($orden_compra->fecha_embarque) }}</p>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">VENDEDOR:</p></th>
                                        <td class="no_border">
                                            <p class="oc_datos_text_">{{ $orden_compra->vendedor }}</p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td style="width: 30%" class="no_border">
                            <table class="table tabla_sin_border">
                                <tbody>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">CONSIGNAR A:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_">ARISTA AR SA DE CV</p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">FACTURAR A:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_">ARISTA AR SA DE CV</p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">RFC:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_">AAR080509D22</p></td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        {{-- End-Datos Orden de compra --}}
    </section>

    <p class="condiciones_orden_">Previa aceptación de las condiciones e instrucciones que aparecen en esta orden de compra, sírvase enviarnos la &nbsp;<b>&nbsp;orden firmada</b>:</p>

    {{-- Lista materiales --}}
    <section>
        <div class="mt-1">
            <table class="table tabla_sin_border">
                <thead>
                    <tr class="table_thead_bg_naranja">
                        <th scope="col">CÓDIGO</th>
                        <th scope="col">DESCRIPCIÓN</th>
                        <th scope="col">MARCA</th>
                        <th scope="col">MODELO</th>
                        <th scope="col">UNIDAD</th>
                        <th scope="col">CANTIDAD</th>
                        <th scope="col">PRECIO M.N.</th>
                        <th scope="col">IMPORTE M.N</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($lista_materiales as $key => $material)
                    <tr>
                        <td class="_padding_tb_ text-center">{{ $material->producto->codigo }}</td>
                        <td class="_padding_tb_">{{ $material->producto->nombre }}</td>
                        <td class="_padding_tb_">{{ $material->marca }}</td>
                        <td class="_padding_tb_">{{ $material->modelo }}</td>
                        <td class="_padding_tb_">{{ $material->unidad->nombre }}</td>
                        <td class="_padding_tb_">{{ $material->cantidad }}</td>
                        <td class="_padding_tb_">${{ number_format($material->precio_unitario, 2) }}</td>
                        <td class="_padding_tb_">${{ number_format($material->subtotal, 2) }}</td>
                    </tr>
                @endforeach

                {{-- Anticipos mostrar--}}
                @if(count($orden_compra->ordenCompraAnticipo) > 0)
                    <tr>
                        <td class="no_border"></td>
                        <td class="no_border" style="margin-top: 10px !important; padding: 2px !important;">
                            @foreach($lista_anticipos as $key => $anticipo)
                                <div class="box_anticipos_green_">
                                    <p class="anticipos_result_ text-uppercase">{{ $anticipo->comentario }} POR LA CANTIDAD DE <strong>${{ number_format($anticipo->anticipo, 2) }}</strong></p>
                                    <p class="anticipos_result_ text-uppercase">Forma de pago: {{ $anticipo->forma_de_pago }}</p>
                                    <p class="anticipos_result_">{{ $Functions->formatDateFormat2($anticipo->fecha_anticipo) }}</p>
                                </div>
                            @endforeach
                        </td>
                        <td colspan="6" class="no_border"></td>
                    </tr>
                @endif
                {{-- End-Anticipos mostrar--}}


                {{-- Total mostrar--}}
                <tr style="margin-top: 10px!important;">
                    <td colspan="5" class="no_border" style="vertical-align: bottom !important;">
                        <p class="importe_letras">{{ $orden_compra->total_letras }}</p>
                    </td>
                    <td colspan="3" class="no_border">
                        <table class="table table-borderless tabla_sin_border">
                            <tbody>
                                <tr>
                                    <td width="50%" class="bg_box_tabla_naranja"><p class="proveedor_datos_">SUBTOTAL:</p></td>
                                    <td style="width: 50%;">$ {{ number_format($orden_compra->importe_sin_impuestos, 2) }}</td>
                                </tr>
                                <tr>
                                    <td width="50%" class="bg_box_tabla_naranja"><p class="proveedor_datos_">IVA {{ $orden_compra->ivaImpuesto->nombre }}</p></td>
                                    <td>$ {{ number_format($orden_compra->monto_iva, 2) }}</td>
                                </tr>
                                <tr>
                                    <td width="50%" class="bg_box_tabla_naranja"><p class="proveedor_datos_">TOTAL:</p></td>
                                    <td><strong>$ {{ number_format($orden_compra->total, 2) }}</strong></td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
                {{-- End-Total mostrar--}}
                </tbody>
            </table>
        </div>
    </section>
    {{-- End-Lista materiales --}}

    <section>
        <div class="mt-1">
            <table class="table tabla_con_border">
                <tbody>
                    <tr>
                        <td width="90px;" rowspan="2" style="vertical-align: bottom !important;">
                            <p class="no_control_">{{ $orden_compra->solicitudCompra->obra->no_control }}</p>
                            <p class="no_control_" style="margin-bottom: 5px !important;">N<sup>o</sup> CONTROL</p>
                        </td>
                        <td rowspan="2" colspan="3">
                            <p class="footer_oc_">ORDEN COMPRA: {{ $orden_compra->codigo }}/{{ \Carbon\Carbon::parse($orden_compra->fecha_orden)->format('Y') }}</p>
                            <p class="footer_oc_obra_">{{ $orden_compra->solicitudCompra->obra->nombre }}</p>
                            <p class="footer_oc_obra_">OBRA</p>
                        </td>
                        <td height="20px"></td>
                        <td height="20px"></td>
                        <td height="20px"></td>
                        <td height="20px"></td>
                    </tr>
                    <tr>
                        <td>
                            <p class="footer_info_">{{ $orden_compra->solicitudCompra->ingeniero->nombre }}</p>
                            <p class="footer_info_bold">CONTROL OBRA</p>
                        </td>
                        <td>
                            <p class="footer_info_">Marcos Perez</p>
                            <p class="footer_info_bold">RES. DE OBRA</p>
                        </td>
                        <td>
                            <p class="footer_info_">Cindy Sosa</p>
                            <p class="footer_info_bold">ADMINISTRACIÓN</p>
                        </td>
                        <td>
                            <p class="footer_info_">Jorge Romero</p>
                            <p class="footer_info_bold">DIRECCIÓN</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </section>

</div>

<div class="nueva-pagina"></div>

@include('admin.solicitud_de_compras.print_pdf', ['solicitud_compra' => $orden_compra->solicitudCompra])

</body>
</html>
