<x-app-layout>
    <x-slot name="header">
        <h3 class="text-center">
            {{ __('Ordenes de compras') }}
        </h3>
    </x-slot>

    @push('styles')
        <link rel="stylesheet" href="{{asset('plugins2/bootstrap-datepicker/css/bootstrap-datepicker.min.css')}}">
    @endpush

    @php
        $estatus_por_autorizar = $estatus_por_autorizar->clave;
        $estatus_autorizado = $estatus_autorizado->clave;
    @endphp

    <div class="panel">
        <div class="panel-body demo-nifty-alert">
            <div class="container-fluid">

                <div class="row mb-2">
                    <div class="col-12 d-flex justify-content-center">
                        <div class="float-left order-2 pr-1">

                            @can('ordenes_de_compras_create')
                            <a href="{{ route('ordenes-de-compras.create') }}" class="btn btn-primary px-2 py-2 text-white mx-2 mb-1">
                                <i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Crear orden
                            </a>

                            <a href="{{ route('ordenes-de-compras.create') }}?usarSolicitud=false" class="btn btn-primary px-2 py-2 text-white mx-2 mb-1">
                                <i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Crear orden sin solicitud
                            </a>
                            @endcan

{{--                                <a href="" class="btn btn-primary px-2 py-2 text-white">--}}
{{--                                    <i class="fa-solid fa-file-lines"></i>&nbsp;Importar desde excel--}}
{{--                                </a>--}}
                        </div>
                    </div>
                </div>

                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="orden_compra_id_select" class="form-label">Código de O.C.</label>
                                        <select class="form-control" id="orden_compra_id_select" name="orden_compra_id_select"></select>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="proveedor_id" class="form-label">Proveedor</label>
                                        <select class="form-control" id="proveedor_id" name="proveedor_id"></select>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="fecha_orden" class="form-label">Fecha de orden</label>
                                        <div class="input-group date">
                                            <input type="text" class="form-control" name="fecha_orden" id="fecha_orden" autocomplete="off" placeholder="yyyy-mm-dd" readonly>
                                            <div class="input-group-addon">
                                                <i class="fa-regular fa-calendar-days"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="fecha_entrega" class="form-label">Fecha de entrega</label>
                                        <div class="input-group date">
                                            <input type="text" class="form-control" name="fecha_entrega" id="fecha_entrega" autocomplete="off" placeholder="yyyy-mm-dd" readonly>
                                            <div class="input-group-addon">
                                                <i class="fa-regular fa-calendar-days"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="fecha_embarque" class="form-label">Fecha de embarque</label>
                                        <div class="input-group date">
                                            <input type="text" class="form-control" name="fecha_embarque" id="fecha_embarque" autocomplete="off" placeholder="yyyy-mm-dd" readonly>
                                            <div class="input-group-addon">
                                                <i class="fa-regular fa-calendar-days"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="estatus_id" class="form-label">Estatus</label>
                                        <select class="form-control" id="estatus_id" name="estatus_id"></select>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <button type="button" class="js-programmatic-multi-clear btn btn-primary mb-3 text-white mt-4" aria-label="Limpiar todo">Limpiar</button>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12 d-flex justify-content-start">
                                        <button type="button" id="pdf_imprimir_seleccionados" class="btn btn-success text-white mt-2 mb-2" aria-label="Imprimir PDF"><i class="fa-solid fa-print"></i>&nbsp;PDF Imprimir seleccionados</button>
                                    </div>
                                </div>

                                <div class="row mt-3">
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table id="ordenes-compras-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                                <thead>
                                                <tr>
                                                    <th>Clave</th>
                                                    <th>Acciones</th>
                                                    <th>Código</th>
                                                    <th>Clave de Solicitud</th>
                                                    <th>Código de Solicitud</th>
                                                    <th>Obra</th>
                                                    <th>Clave de Proveedor</th>
                                                    <th>Proveedor</th>
                                                    <th>Descripción</th>
                                                    <th>Vendedor</th>
                                                    <th>Método de envío</th>
                                                    <th>Condiciones de pago</th>
                                                    <th>Fecha de orden</th>
                                                    <th>Fecha de entrega</th>
                                                    <th>Fecha de embarque</th>
                                                    <th>Comentarios</th>
                                                    <th>Clave de estatus</th>
                                                    <th>Estatus</th>
                                                    <th>Enviado a pago</th>
                                                    <th>Enviado a pago</th>
                                                    <th>Total materiales $</th>
                                                    <th>Lista de Pagos/Anticipos $</th>
                                                    <th>Total Pagado $</th>
                                                    <th>Anticipo a pagar $</th>
                                                    <th>Pendientes por pagar $</th>
                                                    <th>Comentario Gloria</th>
                                                </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- Modal-Enviar-a-Pago -->
        <div class="modal fade" id="modalEnviarPagoProveedor" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="staticBackdropLabel">Nuevo pago a proveedor</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div id="form_pago_a_proveedor">
                            <div class="px-4 py-1">
                                <div class="row">
                                    <div class="col-12 col-sm-12 col-md-6 col-lg-6 d-none">
                                        <label for="orden_compra_id" class="form-label">Orden de compra<span class="_required_">*</span></label>
                                        <input type="hidden" class="form-control save-required" id="orden_compra_id" name="orden_compra_id">
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                        <label for="fecha_pago" class="form-label">Fecha de pago <span class="_required_">*</span></label>
                                        <div class="input-group date">
                                            <input type="text" class="form-control save-required" name="fecha_pago" id="fecha_pago" autocomplete="off" placeholder="dd/mm/yyyy" tabindex="2" readonly>
                                            <div class="input-group-addon">
                                                <i class="fa-regular fa-calendar-days"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col">
                                        <label for="conceptos_materiales" class="form-label">Concepto <span class="_required_">*</span></label>
                                        <textarea class="form-control save-required" name="conceptos_materiales" id="conceptos_materiales" placeholder="Agregar concepto" rows="3" tabindex="3"></textarea>
                                        <x-jet-input-error for="conceptos_materiales" />
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col">
                                        <label for="comentarios" class="form-label">Comentario</label>
                                        <input type="text" class="form-control" name="comentarios" id="comentarios" autocomplete="off" placeholder="Agregar comentario" tabindex="4">
                                    </div>
                                </div>
                                <div class="row text-center d-flex justify-content-center">
                                    <div class="col-12">
                                        <label class="form-label">Comprimir archivo PDF</label>
                                        <a href="https://www.ilovepdf.com/es/comprimir_pdf" target="_blank">Comprimir archivo</a>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                        <input id="url_factura_pdf" name="url_factura_pdf" type="hidden" class="form-control"  >
                                        <input id="url_resumen_pdf" name="url_resumen_pdf" type="hidden" class="form-control"  >
                                        <form id="uploadForm" method="POST" enctype="multipart/form-data">
                                            @csrf
                                            <div class="form-group">
                                                <label for="factura">Subir Factura (PDF)</label>
                                                <div id="dropzone-factura" class="dropzone"></div>
                                            </div>
                                            <div class="form-group">
                                                <label for="resumen">Subir Resumen (PDF)</label>
                                                <div id="dropzone-resumen" class="dropzone"></div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            {{-- Emails --}}
                            <hr>
                            <div class="px-4 py-1">
                                <div class="row">
                                    <div class="col">
                                        <h5 class="text-center"><b>Envio de correo</b></h5>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label for="emails" class="form-label">Email</label>
                                        <input type="text" class="form-control" name="emails" id="emails" autocomplete="off" placeholder="Agregar Emails" tabindex="7">
                                        <small>Ejemplo: demo@hotmail.com,demo2@gmail.com</small>
                                    </div>
                                    <div class="col-12">
                                        <label for="email_asunto" class="form-label">Asunto</label>
                                        <input type="text" class="form-control" name="email_asunto" id="email_asunto" autocomplete="off" placeholder="Agregar asunto" tabindex="8">
                                    </div>
                                    <div class="col-12">
                                        <label for="email_contenido" class="form-label">Contenido</label>
                                        <textarea class="form-control" name="email_contenido" id="email_contenido" placeholder="Agregar contenido" rows="3" tabindex="9"></textarea>

                                    </div>
                                </div>
                            </div>
                            {{-- End-Emails --}}
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i>&nbsp;Cerrar</button>
                        <button type="button" id="guardarPagoProveedor" class="btn btn-primary text-white" tabindex="8"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar</button>
                    </div>
                </div>
            </div>
        </div>
        <!-- Fin-Modal-Enviar-a-Pago -->

        @push('scripts')
            <script src="{{asset('plugins2/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>
            <script src="{{asset('plugins2/bootstrap-datepicker/locales/bootstrap-datepicker.es.min.js')}}"></script>
            <script src="{{asset('js/admin.js')}}"></script>
            <script type="text/javascript">
                var APP_URL = {!! json_encode(url('/')) !!};
                var ordenes_compras_DT = null;
                let currentFileF = null;
                let currentFileP = null;
                var $ordenes_de_compras_show = @json($ordenes_de_compras_show);
                var $ordenes_de_compras_edit = @json($ordenes_de_compras_edit);
                var $ordenes_de_compras_destroy = @json($ordenes_de_compras_destroy);
                var $ordenes_de_compras_export = @json($ordenes_de_compras_export);
                var $ordenes_de_compras_send_email = @json($ordenes_de_compras_send_email);
                var $ordenes_de_compras_authorized = @json($ordenes_de_compras_authorized);
                var $ordenes_de_compras_enviar_a_pago = @json($ordenes_de_compras_enviar_a_pago);
                //Estatus
                var estatus_por_autorizar = @json($estatus_por_autorizar);
                var estatus_autorizado = @json($estatus_autorizado);

                var timerDT; //timer

                $(document).ready(function() {
                    Dropzone.autoDiscover = false;
                    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                    const dropzoneFactura = new Dropzone("#dropzone-factura", {
                        url: "/pagos-a-proveedores-upload-pdf/factura",
                        maxFiles: 1,
                        acceptedFiles: ".pdf",
                        addRemoveLinks: true,
                        dictDefaultMessage: "Arrastra aquí la factura (PDF) o haz clic para subir",
                        headers: {
                            'X-CSRF-TOKEN': csrfToken,
                        },
                        autoProcessQueue: true,
                        init: function () {
                            this.on("sending", function (file, xhr, formData) {
                                toastr.info("Subiendo archivo.");
                                $('#guardarPagoProveedor').attr('disabled', true);
                            });

                            this.on("addedfile", function (file) {
                                if (currentFileF) {
                                    const confirmReplace = confirm("Ya tienes un archivo subido. ¿Quieres reemplazarlo?");
                                    if (!confirmReplace) {
                                        this.removeFile(file);
                                        return;
                                    }
                                    this.removeFile(currentFileF);
                                    currentFileF = null;
                                }
                                currentFileF = file;
                                this.processQueue();
                            });

                            this.on("complete", function (file) {
                                console.log("Operación completada.");
                                $('#guardarPagoProveedor').attr('disabled', false);
                            });
                        },

                        success: function (file, response) {
                            console.log("Factura subida:", response.filePath);
                            toastr.success("Factura subida");
                            $('#url_factura_pdf').val(response.filePath);
                        },
                        removedfile: function (file) {
                            console.log("Factura eliminada:", file);
                            $('#url_factura_pdf').val('');
                            file.previewElement.remove();
                        },
                        error: function (file, errorMessage) {
                            console.error("Error al subir la factura:", errorMessage);
                            toastr.warning("No se pudo subir el archivo factura");
                        },
                    });

                    const dropzoneResumen = new Dropzone("#dropzone-resumen", {
                        url: "/pagos-a-proveedores-upload-pdf/resumen",
                        maxFiles: 1,
                        acceptedFiles: ".pdf",
                        addRemoveLinks: true,
                        dictDefaultMessage: "Arrastra aquí el resumen (PDF) o haz clic para subir",
                        headers: {
                            'X-CSRF-TOKEN': csrfToken,
                        },
                        init: function () {
                            this.on("sending", function (file, xhr, formData) {
                                toastr.info("Subiendo archivo.");
                                $('#guardarPagoProveedor').attr('disabled', true);
                            });

                            this.on("addedfile", function (file) {
                                if (currentFileP) {
                                    const confirmReplace = confirm("Ya tienes un archivo subido. ¿Quieres reemplazarlo?");
                                    if (!confirmReplace) {
                                        this.removeFile(file);
                                        return;
                                    }
                                    this.removeFile(currentFileP);
                                    currentFileP = null;
                                }
                                currentFileP = file;
                                this.processQueue();
                            });

                            this.on("complete", function (file) {
                                console.log("Operación completada.");
                                $('#guardarPagoProveedor').attr('disabled', false);
                            });
                        },
                        success: function (file, response) {
                            console.log("Archivo resumen subido.:", response.filePath);
                            toastr.success("Archivo resumen subido.");
                            $('#url_resumen_pdf').val(response.filePath);
                        },
                        removedfile: function (file) {
                            console.log("resumen eliminado:", file);
                            $('#url_resumen_pdf').val('');
                            file.previewElement.remove();
                        },
                        error: function (file, errorMessage) {
                            console.error("Error al subir resumen:", errorMessage);
                            toastr.warning("No se pudo subir el archivo resumen");
                        },
                    });

                    const myModalPago = document.getElementById('modalEnviarPagoProveedor');
                    myModalPago.addEventListener('hidden.bs.modal', event => {
                        $('#orden_compra_id').val('');
                        $('#fecha_pago').val('');
                        $("#conceptos_materiales").val("");
                        $("#comentarios").val("");
                    });

                    //Buscar por orden compra
                    $('#orden_compra_id_select').select2({
                        width: '100%',
                        theme: "bootstrap",
                        placeholder: 'Selecciona una opción',
                        ajax: {
                            dataType: 'json',
                            url: APP_URL + "/get-lista-ordenes-de-compras-select",
                            delay: 250,
                            data: function(params) {
                                return {
                                    search: params.term,
                                    type: 'filtro_oc_all'
                                }
                            },
                            processResults: function (data, page) {
                                return {
                                    results: data
                                };
                            }
                        },
                        cache: true
                    });

                    //Buscar por proveedor
                    $('#proveedor_id').select2({
                        width: '100%',
                        theme: "bootstrap",
                        placeholder: 'Selecciona una opción',
                        ajax: {
                            dataType: 'json',
                            url: APP_URL + "/get-lista-proveedores-select",
                            delay: 250,
                            data: function(params) {
                                return {
                                    search: params.term
                                }
                            },
                            processResults: function (data, page) {
                                return {
                                    results: data
                                };
                            }
                        },
                        cache: true
                    });

                    $('#fecha_orden').datepicker({
                        language: 'es',
                        autoclose: true,
                        format: "yyyy-mm-dd",
                        todayHighlight: true
                    });

                    $('#fecha_entrega').datepicker({
                        language: 'es',
                        autoclose: true,
                        format: "yyyy-mm-dd",
                        todayHighlight: true
                    });

                    $('#fecha_embarque').datepicker({
                        language: 'es',
                        autoclose: true,
                        format: "yyyy-mm-dd",
                        todayHighlight: true
                    });

                    $('#estatus_id').select2({
                        width: '100%',
                        theme: "bootstrap",
                        placeholder: 'Selecciona una opción',
                        cache: true,
                        ajax: {
                            dataType: 'json',
                            url: APP_URL + "/get-lista-estatus-select",
                            delay: 250,
                            data: function(params) {
                                return {
                                    search: params.term,
                                    type: 'orden_compras'
                                }
                            },
                            processResults: function (data, page) {
                                return {
                                    results: data
                                };
                            }
                        },
                    });

                    ordenes_compras_DT = new DataTable('#ordenes-compras-datatable', {
                        lengthMenu: [[1,2,3,4,5,6,7,8,9,10,15,20,25,50,100,-1], [1,2,3,4,5,6,7,8,9,10,15,20,25,50,100, 'Todos']],
                        processing: true,
                        serverSide: true,
                        autoWidth: false,
                        pageLength: 10,
                        responsive: true,
                        scrollX: false,
                        fixedColumns: true,
                        fixedHeader: false,
                        select: {style:'multi'},
                        "language": {
                            "url": "../../plugins/DataTables/language.MX.json"
                        },
                        "order": [[ 0, "desc" ]],
                        ajax: {
                            url: '{{ route('ordenes-de-compras.get-lista-ordenes-compras') }}',
                            method: 'get',
                        },
                        columns: [
                            {data: 'id', name: 'id'},
                            {
                                data: null,
                                render: function(data, type, full, meta){
                                    var botones = '';
                                    if ($ordenes_de_compras_export){
                                        botones += '<a href="/ordenes-de-compras-print-pdf/'+ data["id"] +'" class="btn btn-primary text-white mb-2 me-1" title="Imprimir" target="_blank">' +
                                            '<i class="fa-solid fa-print"></i>&nbsp;Imprimir PDF</a>';
                                    }
                                    if ($ordenes_de_compras_show){
                                        botones += '<a href="/ordenes-de-compras/'+ data["id"] +'" class="btn btn-success text-white mb-2 me-1" title="Ver información">' +
                                            '<i class="fa-regular fa-eye"></i>&nbsp;Información</a>';
                                    }
                                    if ($ordenes_de_compras_edit){
                                        botones += '<a href="/ordenes-de-compras/' + data["id"] + '/edit/" class="btn btn-primary text-white mb-2 me-1" title="Editar">' +
                                            '<i class="fa-sharp fa-solid fa-pen-to-square"></i>&nbsp;Editar</a>';
                                    }
                                    if ($ordenes_de_compras_authorized && data.estatus.clave === estatus_por_autorizar) {
                                        botones += '<button id="btn_autorizado-'+ data["id"] +'" data-id="'+ data["id"] +'" class="btn_autorizado btn btn-success text-white mb-2 me-1" title="Autorizado">' +
                                            '<i class="fa-solid fa-arrow-up-right-from-square"></i>&nbsp;Autorizado</button>';
                                    }
                                    // if($ordenes_de_compras_authorized && data.estatus.clave === estatus_autorizado && data["enviado_a_pago"] == 0){
                                    //     botones += '<button id="btn_por_autorizar-'+ data["id"] +'" data-id="'+ data["id"] +'" class="btn_por_autorizar btn btn-success text-white mb-2 me-1" title="Por Autorizar">' +
                                    //         '<i class="fa-solid fa-rotate-left"></i>&nbsp;Regresar a Por Autorizar</button>';
                                    // }
                                    if($ordenes_de_compras_enviar_a_pago && data.estatus.clave === estatus_autorizado && data["enviado_a_pago"] == 0){
                                        botones += '<button id="btn_enviar_a_pago-'+ data["id"] +'" data-id="'+ data["id"] +'" class="btn_enviar_a_pago btn btn-secondary text-white mb-2 me-1" title="Enviar a Pago">' +
                                            '<i class="fa-solid fa-arrow-up-right-from-square"></i>&nbsp;Enviar a Pago</button>';
                                    }
                                    if ($ordenes_de_compras_destroy && data.estatus.clave === estatus_por_autorizar) {
                                        botones += '<button id="btn-eliminar-'+ data["id"] +'" data-id="' + data["id"] + '" class="btn_delete btn btn-danger text-white mb-2 me-1" title="Eliminar">' +
                                            '<i class="fa-sharp fa-solid fa-trash-can"></i>&nbsp;Eliminar</button>';
                                    }
                                    if($ordenes_de_compras_send_email){
                                        botones += '<button id="btn_enviar_correo-'+ data["id"] +'" data-id="'+ data["id"] +'" data-emails="'+ data["emails"] +'" class="btn_enviar_correo btn btn-success text-white mb-2 me-1" title="Enviar correo">' +
                                            '<i class="fa-solid fa-envelope"></i>&nbsp;Enviar correo</button>';
                                    }
                                    return botones;
                                }
                            },
                            {data: 'codigo', name: 'codigo', visible: false},
                            {data: 'solicitud_compra_id', name: 'solicitud_compra_id', visible: false},
                            {data: 'solicitud_compra.codigo', name: 'solicitud_compra_codigo', visible: false},
                            {data: 'solicitud_compra.obra.nombre', name:'obra_nombre'},
                            {data: 'proveedor_id', name: 'proveedor_id', visible: false},
                            {data: 'proveedor.razon_social', name: 'proveedor_razon_social'},
                            {data: 'conceptos_materiales', name: 'conceptos_materiales'},
                            {data: 'vendedor', name: 'vendedor', visible: false},
                            {data: 'metodo_envio', name: 'metodo_envio', visible: false},
                            {data: 'conticiones_de_pago', name: 'conticiones_de_pago', visible: false},
                            {data: 'fecha_orden', name: 'fecha_orden', visible: false},
                            {data: 'fecha_entrega', name: 'fecha_entrega'},
                            {data: 'fecha_embarque', name: 'fecha_embarque', visible: false},
                            {data: 'comentarios', name: 'comentarios'},
                            {data: 'estatus_id', name: 'estatus_id', visible: false},
                            {data: 'estatus.estatus', name: 'estatus_estatus'},
                            {
                                data: 'enviado_a_pago', name: 'enviado_a_pago',
                                render: function( data, type, full, meta ){
                                    var isActivo = (data == 1) ? '<i class="fas fa-check text-success"></i>' : '<i class="fas fa-times text-danger"></i>';
                                    return isActivo;
                                }
                            },
                            {
                                data: 'enviado_a_pago', name: 'enviado_a_pago', visible: false,
                                render: function( data, type, full, meta ){
                                    var isActivo = (data == 1) ? 'SI' : 'NO';
                                    return isActivo;
                                }
                            },
                            {
                                data: 'total', name: 'total',
                                render: function( data, type, full, meta ){
                                    var total = (data) ? data : 0;
                                    return total;
                                }
                            },
                            {
                                data: 'orden_compra_anticipo', name: 'orden_compra_anticipo', visible: false,
                                render: function( data, type, full, meta ){
                                    let tablaPagos = '';
                                    if (data.length > 0){
                                        $.each(data, function (index, val){
                                            if(val.tipo_pago !== null){
                                                if (val.es_ultimo){
                                                    var tipo_pago_nombre = (val.tipo_pago.nombre == 'Anticipos') ? 'Último anticipo' : val.tipo_pago.nombre;
                                                    tablaPagos+='<b class="text-danger">'+ tipo_pago_nombre +': $' + val.anticipo +'</b>';
                                                } else {
                                                    tablaPagos+=val.tipo_pago.nombre + ': $' + val.anticipo +'<br>';
                                                }
                                            }else{
                                                tablaPagos='<p class="text-danger">Por favor asigne un Tipo de Pago para mostrar el listado.</p>';
                                            }
                                        });
                                    } else {
                                        tablaPagos='--';
                                    }
                                    return tablaPagos;
                                }
                            },
                            {
                                data: 'total_sum_anticipos', name: 'total_sum_anticipos', visible: false,
                                render: function( data, type, full, meta ){
                                    var total = (data) ? data : 0;
                                    return total;
                                }
                            },
                            {
                                data: 'orden_compra_anticipo', name: 'orden_compra_anticipo', visible: false,
                                render: function( data, type, full, meta ){
                                    let saldoPorPagarHoy = 'N/A';
                                    if (data.length > 0){
                                        $.each(data, function (index, val){
                                            if(val.tipo_pago !== null && val.tipo_pago.nombre === 'Anticipos' && val.es_ultimo){
                                                var tipo_pago_nombre = (val.tipo_pago.nombre == 'Anticipos') ? 'Por pagar' : val.tipo_pago.nombre;
                                                saldoPorPagarHoy ='<b class="text-danger">'+ tipo_pago_nombre +': $' + val.anticipo +'</b>';
                                            }
                                        });
                                    } else {
                                        saldoPorPagarHoy='--';
                                    }
                                    return saldoPorPagarHoy;
                                }
                            },
                            {
                                data: 'pendiente_por_pagar', name: 'pendiente_por_pagar', visible: false,
                                render: function( data, type, full, meta ){
                                    var pendientePago = (data) ? data : 0;
                                    return pendientePago;
                                }
                            },
                            {data: 'comentario_gloria', name: 'comentario_gloria', visible: false,},
                        ],
                        layout: {
                            top1Start: {
                                buttons: [
                                    {
                                        extend: 'excel',
                                        text: '<i class="fa-solid fa-file-lines"></i> Imprimir Excel',
                                        messageTop: 'Ordenes de compras',
                                        exportOptions: {
                                            //columns: [0,1,3,5,6,7,8,9,10,11,12,14,16,17,18],
                                            columns: ':visible'
                                        },
                                        className: 'btn btn-primary',
                                        excelStyles: [
                                            // {
                                            //     template: "blue_gray_medium",
                                            // },
                                            {
                                                cells: "3",
                                                style: {
                                                    font: {
                                                        name: "Arial",
                                                        size: "14",
                                                        color: "FFFFFF",
                                                        b: false,
                                                    },
                                                    fill: {
                                                        pattern: {
                                                            color: "E0592A",
                                                        }
                                                    }
                                                },
                                            },
                                        ]
                                    },
                                    {
                                        extend: 'print',
                                        text: '<i class="fa-solid fa-file-lines"></i> Imprimir avanzado',
                                        messageTop: 'Ordenes de compras',
                                        exportOptions: {
                                            //columns: [0,1,3,5,6,7,8,9,10,11,12,14,16,17,18],
                                            columns: ':visible'
                                        },
                                        className: 'btn btn-primary',
                                        customize: function (win) {
                                            $(win.document.body)
                                                .css('font-size', '10px')
                                                .prepend(
                                                    '<img src="{{ asset('Logotipo/Logotipo_Original.png') }}" width="100px" height="100px" style="position:relative; top:0; left:0;" />'
                                                );

                                            $(win.document.body)
                                                .find('table')
                                                .addClass('compact')
                                                .css('font-size', 'inherit');
                                        }
                                    },
                                    'colvis'
                                ]
                            }
                        },
                        createdRow: function(row, data, dataIndex) {
                            $(row).attr('id', data.id);
                            $(row).attr('rowIndex', dataIndex);
                        },
                        columnDefs: [
                            { targets: [1,2], className: "text-center", orderable: true },
                            //{ visible: false, targets: [2,4,14] },
                        ]
                    }).on( 'page.dt', function () {
                        var info = ordenes_compras_DT.page.info();
                        clearTimeout(timerDT);
                        timerDT = setTimeout(function() {
                            ordenes_compras_DT.columns.adjust();
                            ordenes_compras_DT.columns.adjust().responsive.recalc();
                        }, 1000);
                    });

                    // row selected
                    ordenes_compras_DT.on('click', 'tbody tr', (e) => {
                        e.currentTarget.classList.toggle('selected');
                    });

                    //Buscar por clave de O.C.
                    $('#orden_compra_id_select').on('select2:select', function (e) {
                        var data = e.params.data;
                        ordenes_compras_DT.columns(0).search('^' + data.id + '$', true, false, true).draw();
                    });

                    //Buscar por Clave de Proveedor
                    $('#proveedor_id').on('select2:select', function (e) {
                        var data = e.params.data;
                        ordenes_compras_DT.columns(6).search(data.id).draw();
                    });

                    //Buscar por Fecha de orden
                    $('#fecha_orden').change(function (e) {
                        var fecha_orden = $('#fecha_orden').val();
                        ordenes_compras_DT.columns(12).search(fecha_orden).draw();
                    });

                    //Buscar por Fecha de entrega
                    $('#fecha_entrega').change(function (e) {
                        var fecha_entrega = $('#fecha_entrega').val();
                        ordenes_compras_DT.columns(13).search(fecha_entrega).draw();
                    });

                    //Buscar por Fecha de embarque
                    $('#fecha_embarque').change(function (e) {
                        var fecha_embarque = $('#fecha_embarque').val();
                        ordenes_compras_DT.columns(14).search(fecha_embarque).draw();
                    });

                    //Buscar por calve de Estatus
                    $('#estatus_id').on('select2:select', function (e) {
                        var data = e.params.data;
                        ordenes_compras_DT.columns(16).search(data.id).draw();
                    });

                    $(".js-programmatic-multi-clear").on("click", function () {
                        $('#orden_compra_id_select').val('').trigger('change');
                        $('#proveedor_id').val('').trigger('change');
                        $('#fecha_orden').val('');
                        $('#fecha_entrega').val('');
                        $('#fecha_embarque').val('');
                        $('#estatus_id').val(null).trigger('change');
                        ordenes_compras_DT.columns([0,6,12,13,14,16]).search('').draw();
                    });

                    $('#pdf_imprimir_seleccionados').off('click');
                    $("#pdf_imprimir_seleccionados").on("click", function () {
                        $('#pdf_imprimir_seleccionados').attr("disabled", true);
                        var selectedRows = ordenes_compras_DT.rows('.selected').data().toArray();
                        if(selectedRows.length <= 10) {
                            imprimir_pdf(selectedRows);
                        } else {
                            toastr.warning('No se puede imprimir más de 10 Ordenes de compras.');
                            $('#pdf_imprimir_seleccionados').attr("disabled", false);
                        }
                    });

                    $('#ordenes-compras-datatable tbody').on('click', '.btn_autorizado', function (e){
                        e.preventDefault();
                        var id_orden = $(this).data('id');
                        var data = {
                            id_orden: id_orden,
                            estatus_id: 3, //Autorizado
                        };
                        update_Estatus_Autorizado(data);
                    });

                    $('#ordenes-compras-datatable tbody').on('click', '.btn_por_autorizar', function (e){
                        e.preventDefault();
                        var id_orden = $(this).data('id');
                        var data = {
                            id_orden: id_orden,
                            estatus_id: 2, //Por Autorizar
                        };
                        update_Estatus_Por_Autorizar(data);
                    });

                    $('#fecha_pago').datepicker({
                        language: 'es',
                        autoclose: true,
                        format: "dd/mm/yyyy",
                        todayHighlight: true,
                        //startDate: new Date()
                    });

                    $('#ordenes-compras-datatable tbody').on('click', '.btn_enviar_a_pago', function (e){
                        e.preventDefault();
                        var id_orden = $(this).data('id');
                        $('#modalEnviarPagoProveedor').modal('show');
                        $('#orden_compra_id').val(id_orden);
                    });

                    $('#ordenes-compras-datatable tbody').on('click', '.btn_delete', function (e){
                        e.preventDefault();
                        var id_orden = $(this).data('id');
                        delete_orden(id_orden);
                    });

                    $('#ordenes-compras-datatable tbody').on('click', '.btn_enviar_correo', function (e){
                        e.preventDefault();
                        var id_orden = $(this).data('id');
                        var emails = $(this).data('emails');
                        $('#btn_enviar_correo-'+id_orden).attr("disabled", true);
                        $('.btn_enviar_correo').attr("disabled", true);
                        if (emails !== '' && emails !== null){
                            enviarCorreoServer(id_orden);
                        } else {
                            toastr.warning('No se puede enviar el correo, agrega al menos uno.');
                            $('#btn_enviar_correo-'+id_orden).attr("disabled", false); //habilitar
                            $('.btn_enviar_correo').attr("disabled", false);
                        }
                    });

                    function update_Estatus_Autorizado(data){
                        if(data !== null && data !== false){
                            Swal.fire({
                                title: "¿Está seguro de que desea Autorizar la orden de compra?",
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Si, Autorizar!",
                                cancelButtonText: "No, cancelar!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    var url_ = APP_URL + '/orden-de-compra-update-estatus';
                                    axios.post(url_, data)
                                        .then(response => {
                                            var resp = response.data;
                                            if(!resp.error){
                                                toastr.success(resp.message);
                                                var paginaActual = ordenes_compras_DT.page.info().page;
                                                ordenes_compras_DT.draw(true);
                                                ordenes_compras_DT.page(paginaActual).draw(false);
                                            }else{
                                                toastr.warning(resp.message);
                                            }
                                        }).catch(e => {
                                        console.log(e);
                                        toastr.error('Ocurrio un error inesperado.');
                                    });
                                }
                            });
                        }else{
                            toastr.warning('No se pudo actualizar el estatus Autorizado, intente de nuevo, si el problema persiste comunicarse con el administrador de la aplicación.');
                        }
                    }

                    $('#guardarPagoProveedor').off('click');
                    $('#guardarPagoProveedor').on('click', function (){
                        var id_form_ = '#form_pago_a_proveedor';
                        if(validateForm(id_form_)){
                            $('#guardarPagoProveedor').attr("disabled", true);

                            var data = {
                                orden_compra_id: $('#orden_compra_id').val(),
                                fecha_pago: $('#fecha_pago').val(),
                                conceptos_materiales: $('#conceptos_materiales').val(),
                                comentarios: $('#comentarios').val(),
                                url_factura_pdf: $('#url_factura_pdf').val(),
                                url_resumen_pdf: $('#url_resumen_pdf').val(),
                                emails: $('#emails').val(),
                                email_asunto: $('#email_asunto').val(),
                                email_contenido: $('#email_contenido').val(),
                            };
                            createPagoProveedorServer(data);
                        }
                    });

                    function delete_orden(id) {
                        if (id > 0 && id !== null && id !== "") {
                            Swal.fire({
                                title: "¿Está seguro de que desea eliminar la orden?",
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Si, eliminar!",
                                cancelButtonText: "No, cancelar!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    var url = APP_URL + '/ordenes-de-compras/'+id;
                                    axios.delete(url)
                                        .then(response => {
                                            var resp = response.data;
                                            if(!resp.error){
                                                toastr.success(resp.message);
                                                ordenes_compras_DT.draw(true);
                                            }else{
                                                toastr.warning('No se pudo eliminar el registro');
                                            }
                                        }).catch(e => {
                                        console.log(e);
                                        toastr.error('Ocurrio un error inesperado.');
                                    });
                                }
                            });

                        } else {
                            toastr.warning('Parametro incompleto para eliminar el registro');
                        }
                    }

                }); //End-document-ready

                function createPagoProveedorServer(data) {
                    if(data !== null && data !== false) {
                        var url_save = APP_URL + '/pagos-a-proveedores';
                        axios.post(url_save, data)
                            .then(response =>{
                                var resp = response.data;
                                if(!resp.error){
                                    toastr.success(resp.message);
                                    $('#modalEnviarPagoProveedor').modal('hide');
                                    var paginaActual = ordenes_compras_DT.page.info().page;
                                    ordenes_compras_DT.draw(true);
                                    ordenes_compras_DT.page(paginaActual).draw(false);
                                }else{
                                    toastr.warning(resp.message);
                                }
                                $('#guardarPagoProveedor').attr("disabled", false); //habilitar
                            }).catch(e => {
                            console.log(e);
                        });
                    } else {
                        toastr.warning('No se puede guardar el pago a proveedor');
                    }
                }

                function enviarCorreoServer(clave){
                    if(clave !== null && clave !== ''){
                        var url_save = APP_URL + '/ordenes-de-compras-print-pdf/' + clave + '/1';
                        axios.get(url_save)
                            .then(response =>{
                                var resp = response.data;
                                if(!resp.error){
                                    toastr.success('Correo electrónico enviado con éxito.');
                                }else{
                                    toastr.warning('Ocurrio un error al enviar el correo, contacte al administrador del sistema.');
                                }
                                $('#btn_enviar_correo-'+clave).attr("disabled", false); //habilitar
                                $('.btn_enviar_correo').attr("disabled", false);
                            }).catch(e => {
                            console.log(e);
                        });
                    } else {
                        toastr.warning('No se puede enviar el correo, faltan parámetros.');
                    }
                }

                function imprimir_pdf(data) {
                    if(data.length > 0){
                        var url_ = APP_URL + '/ordenes-de-compras-print-pdf-list-selected';
                        axios.post(url_, data)
                            .then(response => {
                                var resp = response.data;
                                if(!resp.error){
                                    toastr.success(resp.message);
                                    ordenes_compras_DT.draw(true);
                                    var href = APP_URL + '/' + resp.archivo_url;
                                    window.open(href, '_blank');
                                }else{
                                    toastr.warning(resp.message);
                                }
                                $('#pdf_imprimir_seleccionados').attr("disabled", false);
                            }).catch(e => {
                            console.log(e);
                            toastr.error('Ocurrio un error inesperado.');
                        });
                    } else {
                        toastr.warning('Debe seleccionar al menos una orden de compra.');
                        $('#pdf_imprimir_seleccionados').attr("disabled", false);
                    }
                }

                function update_Estatus_Por_Autorizar(data){
                    if(data !== null && data !== false){
                        Swal.fire({
                            title: "¿Está seguro que desea regresar el estatus Por Autorizar la orden de compra?",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#3085d6",
                            cancelButtonColor: "#d33",
                            confirmButtonText: "Si, Por Autorizar!",
                            cancelButtonText: "No, cancelar!",
                        }).then((result) => {
                            if (result.isConfirmed) {
                                var url_ = APP_URL + '/orden-de-compra-update-estatus-por-autorizar';
                                axios.post(url_, data)
                                    .then(response => {
                                        var resp = response.data;
                                        if(!resp.error){
                                            toastr.success(resp.message);
                                            ordenes_compras_DT.draw(true);
                                        }else{
                                            toastr.warning(resp.message);
                                        }
                                    }).catch(e => {
                                    console.log(e);
                                    toastr.error('Ocurrio un error inesperado.');
                                });
                            }
                        });
                    }else{
                        toastr.warning('No se pudo actualizar el estatus Autorizado, intente de nuevo, si el problema persiste comunicarse con el administrador de la aplicación.');
                    }
                }
            </script>

            @if (session()->has('success'))
                <script>
                    toastr.success("{{ session('success') }}");
                </script>
            @endif

            @if (session()->has('message'))
                <script>
                    toastr.error('Ocurrio un error inesperado.');
                </script>
            @endif
        @endpush
    </div>

</x-app-layout>
