<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Catálogo de proveedores') }}
        </h2>
    </x-slot>

    <div class="panel">
        <div class="panel-body demo-nifty-alert">
            <div class="container-fluid">

                <div class="row mb-2">
                    <div class="col-12 d-flex justify-content-center">
                        <div class="columns-right float-right">
                            <div class="float-left order-2 pr-1">

                                @can('catalogo_de_proveedores_create')
                                <a href="{{ route('catalogo-de-proveedores.create') }}" class="btn btn-primary px-2 py-2 text-white">
                                    <i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Crear proveedor
                                </a>
                                @endcan

                            </div>

                        </div>
                    </div>
                </div>

                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">

                                <div class="row mt-3">
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table id="proveedores-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                                <thead>
                                                <tr>
                                                    <th>Clave</th>
                                                    <th>Acciones</th>
                                                    <th>Razón social</th>
                                                    <th>Nombre comercial</th>
                                                    <th>RFC</th>
                                                    <th>Teléfono</th>
                                                    <th>Correo</th>
                                                    <th>Dirección</th>
                                                    <th>IVA %</th>
                                                    <th>ISR</th>
                                                    <th>Comentarios</th>
                                                    <th>Contactar</th>
                                                </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        @push('scripts')
            <script type="text/javascript">
                var APP_URL = {!! json_encode(url('/')) !!};
                var $catalogo_de_proveedores_edit = @json($catalogo_de_proveedores_edit);
                var $catalogo_de_proveedores_destroy = @json($catalogo_de_proveedores_destroy);

                $(document).ready(function() {
                    var proveedoresDT = new DataTable('#proveedores-datatable', {
                        processing: true,
                        serverSide: true,
                        autoWidth: false,
                        pageLength: 10,
                        responsive: true,
                        scrollX: false,
                        "language": {
                            "url": "../../plugins/DataTables/language.MX.json"
                        },
                        "order": [[ 0, "desc" ]],
                        ajax: {
                            url: '{{ route('catalogo-de-proveedores.get-lista-proveedores') }}',
                            // data: function (d) {
                            //     //console.log('data -> ', d)
                            // }
                        },
                        columns: [
                            {data: 'id', name: 'id'},
                            {
                                data: null,
                                render: function( data, type, full, meta ){
                                    var botones = '';
                                    if ($catalogo_de_proveedores_edit){
                                        botones += '<a href="/catalogo-de-proveedores/' + data["id"] + '/edit/" class="btn btn-primary text-white mb-2 me-1" title="Editar"><i class="fa-sharp fa-solid fa-pen-to-square"></i>&nbsp;Editar</a>';
                                    }
                                    if ($catalogo_de_proveedores_destroy){
                                        botones += '<button id="btn-eliminar-'+ data["id"] +'" data-id="' + data["id"] + '" class="btn_delete_cliente btn btn-danger text-white mb-2 me-1" title="Eliminar"><i class="fa-sharp fa-solid fa-trash-can"></i>&nbsp;Eliminar</button>';
                                    }
                                    return botones;
                                }
                            },
                            {data: 'razon_social', name: 'razon_social'},
                            {data: 'nombre_comercial', name: 'nombre_comercial'},
                            {data: 'rfc', name: 'rfc'},
                            {data: 'telefono', name: 'telefono'},
                            {data: 'email', name: 'email'},
                            {data: 'direccion', name: 'direccion'},
                            {data: 'iva_impuesto.nombre', name: 'iva_impuesto.nombre'},
                            {
                                data: 'aplica_isr', name: 'aplica_isr',
                                render: function( data, type, full, meta ){
                                    return (data == 1) ? 'SI' : 'NO';
                                }
                            },
                            {data: 'comentarios', name: 'comentarios'},
                            {data: 'contacto', name: 'contacto'},
                        ],
                        "columnDefs": [
                            {targets: 7, className: "text-center", width: "90px"},
                            {targets: [-1], className: "text-center", orderable: false, searchable: false},
                        ]
                    });

                    proveedoresDT.on('click', 'button', function (e) {
                        let data = proveedoresDT.row(e.target.closest('tr')).data();
                        var id = $(this).data('id');
                        delete_proveedor(id);
                    });

                    function delete_proveedor(id) {
                        if (id > 0 && id !== null && id !== "") {
                            Swal.fire({
                                title: "¿Está seguro de que desea eliminar el proveedor?",
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Si, eliminar!",
                                cancelButtonText: "No, cancelar!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    var url = APP_URL + '/catalogo-de-proveedores/'+id;
                                    axios.delete(url)
                                        .then(response => {
                                            var resp = response.data;
                                            if(!resp.error){
                                                toastr.success(resp.message);
                                                proveedoresDT.draw(true);
                                            }else{
                                                toastr.warning('No se pudo eliminar el registro');
                                            }
                                        }).catch(e => {
                                        console.log(e);
                                        toastr.error('Ocurrio un error inesperado.');
                                    });
                                }
                            });

                        } else {
                            toastr.warning('Parametro incompleto para eliminar el registro');
                        }
                    }

                });
            </script>

            @if (session()->has('success'))
                <script>
                    toastr.success("{{ session('success') }}");
                </script>
            @endif

            @if (session()->has('message'))
                <script>
                    toastr.error('Ocurrio un error inesperado.');
                </script>
            @endif
        @endpush
    </div>

</x-app-layout>
