<x-app-layout>
    <x-slot name="header">
        <h2 class="">
            {{ __('Editar Proveedor') }}
        </h2>
    </x-slot>

    <div class="bg-white overflow-hidden">

        @php
            $proveedor_id = $proveedor->id;
        @endphp

        {{-- Form --}}
        <div class="mt-4">
            <form id="form_proveedor">
                <div class="shadow">

                    {{-- Datos generales--}}
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="razon_social" class="form-label">Razón social <span class="_required_">*</span></label>
                                <input type="text" class="form-control save-required" name="razon_social" id="razon_social" value="{{ $proveedor->razon_social }}" autocomplete="off" placeholder="Razón social" tabindex="1">
                                <x-jet-input-error for="nombre" />
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="nombre_comercial" class="form-label">Nombre comercial <span class="_required_">*</span></label>
                                <input type="text" class="form-control save-required" name="nombre_comercial" id="nombre_comercial" value="{{ $proveedor->nombre_comercial }}" autocomplete="off" placeholder="Nombre comercial" tabindex="2">
                                <x-jet-input-error for="nombre_comercial" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-sm-4 col-md-4 col-lg-4">
                                <label for="rfc" class="form-label">RFC <span class="_required_">*</span></label>
                                <input type="text" class="form-control save-required" name="rfc" id="rfc" value="{{ $proveedor->rfc }}" autocomplete="off" placeholder="RFC" tabindex="3">
                                <x-jet-input-error for="rfc" />
                            </div>
                            <div class="col-12 col-sm-4 col-md-4 col-lg-4">
                                <label for="telefono" class="form-label">Teléfono</label>
                                <input type="text" class="form-control" name="telefono" id="telefono" value="{{ $proveedor->telefono }}" autocomplete="off" placeholder="Agregar teléfono" tabindex="4">
                                <x-jet-input-error for="telefono" />
                            </div>
                            <div class="col-12 col-sm-4 col-md-4 col-lg-4">
                                <label for="email" class="form-label">Correo</label>
                                <input type="text" class="form-control @error('email') is-invalid @enderror" name="email" id="email" value="{{ $proveedor->email }}" autocomplete="off" placeholder="Agregar correo" tabindex="5">
                                <x-jet-input-error for="email" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="direccion" class="form-label">Dirección</label>
                                <input type="text" class="form-control" name="direccion" id="direccion" value="{{ $proveedor->direccion }}" autocomplete="off" placeholder="Agregar dirección" tabindex="6">
                                <x-jet-input-error for="direccion" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="comentarios" class="form-label">Comentarios</label>
                                <input type="text" class="form-control" name="comentarios" id="comentarios" value="{{ $proveedor->comentarios }}" autocomplete="off" placeholder="Agregar Comentario" tabindex="7">
                                <x-jet-input-error for="comentarios" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-sm-4 col-md-4 col-lg-4">
                                <label for="iva_id" class="form-label">IVA %</label>
                                <select class="form-control save-required" id="iva_id" name="iva_id" style="width: 100%;" tabindex="8">
                                    @if($option_default_iva)
                                        {!! $option_default_iva !!}
                                    @endif
                                </select>
                                <x-jet-input-error for="iva_id" />
                            </div>
                            <div class="col-12 col-sm-8 col-md-4 col-lg-8">
                                <label for="contacto" class="form-label">Contactar a</label>
                                <input type="text" class="form-control" name="contacto" id="contacto" value="{{ $proveedor->contacto }}" autocomplete="off" placeholder="Agregar contactar" tabindex="9">
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-12 col-sm-4 col-md-4 col-lg-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="0" id="check_ISR" @if($proveedor->aplica_isr) checked @endif >
                                    <label class="form-check-label" for="check_ISR">
                                        Aplicar ISR
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- End-Datos generales--}}

                    {{-- Cuentas Bancarias --}}
                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Cuentas Bancarias</b></h5>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-6 col-sm-3 col-md-3 col-lg-2">
                                <p><button type="button" class="btn btn-primary text-white mb-2 me-1" title="Agregar" data-bs-toggle="modal" data-bs-target="#modalNewCB"><i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Agregar</button></p>
                            </div>
                            <div class="col-6 col-sm-3 col-md-3 col-lg-2">
                                <p><button type="button" id="btn-delete-row" class="btn btn-danger text-white mb-2 me-1" title="Eliminar"><i class="fa-sharp fa-solid fa-trash-can"></i>&nbsp;Eliminar</button></p>
                            </div>
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="cuentas-bancarias-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                        <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Clave</th>
                                            <th>Cuenta bancaria</th>
                                            <th>Clabe interbancaria</th>
                                            <th>Banco</th>
                                        </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- End-Cuentas-Bancarias--}}

                    <hr>
                    <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                        <a href="{{ route('catalogo-de-proveedores.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Cancelar</a>
                        <button type="button" id="guardarProveedorForm" class="btn btn-primary text-white" tabindex="10"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar</button>
                    </div>
                </div>
            </form>
        </div>
        {{-- End-Form --}}

    </div>

    <!-- Modal -->
    <div class="modal fade" id="modalNewCB" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Agregar Cuenta Bancaria</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="newFormModal">
                        <div class="px-4 py-1">
                            <div class="row">
                                <div class="col">
                                    <label for="cuenta_bancaria" class="form-label">Cuenta bancaria <span class="_required_">*</span></label>
                                    <input type="text" class="form-control save-required" name="cuenta_bancaria" id="cuenta_bancaria" autocomplete="off" placeholder="Agregar Cuenta bancaria">
                                </div>
                                <div class="col">
                                    <label for="clabe_interbancaria" class="form-label">Clabe interbancaria <span class="_required_">*</span></label>
                                    <input type="text" class="form-control save-required" name="clabe_interbancaria" id="clabe_interbancaria" autocomplete="off" placeholder="Agregar Clabe interbancaria">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="banco" class="form-label">Banco <span class="_required_">*</span></label>
                                    <input type="text" class="form-control save-required" name="banco" id="banco" autocomplete="off" placeholder="Agregar Banco">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i>&nbsp;Cerrar</button>
                    <button type="button" id="addCBNew" class="btn btn-primary text-white"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Agregar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Fin-Modal -->

    @push('scripts')
        <script src="{{ asset('plugins/inputmask/jquery.inputmask.min.js') }}"></script>
        <script src="{{asset('js/admin.js')}}"></script>
        <script type="text/javascript">
            var APP_URL = {!! json_encode(url('/')) !!}

            $(document).ready(function($){
                $('#telefono').inputmask('(999)-9999999');

                $('#iva_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    ajax: {
                        dataType: 'json',
                        url: APP_URL + "/get-lista-iva-select-simple",
                        data: function(params) {
                            return {
                                search: params.term
                            }
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                        }
                    },
                    allowClear: true,
                    cache: false,
                }).on('select2:select', function (e) {
                    var data = e.params.data;
                    $('#iva_id').val(data.id).trigger('change');
                })

                const cuentasBancariasDT = new DataTable('#cuentas-bancarias-datatable', {
                    "dom": '<"top"f><"datatable-scroll"rt><"bottom"ip><"clear">',
                    pageLength: 6,
                    responsive: true,
                    scrollX: false,
                    "language": {
                        "url": APP_URL + "/plugins/DataTables/language.MX.json"
                    },
                    //columnDefs: [{ visible: false, targets: [1,3] }]
                });
                let counter = 1;

                //clear row selected
                cuentasBancariasDT.on('click', 'tbody tr', (e) => {
                    let classList = e.currentTarget.classList;

                    if (classList.contains('selected')) {
                        classList.remove('selected');
                    }
                    else {
                        cuentasBancariasDT.rows('.selected').nodes().each((row) => row.classList.remove('selected'));
                        classList.add('selected');
                    }
                });

                //Modal-Cuenta-Bancaria
                const myModalEl = document.getElementById('modalNewCB')
                myModalEl.addEventListener('hidden.bs.modal', event => {
                    $("#cuenta_bancaria").val("");
                    $("#clabe_interbancaria").val("");
                    $("#banco").val("");
                });

                function addNewRow(data, type = 1) {
                    if (type == 1){
                        cuentasBancariasDT.row
                            .add([
                                counter,
                                '',
                                data.cuenta_bancaria,
                                data.clabe_interbancaria,
                                data.banco
                            ])
                            .draw(false);
                    } else if(type == 2) {
                        cuentasBancariasDT.row
                            .add([
                                counter,
                                data.id,
                                data.cuenta_bancaria,
                                data.clabe_interbancaria,
                                data.banco
                            ])
                            .draw(false);
                    }

                    counter++;
                }

                $('#addCBNew').off('click');
                $('#addCBNew').on('click', function (){
                    var idform = '#newFormModal';
                    if(validateForm(idform)){

                        var data = {
                            cuenta_bancaria: $('#cuenta_bancaria').val(),
                            clabe_interbancaria: $('#clabe_interbancaria').val(),
                            banco: $('#banco').val()
                        };
                        addNewRow(data);
                        $("#modalNewCB").modal('hide');
                    }
                });

                //Get Lista de cuentas bancarias guardados
                let data_proveedor = @json($proveedor);
                if(data_proveedor != null && data_proveedor != ''){
                    let data_proveedor_cuenta_bancaria = data_proveedor.proveedor_cuenta_bancaria;
                    $.each(data_proveedor_cuenta_bancaria, function (index, val){
                        addNewRow(val, 2);
                    });
                }

                $('#btn-delete-row').off('click');
                $('#btn-delete-row').on('click', function (){
                    let selectRow = cuentasBancariasDT.rows('.selected').nodes().length;

                    if (selectRow > 0) {
                        Swal.fire({
                            title: "¿Está seguro que desea eliminar la cuenta bancaria?",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#3085d6",
                            cancelButtonColor: "#d33",
                            confirmButtonText: "Si, eliminar!",
                            cancelButtonText: "No, cancelar!",
                        }).then((result) => {
                            if (result.isConfirmed) {
                                cuentasBancariasDT.row('.selected').remove().draw(false);
                            }
                        });
                    } else {
                        toastr.warning('Debe seleccionar un registro para eliminarlo.');
                    }
                });

                /**
                 * Guardar Proveedor con Cuentas bancarias
                 */
                $('#guardarProveedorForm').off('click');
                $('#guardarProveedorForm').on('click', function (){
                    var id_form_Prov = '#form_proveedor';
                    if(validateForm(id_form_Prov)){

                        var cuentasBancariasRows = cuentasBancariasDT.rows().data().toArray();
                        if(cuentasBancariasRows.length === 0){
                            toastr.warning('Debe agregar almenos una cuenta bancaria.');
                        }else{
                            $('#guardarProveedorForm').attr("disabled", true);
                            let check_ISR = document.getElementById('check_ISR').checked;

                            var data = {
                                razon_social: $('#razon_social').val(),
                                nombre_comercial: $('#nombre_comercial').val(),
                                rfc: $('#rfc').val(),
                                telefono: $('#telefono').val(),
                                email: $('#email').val(),
                                direccion: $('#direccion').val(),
                                comentarios: $('#comentarios').val(),
                                iva_id: $('#iva_id').val(),
                                contacto: $('#contacto').val(),
                                cuentas_bancarias_data: cuentasBancariasRows,
                                aplica_isr: (check_ISR == true) ? 1: 0,
                            };
                            updateCuentasBancarias(data);
                        }
                    }
                });

            }); //End-document-ready

            function updateCuentasBancarias(data){
                if(data !== null && data !== false){
                    var url_save = APP_URL + '/catalogo-de-proveedores/' + {{ $proveedor_id }};
                    axios.put(url_save, data)
                        .then(response =>{
                            var resp = response.data;
                            if(!resp.error){
                                toastr.success(resp.message);
                                setTimeout(function (){
                                    window.location.href = APP_URL + '/catalogo-de-proveedores';
                                }, 1000);
                            }else{
                                toastr.warning(resp.message);
                                $('#guardarProveedorForm').attr("disabled", false);
                            }
                        }).catch(e => {
                        console.log(e);
                        toastr.error('Ocurrió un error inesperado, contacte al administrador de la aplicación.');
                    });
                }else{
                    toastr.warning('No se puede guardar el Proveedor');
                }
            }
        </script>
    @endpush

</x-app-layout>
