<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Catálogo de productos') }}
        </h2>
    </x-slot>

    <div class="panel">
        <div class="panel-body demo-nifty-alert">
            <div class="container-fluid">

                <div class="row mb-2">
                    <div class="col-12 d-flex justify-content-center">
                        <div class="columns-right float-right">
                            <div class="float-left order-2 pr-1">

                                @can('catalogo_de_productos_create')
                                <a href="{{ route('catalogo-de-productos.create') }}" class="btn btn-primary px-2 py-2 text-white">
                                    <i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Crear producto
                                </a>
                                @endcan

                            </div>

                        </div>
                    </div>
                </div>

                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">

                                <div class="row mt-3">
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table id="productos-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                                <thead>
                                                <tr>
                                                    <th>Clave</th>
                                                    <th>Acciones</th>
                                                    <th>Nombre</th>
                                                    <th>Código</th>
                                                    <th>Decripción</th>
                                                </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        @push('scripts')
            <script type="text/javascript">
                var APP_URL = {!! json_encode(url('/')) !!};
                var $catalogo_de_productos_edit = @json($catalogo_de_productos_edit);
                var $catalogo_de_productos_destroy = @json($catalogo_de_productos_destroy);

                $(document).ready(function() {
                    var productosDT = new DataTable('#productos-datatable', {
                        processing: true,
                        serverSide: true,
                        autoWidth: false,
                        pageLength: 10,
                        responsive: true,
                        scrollX: false,
                        "language": {
                            "url": "../../plugins/DataTables/language.MX.json"
                        },
                        "order": [[ 0, "desc" ]],
                        ajax: {
                            url: '{{ route('catalogo-de-productos.get-lista-productos') }}',
                        },
                        columns: [
                            {data: 'id', name: 'id'},
                            {
                                data: null,
                                render: function( data, type, full, meta ){
                                    var botones = '';
                                    if ($catalogo_de_productos_edit){
                                        botones += '<a href="/catalogo-de-productos/' + data["id"] + '/edit/" class="btn btn-primary text-white mb-2 me-1" title="Editar"><i class="fa-sharp fa-solid fa-pen-to-square"></i>&nbsp;Editar</a>';
                                    }
                                    if ($catalogo_de_productos_destroy){
                                        botones += '<button id="btn-eliminar-'+ data["id"] +'" data-id="' + data["id"] + '" class="btn btn-danger text-white mb-2 me-1" title="Eliminar"><i class="fa-sharp fa-solid fa-trash-can"></i>&nbsp;Eliminar</button>';
                                    }
                                    return botones;
                                }
                            },
                            {data: 'nombre', name: 'nombre'},
                            {data: 'codigo', name: 'codigo'},
                            {data: 'descripcion', name: 'descripcion'},
                        ],
                    });

                    productosDT.on('click', 'button', function (e) {
                        let data = productosDT.row(e.target.closest('tr')).data();
                        console.log('data -> ', data);
                        var id = $(this).data('id');
                        console.log('id -> ', id);
                        delete_producto(id);
                    });

                    function delete_producto(id) {
                        console.log('-> delete_producto <-');
                        if (id > 0 && id !== null && id !== "") {
                            Swal.fire({
                                title: "¿Está seguro de que desea eliminar el producto?",
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Si, eliminar!",
                                cancelButtonText: "No, cancelar!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    var url = APP_URL + '/catalogo-de-productos/'+id;
                                    console.log('url -> ', url);
                                    axios.delete(url)
                                        .then(response => {
                                            console.log('response ->', response);
                                            var resp = response.data;
                                            if(!resp.error){
                                                toastr.success(resp.message);
                                                productosDT.draw(true);
                                            }else{
                                                toastr.warning('No se pudo eliminar el registro');
                                            }
                                        }).catch(e => {
                                        console.log(e);
                                        toastr.error('Ocurrio un error inesperado.');
                                    });
                                }
                            });

                        } else {
                            toastr.warning('Parametro incompleto para eliminar el registro');
                        }
                    }

                });
            </script>

            @if (session()->has('success'))
                <script>
                    toastr.success("{{ session('success') }}");
                </script>
            @endif

            @if (session()->has('message'))
                <script>
                    toastr.error('Ocurrio un error inesperado.');
                </script>
            @endif
        @endpush
    </div>

</x-app-layout>
