<x-app-layout>
    <x-slot name="header">
        <h2 class="">
            {{ __('Editar Producto') }}
        </h2>
    </x-slot>

    <div class="bg-white overflow-hidden">

        {{-- Form --}}
        <div class="mt-4">
            <form method="POST" action="{{ route('catalogo-de-productos.update', $producto->id) }}">
                @method('PUT')
                @csrf
                <div class="shadow">

                    {{-- Datos generales--}}
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <label for="nombre" class="form-label">Nombre <span class="_required_">*</span></label>
{{--                                <input type="text" class="form-control @error('nombre') is-invalid @enderror" name="nombre" id="nombre" value="{{ $producto->nombre }}" autocomplete="off" placeholder="Nombre" tabindex="1">--}}
                                <textarea class="form-control @error('nombre') is-invalid @enderror" name="nombre" id="nombre" placeholder="Agregar nombre" rows="3" tabindex="1">{{ $producto->nombre }}</textarea>
                                <x-jet-input-error for="nombre" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="descripcion" class="form-label">Descripción</label>
{{--                                <input type="text" class="form-control @error('descripcion') is-invalid @enderror" name="descripcion" id="descripcion" value="{{ $producto->descripcion }}" autocomplete="off" placeholder="Agregar descripción" tabindex="2">--}}
                                <textarea class="form-control @error('descripcion') is-invalid @enderror" name="descripcion" id="descripcion" placeholder="Agregar descripción" rows="3" tabindex="2">{{ $producto->descripcion }}</textarea>
                                <x-jet-input-error for="descripcion" />
                            </div>
                        </div>
                    </div>
                    {{-- End-Datos generales--}}

                    <hr>

                    <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                        <a href="{{ route('catalogo-de-productos.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Cancelar</a>
                        <button type="submit" class="btn btn-primary text-white" tabindex="5">
                            <i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar
                        </button>
                    </div>
                </div>
            </form>
        </div>
        {{-- End-Form --}}

    </div>

</x-app-layout>
