<x-app-layout>
    <x-slot name="header">
        <h2 class="">
            {{ __('Editar Ingeniero') }}
        </h2>
    </x-slot>

    <div class="bg-white overflow-hidden">

        {{-- Form --}}
        <div class="mt-4">
            <form method="POST" action="{{ route('catalogo-de-ingenieros.update', $ingeniero->id) }}">
                @method('PUT')
                @csrf
                <div class="shadow">

                    {{-- Datos generales--}}
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <label for="nombre" class="form-label">Nombre <span class="_required_">*</span></label>
                                <input type="text" class="form-control @error('nombre') is-invalid @enderror" name="nombre" id="nombre" value="{{ $ingeniero->nombre }}" autocomplete="off" placeholder="Nombre" tabindex="1">
                                <x-jet-input-error for="nombre" />
                            </div>
                            <div class="col">
                                <label for="rfc" class="form-label">RFC</label>
                                <input type="text" class="form-control @error('rfc') is-invalid @enderror" name="rfc" id="rfc" value="{{ $ingeniero->rfc }}" autocomplete="off" placeholder="Agregar RFC" tabindex="2">
                                <x-jet-input-error for="rfc" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="curp" class="form-label">CURP</label>
                                <input type="text" class="form-control @error('curp') is-invalid @enderror" name="curp" id="curp" value="{{ $ingeniero->curp }}" autocomplete="off" placeholder="Agregar CURP" tabindex="4">
                                <x-jet-input-error for="curp" />
                            </div>
                            <div class="col">
                                <label for="telefono" class="form-label">Teléfono</label>
                                <input type="text" class="form-control @error('telefono') is-invalid @enderror" name="telefono" id="telefono" value="{{ $ingeniero->telefono }}" autocomplete="off" placeholder="Agregar teléfono" tabindex="3">
                                <x-jet-input-error for="telefono" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="correo" class="form-label">Correo</label>
                                <input type="text" class="form-control @error('correo') is-invalid @enderror" name="correo" id="correo" value="{{ $ingeniero->correo }}" autocomplete="off" placeholder="Agregar correo" tabindex="4">
                                <x-jet-input-error for="correo" />
                            </div>
                        </div>
                    </div>
                    {{-- End-Datos generales--}}

                    <hr>

                    <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                        <a href="{{ route('catalogo-de-ingenieros.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Cancelar</a>
                        <button type="submit" class="btn btn-primary text-white" tabindex="5">
                            <i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar
                        </button>
                    </div>
                </div>
            </form>
        </div>
        {{-- End-Form --}}

    </div>

    @push('scripts')
        <script src="{{ asset('plugins/inputmask/jquery.inputmask.min.js') }}"></script>
        <script src="{{asset('js/admin.js')}}"></script>
        <script type="text/javascript">
            $(document).ready(function($){
                $('#telefono').inputmask('(999)-9999999');
            });
        </script>
    @endpush

</x-app-layout>
