$(document).ready(function ($) {
    let counterS = 1;
    console.log('obras load');
    $('#obra_id').select2({
        width: '100%',
        theme: "bootstrap",
        placeholder: 'Selecciona una opción',
        ajax: {
            dataType: 'json',
            url: "/get-lista-obras-select",
            delay: 250,
            data: function (params) {
                console.log('params', params);
                return {
                    search: params.term
                }
            },
            processResults: function (data, page) {
                console.log('data', data);
                return {
                    results: data
                };
            }
        },
        cache: true
    });

    console.log('ingeniero_id load');
    $('#ingeniero_id').select2({
        width: '100%',
        theme: "bootstrap",
        placeholder: 'Selecciona una opción',
        ajax: {
            dataType: 'json',
            url: "/get-lista-ingenieros-select",
            delay: 250,
            data: function (params) {
                return {
                    search: params.term
                }
            },
            processResults: function (data, page) {
                return {
                    results: data
                };
            }
        },
        cache: true
    });

    $('#cantidad').inputmask({
        alias: 'numeric',
        allowMinus: false,
        digits: 0,
    });

    /**
     * Guardar Solicitud de compras
     */
    $('#guardarSolicitudForm').off('click');
    $('#guardarSolicitudForm').on('click', function () {
        var id_form_sol = '#form_solicitud_compra';
        if (validateForm(id_form_sol)) {

            var materialesRows = productosDT.rows().data().toArray();
            if (materialesRows.length === 0) {
                toastr.warning('Debe agregar almenos un material.');
            } else {
                $('#guardarSolicitudForm').attr("disabled", true);
                var data = {
                    obra_id: $('#obra_id').val(),
                    ingeniero_id: $('#ingeniero_id').val(),
                    fecha_entrega: $('#fecha_entrega').val(),
                    observaciones: $('#observaciones').val(),
                    productos_data: materialesRows
                };
                createSolicitudCompra(data);
            }
        }
    });

    $('#modalNewProducto').on('hidden.bs.modal', function () {
        document.activeElement.blur(); // Quita el foco del elemento activo
        $('#producto_id').val(null).change();
        $('#unidad_id').val(null).change();
        $("#cantidad").val("");
        $("#area_de_uso").val("");
        $("#marca").val("");
        $("#modelo").val("");
        $("#observaciones_prod").val("");
        $(':focus').blur(); // Limpia el foco activo
    });
});

function createSolicitudCompra(data) {
    if (data !== null && data !== false) {
        data.sinsolicitud = true;
        var url_save = window.APP_URL + '/solicitud-de-compras';
        console.log('guardando.solicitud');
        axios.post(url_save, data)
            .then(response => {
                var resp = response.data;
                console.log('resp:', resp);
                console.log('resp.status:', resp.status);
                if (!resp.error) {
                    toastr.success(resp.message);
                    console.log('guarando orden..');
                    data.solicitud_compra_id = resp.data.id; // para guardar la orden
                    createOrdenCompraServer(data);
                } else {
                    toastr.warning(resp.message);
                    $('#guardarSolicitudForm').attr("disabled", false);
                    return false;
                }
            }).catch(e => {
                console.log(e);
                toastr.error('Ocurrió un error inesperado, contacte al administrador de la aplicación.');
                return false;
            });
    } else {
        toastr.warning('No se puede guardar la solicitud de compra');
    }
}