<?php

namespace App\Models\solicitud_material;

use App\Models\OrdenCompra;
use App\Models\SolicitudCompraProducto;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RelSolicitudCompraProductoPrecio extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'rel_solicitud_compras_productos_precios';

    protected $fillable = [
        'solicitud_compra_producto_id',
        'orden_compra_id',
        'precio_lista',
        'precio_unitario',
        'importe',
        'descuento',
        'subtotal',
        'created_by',
        'updated_by',
    ];

    public function solicitud_compra_producto(){
        return $this->belongsTo(SolicitudCompraProducto::class, 'solicitud_compra_producto_id');
    }

    public function orden_compra(){
        return $this->belongsTo(OrdenCompra::class, 'orden_compra_id');
    }

}
