<?php

namespace App\Models\solicitud_clon;

use App\Models\Producto;
use App\Models\Unidad;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SolicitudCompraProductoClon extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'solicitud_compras_productos_clon';

    protected $fillable = [
        'solicitud_compra_clon_id',
        'solicitud_compra_producto_id_origen',
        'producto_id',
        'unidad_id',
        'num_duplicado_order',
        'cantidad',
        'area_de_uso',
        'marca',
        'modelo',
        'precio_lista',
        'precio_unitario',
        'importe',
        'descuento',
        'subtotal',
        'observaciones',
    ];

    public function SolicitudCompraClon()
    {
        return $this->belongsTo(SolicitudCompraClon::class);
    }

    public function producto(){
        return $this->belongsTo(Producto::class);
    }

    public function unidad(){
        return $this->belongsTo(Unidad::class);
    }

    public function RelSolicitudProductoComentarioMaterialClon()
    {
        return $this->hasOne(RelSolicitudProductoComentarioMaterialClon::class, 'solicitud_compras_productos_clon_id', 'id');
    }

}
