<?php

namespace App\Models\solicitud_clon;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RelSolicitudProductoComentarioMaterialClon extends Model
{
    use HasFactory;

    protected $table = 'rel_solicitud_productos_comentarios_materiales_clon';

    protected $fillable = [
        'solicitud_compra_producto_id_origen',
        'solicitud_compra_id',
        'solicitud_compras_productos_clon_id',
        'comentarios_materiales_clon_id',
        'users_id',
        'solicitud_compra_clon_id'
    ];

    public function SolicitudCompraProductoClon() {
        return $this->belongsTo(SolicitudCompraProductoClon::class, 'solicitud_compras_productos_clon_id', 'id');
    }

    public function ComentarioMaterialClon() {
        return $this->belongsTo(ComentarioMaterialClon::class, 'comentarios_materiales_clon_id', 'id');
    }

    public function user() {
        return $this->belongsTo(User::class, 'users_id');
    }

}
