<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SolicitudCompra extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'solicitud_compras';

    protected $fillable = [
        'obra_id',
        'ingeniero_id',
        'codigo',
        'codigo_nombre',
        'observaciones',
        'fecha_solicitud',
        'fecha_entrega',
        'estatus_id',
        'emails',
        'email_asunto',
        'email_contenido',
        'clave_version'
    ];

    public function obra(){
        return $this->belongsTo(Obra::class);
    }

    public function ingeniero(){
        return $this->belongsTo(Ingeniero::class);
    }

    public function solicitudCompraProducto(){
        return $this->hasMany(SolicitudCompraProducto::class, 'solicitud_compra_id', 'id');
    }

    public function estatus()
    {
        return $this->belongsTo(Estatus::class);
    }

}
