<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProveedorCuentaBancaria extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'proveedores_cuentas_bancarias';

    protected $fillable = [
        'proveedor_id',
        'cuenta_bancaria',
        'clabe_interbancaria',
        'banco'
    ];

    public function proveedor(){
        return $this->belongsTo(Proveedor::class);
    }
}
