<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Proveedor extends Model
{
    use HasFactory;
    //use SoftDeletes;

    protected $table = 'proveedores';

    protected $fillable = [
        'razon_social',
        'nombre_comercial',
        'rfc',
        'direccion',
        'logo',
        'telefono',
        'email',
        'comentarios',
        'iva_impuestos_id',
        'aplica_isr',
        'aplica_monto_isr',
    ];

    public function ProveedorCuentaBancaria(){
        return $this->hasMany(ProveedorCuentaBancaria::class, 'proveedor_id', 'id');
    }

    public function ivaImpuesto(){
        return $this->belongsTo(IvaImpuesto::class, 'iva_impuestos_id');
    }

}
