<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PagoProveedor extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'pagos_proveedores';

    protected $fillable = [
        'orden_compra_id',
        'proveedor_id',
        'obra_id',
        'codigo',
        'fecha_pago',
        'conceptos_materiales',
        'importe',
        'importe_letras',
        'comentarios',
        'moneda',
        'estatus_id',
        'emails',
        'email_asunto',
        'email_contenido',
        'url_factura_pdf',
        'url_proveedor_pdf',
        'url_resumen_pdf',
    ];

    public function ordenCompra()
    {
        return $this->belongsTo(OrdenCompra::class);
    }

    public function proveedor(){
        return $this->belongsTo(Proveedor::class);
    }

    public function obra(){
        return $this->belongsTo(Obra::class);
    }

    public function estatus()
    {
        return $this->belongsTo(Estatus::class);
    }

}
