<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class MessageReceived extends Mailable
{
    use Queueable, SerializesModels;

    public $subject = 'Envio de PDF';
    public $data;
    public $url_pdf;
    public $msg;
    public $url_view = 'emails.message-received';
    public $nombre_pdf;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data, $url_pdf, $msg, $url_view, $nombre_pdf)
    {
        $this->subject = $msg['subject'];
        $this->data = $data;
        $this->url_pdf = $url_pdf;
        $this->msg = $msg;
        $this->url_view = $url_view;
        $this->nombre_pdf = $nombre_pdf;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view($this->url_view)
            ->attach($this->url_pdf, [
                'as' => $this->nombre_pdf,
                'mime' => 'application/pdf'
            ]);
    }
}
