<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Ingeniero;
use Illuminate\Http\Request;
use DataTables;
use Illuminate\Support\Facades\Auth;

class IngenierosController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();

        $catalogo_de_ingenieros_edit = $user->can('catalogo_de_ingenieros_edit');
        $catalogo_de_ingenieros_destroy = $user->can('catalogo_de_ingenieros_destroy');

        return view('admin.catalogos.ingenieros.lista', compact('catalogo_de_ingenieros_edit', 'catalogo_de_ingenieros_destroy'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.catalogos.ingenieros.nuevo');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'nombre' => 'required|min:3',
        ]);

        $ingeniero = new Ingeniero();
        $ingeniero->nombre = $request->input('nombre');
        $ingeniero->rfc = $request->input('rfc');
        $ingeniero->curp = $request->input('curp');
        $ingeniero->telefono = $request->input('telefono');
        $ingeniero->correo = $request->input('correo');
        $ingeniero->save();

        return redirect()->route('catalogo-de-ingenieros.index')->withSuccess('Ingeniero guardado con éxito.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $ingeniero = Ingeniero::findOrFail($id);
        return view('admin.catalogos.ingenieros.editar', compact("ingeniero"));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'nombre' => 'required|min:3',
        ]);

        $ingeniero = Ingeniero::findOrFail($id);
        $ingeniero->nombre = $request->input('nombre');
        $ingeniero->rfc = $request->input('rfc');
        $ingeniero->curp = $request->input('curp');
        $ingeniero->telefono = $request->input('telefono');
        $ingeniero->correo = $request->input('correo');
        $ingeniero->update();

        return redirect()->route('catalogo-de-ingenieros.index')->withSuccess('Ingeniero actualizado con éxito.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $ingeniero = Ingeniero::findOrFail($id);
            $ingeniero->delete();

            return response()->json(['error' => false, 'message' => 'Registro eliminado.']);
        } catch (\Exception $ex) {
            return response()->json([
                'error' => true,
                'message' => $ex->getMessage(),
            ]);
        }
    }

    public function get_Lista_Ingenieros(Request $request)
    {
        if ($request->ajax()) {
            $ingenieros = Ingeniero::whereNull('deleted_at')
                ->orderBy('id', 'desc')->get();

            return DataTables::of($ingenieros)->make(true);
        }
    }

    public function get_Lista_Ingenieros_Select(Request $request)
    {
        $ingenieros = [];
        if($request->has('search')){
            $search = $request->search;

            $ingenieros = Ingeniero::select('id', 'nombre')
                ->whereNull('deleted_at')
                ->where('nombre', 'LIKE', '%'.$search.'%')
                ->orderBy('nombre', 'asc')
                ->get();
        }else{
            $ingenieros = Ingeniero::select('id', 'nombre')
                ->whereNull('deleted_at')
                ->orderBy('nombre', 'asc')
                ->get();
        }

        if(!$ingenieros->isEmpty()){
            $valid_tags = [];
            foreach ($ingenieros as $item) {
                $valid_tags[] = ['id' => $item->id, 'text' => $item->nombre];
            }
            return response()->json($valid_tags);
        }else{
            return response()->json([
                'status' => "ERROR",
                'error' => true,
                'message' => 'No se encontraron resultados'
            ]);
        }
    }
}
