<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Estatus;
use Illuminate\Http\Request;

class EstatusController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function get_Lista_Estatus_Select(Request $request)
    {
        $estatus = [];
        $filtrar = [];

        $estatus_por_autorizar = Estatus::where('clave', 'por_autorizar')->whereNull('deleted_at')->first();
        $estatus_autorizado = Estatus::where('clave', 'autorizado')->whereNull('deleted_at')->first();
        $estatus_finalizado = Estatus::where('clave', 'finalizado')->whereNull('deleted_at')->first();
        $estatus_rechazado = Estatus::where('clave', 'rechazado')->whereNull('deleted_at')->first();
        $estatus_cancelado = Estatus::where('clave', 'cancelado')->whereNull('deleted_at')->first();


        if ($request->has('type')) {
            $type = $request->type;
            switch ($type) {
                case 'solicitud_compras':
                    $filtrar = [$estatus_por_autorizar->id, $estatus_autorizado->id, $estatus_finalizado->id];
                    break;
                case 'orden_compras':
                    $filtrar = [$estatus_por_autorizar->id, $estatus_autorizado->id];
                    break;
                case 'pago_proveedores':
                    $filtrar = [$estatus_por_autorizar->id, $estatus_autorizado->id, $estatus_cancelado->id];
                    break;
            }
        }

        if($request->has('search')) {
            $search = $request->search;

            $estatus = Estatus::select('id', 'estatus', 'tittle')
                ->where('estatus', 'like', '%' . $search . '%')
                ->when(!empty($filtrar), function ($query) use ($filtrar) {
                    $query->whereIn('id', $filtrar);
                })
                ->whereNull('deleted_at')
                ->orderBy('id', 'asc')
                ->get();
        } else {
            $estatus = Estatus::select('id', 'estatus', 'tittle')
                ->when(!empty($filtrar), function ($query) use ($filtrar) {
                    $query->whereIn('id', $filtrar);
                })
                ->whereNull('deleted_at')
                ->orderBy('id', 'asc')
                ->get();
        }

        if(!$estatus->isEmpty()){
            $valid_tags = [];
            foreach ($estatus as $item) {
                $valid_tags[] = ['id' => $item->id, 'text' => $item->estatus];
            }
            return response()->json($valid_tags);
        }else{
            return response()->json([
                'status' => "ERROR",
                'error' => true,
                'message' => 'No se encontraron resultados'
            ]);
        }
    }
}
