<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Catálogo de IVA')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="panel">
        <div class="panel-body demo-nifty-alert">
            <div class="container-fluid">

                <div class="row mb-2">
                    <div class="col-12 d-flex justify-content-center">
                        <div class="columns-right float-right">
                            <div class="float-left order-2 pr-1">

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('catalogo_de_iva_impuesto_create')): ?>
                                <a href="<?php echo e(route('catalogo-de-iva-impuesto.create')); ?>" class="btn btn-primary px-2 py-2 text-white">
                                    <i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Crear IVA
                                </a>
                                <?php endif; ?>

                            </div>

                        </div>
                    </div>
                </div>

                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">

                                <div class="row mt-3">
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table id="iva-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                                <thead>
                                                <tr>
                                                    <th>Clave</th>
                                                    <th>Acciones</th>
                                                    <th>IVA</th>
                                                    <th>Nombre</th>
                                                    <th>Descripción</th>
                                                </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <?php $__env->startPush('scripts'); ?>
            <script type="text/javascript">
                var APP_URL = <?php echo json_encode(url('/')); ?>;
                var $catalogo_de_iva_impuesto_edit = <?php echo json_encode($catalogo_de_iva_impuesto_edit, 15, 512) ?>;
                var $catalogo_de_iva_impuesto_destroy = <?php echo json_encode($catalogo_de_iva_impuesto_destroy, 15, 512) ?>;

                $(document).ready(function() {
                    var ivaDT = new DataTable('#iva-datatable', {
                        processing: true,
                        serverSide: true,
                        autoWidth: false,
                        pageLength: 10,
                        responsive: true,
                        scrollX: false,
                        "language": {
                            "url": "../../plugins/DataTables/language.MX.json"
                        },
                        "order": [[ 0, "desc" ]],
                        ajax: {
                            url: '<?php echo e(route('catalogo-de-iva-impuesto.get-lista-iva-impuesto')); ?>',
                        },
                        columns: [
                            {data: 'id', name: 'id'},
                            {
                                data: null,
                                render: function( data, type, full, meta ){
                                    var botones = '';
                                    if ($catalogo_de_iva_impuesto_edit){
                                        botones += '<a href="/catalogo-de-iva-impuesto/' + data["id"] + '/edit/" class="btn btn-primary text-white mb-2 me-1" title="Editar"><i class="fa-sharp fa-solid fa-pen-to-square"></i>&nbsp;Editar</a>';
                                    }
                                    if ($catalogo_de_iva_impuesto_destroy){
                                        botones += '<button id="btn-eliminar-'+ data["id"] +'" data-id="' + data["id"] + '" class="btn_delete_cliente btn btn-danger text-white mb-2 me-1" title="Eliminar"><i class="fa-sharp fa-solid fa-trash-can"></i>&nbsp;Eliminar</button>';
                                    }
                                    return botones;
                                }
                            },
                            {data: 'iva', name: 'iva'},
                            {data: 'nombre', name: 'nombre'},
                            {data: 'descripcion', name: 'descripcion'},
                        ],
                        // "columnDefs": [
                        //     {targets: [1], className: "text-center", orderable: false},
                        // ]
                    });

                    ivaDT.on('click', 'button', function (e) {
                        let data = ivaDT.row(e.target.closest('tr')).data();
                        var id = $(this).data('id');
                        delete_iva(id);
                    });

                    function delete_iva(id) {
                        if (id > 0 && id !== null && id !== "") {
                            Swal.fire({
                                title: "¿Está seguro que desea eliminar el registro?",
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Si, eliminar!",
                                cancelButtonText: "No, cancelar!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    var url = APP_URL + '/catalogo-de-iva-impuesto/'+id;
                                    axios.delete(url)
                                        .then(response => {
                                            var resp = response.data;
                                            if(!resp.error){
                                                toastr.success(resp.message);
                                                ivaDT.draw(true);
                                            }else{
                                                toastr.warning('No se pudo eliminar el registro');
                                            }
                                        }).catch(e => {
                                        console.log(e);
                                        toastr.error('Ocurrio un error inesperado.');
                                    });
                                }
                            });

                        } else {
                            toastr.warning('Parametro incompleto para eliminar el registro');
                        }
                    }

                });
            </script>

            <?php if(session()->has('success')): ?>
                <script>
                    toastr.success("<?php echo e(session('success')); ?>");
                </script>
            <?php endif; ?>

            <?php if(session()->has('message')): ?>
                <script>
                    toastr.error('Ocurrio un error inesperado.');
                </script>
            <?php endif; ?>
        <?php $__env->stopPush(); ?>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH /var/www/html/arista_app/resources/views/admin/catalogos/iva/lista.blade.php ENDPATH**/ ?>