<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h3 class="text-center">
            <?php echo e(__('Pagos a proveedores')); ?>

        </h3>
     <?php $__env->endSlot(); ?>

    <?php $__env->startPush('styles'); ?>
        <link rel="stylesheet" href="<?php echo e(asset('plugins2/bootstrap-datepicker/css/bootstrap-datepicker.min.css')); ?>">
    <?php $__env->stopPush(); ?>

    <?php
        $estatus_por_autorizar = $estatus_por_autorizar->clave;
        $estatus_autorizado = $estatus_autorizado->clave;
        $estatus_cancelado = $estatus_cancelado->clave;
    ?>

    <div class="panel">
        <div class="panel-body demo-nifty-alert">
            <div class="container-fluid">

                <div class="row mb-2">
                    <div class="col-12 d-flex justify-content-center">
                        <div class="float-left order-2 pr-1">

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pagos_a_proveedores_create')): ?>
                            <a href="<?php echo e(route('pagos-a-proveedores.create')); ?>" class="btn btn-primary px-2 py-2 text-white mx-2">
                                <i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Crear pago a proveedor
                            </a>
                            <?php endif; ?>



                        </div>
                    </div>
                </div>

                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="fecha_pago" class="form-label">Fecha de pago</label>
                                        <div class="input-group date">
                                            <input type="text" class="form-control" name="fecha_pago" id="fecha_pago" autocomplete="off" placeholder="yyyy-mm-dd" readonly>
                                            <div class="input-group-addon">
                                                <i class="fa-regular fa-calendar-days"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="orden_compra_id_select" class="form-label">Código de O.C.</label>
                                        <select class="form-control" id="orden_compra_id_select" name="orden_compra_id_select"></select>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="proveedor_id" class="form-label">Proveedor</label>
                                        <select class="form-control" id="proveedor_id" name="proveedor_id"></select>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="obra_id" class="form-label">Obra</label>
                                        <select class="form-control" id="obra_id" name="obra_id"></select>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="estatus_id" class="form-label">Estatus</label>
                                        <select class="form-control" id="estatus_id" name="estatus_id"></select>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <button type="button" class="js-programmatic-multi-clear btn btn-primary mb-3 text-white mt-4" aria-label="Limpiar todo">Limpiar</button>
                                    </div>
                                </div>









                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pagos_a_proveedores_export')): ?>
                                <div class="row">
                                    <div class="col-12 d-flex justify-content-start">
                                        <button type="button" id="pdf_imprimir_seleccionados" class="btn btn-success text-white mt-2 mb-2" aria-label="Limpiar todo"><i class="fa-solid fa-print"></i>&nbsp;PDF Imprimir seleccionados</button>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="row mt-3">
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table id="pagos-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                                <thead>
                                                <tr>
                                                    <th>Clave</th>
                                                    <th>Acciones</th>
                                                    <th>Código</th>
                                                    <th>Fecha pago</th>
                                                    <th>Clave de O.C.</th>
                                                    <th>Código de O.C.</th>
                                                    <th>Clave de Proveedor</th>
                                                    <th>Proveedor</th>
                                                    <th>Obra</th>
                                                    <th>Concepto</th>
                                                    <th>Importe</th>
                                                    <th>Importe letras</th>
                                                    <th>Lista de Pagos/Anticipos $</th>
                                                    <th>Anticipo a pagar $</th>
                                                    <th>Comentarios</th>
                                                    <th>Estatus</th>
                                                    <th>Estatus</th>
                                                </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <?php $__env->startPush('scripts'); ?>
            <script src="<?php echo e(asset('plugins2/bootstrap-datepicker/js/bootstrap-datepicker.min.js')); ?>"></script>
            <script src="<?php echo e(asset('plugins2/bootstrap-datepicker/locales/bootstrap-datepicker.es.min.js')); ?>"></script>
            <script type="text/javascript">
                var APP_URL = <?php echo json_encode(url('/')); ?>;
                var pagos_datatableDT = null;
                var $pagos_a_proveedores_show = <?php echo json_encode($pagos_a_proveedores_show, 15, 512) ?>;
                var $pagos_a_proveedores_edit = <?php echo json_encode($pagos_a_proveedores_edit, 15, 512) ?>;
                var $pagos_a_proveedores_destroy = <?php echo json_encode($pagos_a_proveedores_destroy, 15, 512) ?>;
                var $pagos_a_proveedores_export = <?php echo json_encode($pagos_a_proveedores_export, 15, 512) ?>;
                var $pagos_a_proveedores_send_email = <?php echo json_encode($pagos_a_proveedores_send_email, 15, 512) ?>;
                var $pagos_a_proveedores_authorized = <?php echo json_encode($pagos_a_proveedores_authorized, 15, 512) ?>;
                var $pagos_a_proveedores_canceled = <?php echo json_encode($pagos_a_proveedores_canceled, 15, 512) ?>;
                //Estatus
                var estatus_por_autorizar = <?php echo json_encode($estatus_por_autorizar, 15, 512) ?>;
                var estatus_autorizado = <?php echo json_encode($estatus_autorizado, 15, 512) ?>;
                var $estatus_cancelado = <?php echo json_encode($estatus_cancelado, 15, 512) ?>;

                $(document).ready(function() {

                    $('#fecha_pago').datepicker({
                        language: 'es',
                        autoclose: true,
                        format: "yyyy-mm-dd",
                        todayHighlight: true
                    });

                    //Buscar por orden compra
                    $('#orden_compra_id_select').select2({
                        width: '100%',
                        theme: "bootstrap",
                        placeholder: 'Selecciona una opción',
                        ajax: {
                            dataType: 'json',
                            url: APP_URL + "/get-lista-ordenes-de-compras-select",
                            delay: 250,
                            data: function(params) {
                                return {
                                    search: params.term,
                                    type: 'filtro_oc_enviado_a_pago'
                                }
                            },
                            processResults: function (data, page) {
                                return {
                                    results: data
                                };
                            }
                        },
                        cache: true
                    });

                    $('#proveedor_id').select2({
                        width: '100%',
                        theme: "bootstrap",
                        placeholder: 'Selecciona una opción',
                        ajax: {
                            dataType: 'json',
                            url: "/get-lista-proveedores-select",
                            delay: 250,
                            data: function(params) {
                                return {
                                    search: params.term
                                }
                            },
                            processResults: function (data, page) {
                                return {
                                    results: data
                                };
                            }
                        },
                        cache: true
                    });

                    $('#obra_id').select2({
                        width: '100%',
                        theme: "bootstrap",
                        placeholder: 'Selecciona una opción',
                        ajax: {
                            dataType: 'json',
                            url: "/get-lista-obras-select",
                            delay: 250,
                            data: function(params) {
                                return {
                                    search: params.term
                                }
                            },
                            processResults: function (data, page) {
                                return {
                                    results: data
                                };
                            }
                        },
                        cache: true,
                        //allowClear: true
                    });

                    $('#estatus_id').select2({
                        width: '100%',
                        theme: "bootstrap",
                        placeholder: 'Selecciona una opción',
                        cache: true,
                        ajax: {
                            dataType: 'json',
                            url: APP_URL + "/get-lista-estatus-select",
                            delay: 250,
                            data: function(params) {
                                return {
                                    search: params.term,
                                    type: 'pago_proveedores'
                                }
                            },
                            processResults: function (data, page) {
                                return {
                                    results: data
                                };
                            }
                        },
                    });

                     pagos_datatableDT = new DataTable('#pagos-datatable', {
                         lengthMenu: [[1,2,3,4,5,6,7,8,9,10,15,20,25,50,100,-1], [1,2,3,4,5,6,7,8,9,10,15,20,25,50,100, 'Todos']],
                         processing: true,
                         serverSide: true,
                         autoWidth: false,
                         pageLength: 10,
                         responsive: true,
                         scrollX: false,
                         fixedColumns: true,
                         fixedHeader: false,
                         select: {style:'multi'},
                        "language": {
                            "url": "../../plugins/DataTables/language.MX.json"
                        },
                        "order": [[ 0, "desc" ]],
                        ajax: {
                            url: '<?php echo e(route('pagos-a-proveedores.get-lista-pagos-proveedores')); ?>',
                            method: 'get',
                        },
                        columns: [
                            {data: 'id', name: 'id'},
                            {
                                data: null,
                                render: function( data, type, full, meta ){
                                    var botones = '';
                                    if ($pagos_a_proveedores_export){
                                        botones += '<a href="/pagos-a-proveedores-print-pdf/'+ data["id"] +'" class="btn btn-primary text-white mb-2 me-1" title="Imprimir" target="_blank">' +
                                            '<i class="fa-solid fa-print"></i>&nbsp;Imprimir' +
                                            '</a>';
                                    }
                                    if ($pagos_a_proveedores_show){
                                        botones += '<a href="/pagos-a-proveedores/'+ data["id"] +'" class="btn btn-success text-white mb-2 me-1" title="Ver información"><i class="fa-regular fa-eye"></i>&nbsp;Información</a>';
                                    }
                                    if ($pagos_a_proveedores_edit){
                                        botones += '<a href="/pagos-a-proveedores/' + data["id"] + '/edit/" class="btn btn-primary text-white mb-2 me-1" title="Editar"><i class="fa-sharp fa-solid fa-pen-to-square"></i>&nbsp;Editar</a>';
                                    }
                                    if ($pagos_a_proveedores_authorized && data.estatus.clave === estatus_por_autorizar){
                                        botones += '<button id="btn_autorizado-'+ data["id"] +'" data-id="'+ data["id"] +'" class="btn_autorizado btn btn-success text-white mb-2 me-1" title="Autorizado"><i class="fa-solid fa-arrow-up-right-from-square"></i>&nbsp;Autorizado</button>';
                                    }
                                    if ($pagos_a_proveedores_canceled && data.estatus.clave !== $estatus_cancelado){
                                        botones += '<button id="btn_cancelado-'+ data["id"] +'" data-id="'+ data["id"] +'" class="btn_cancelado btn btn-danger text-white mb-2 me-1" title="Cancelado">' +
                                            '<i class="fa-solid fa-arrow-up-right-from-square"></i>&nbsp;Cancelado</button>';
                                    }
                                    if ($pagos_a_proveedores_destroy && data.estatus.clave === estatus_por_autorizar){
                                        botones += '<button id="btn-eliminar-'+ data["id"] +'" data-id="' + data["id"] + '" class="btn_delete btn btn-danger text-white mb-2 me-1" title="Eliminar">' +
                                            '<i class="fa-sharp fa-solid fa-trash-can"></i>&nbsp;Eliminar</button>';
                                    }
                                    if($pagos_a_proveedores_send_email && (data.estatus.clave === estatus_por_autorizar || data.estatus.clave === estatus_autorizado)){
                                        botones += '<button id="btn_enviar_correo-'+ data["id"] +'" data-id="'+ data["id"] +'" data-emails="'+ data["emails"] +'" class="btn_enviar_correo btn btn-success text-white mb-2 me-1" title="Enviar correo">' +
                                            '<i class="fa-solid fa-envelope"></i>&nbsp;Enviar correo</button>';
                                    }
                                    return botones;
                                }
                            },
                            {data: 'codigo', name: 'codigo'},
                            {data: 'fecha_pago', name: 'fecha_pago'},
                            {data: 'orden_compra.id', name: 'orden_compra_id', visible: false},
                            {data: 'orden_compra.codigo', name: 'orden_compra_codigo'},
                            {data: 'proveedor_id', name: 'proveedor_id', visible: false},
                            {data: 'proveedor.razon_social', name: 'proveedor_id'},
                            {data: 'obra.nombre', name: 'obra_id'},
                            {data: 'conceptos_materiales', name: 'conceptos'},
                            {data: 'importe', name: 'importe'},
                            {data: 'importe_letras', name: 'importe_letras', visible: false, orderable: false},
                            {
                                data: 'orden_compra.orden_compra_anticipo', name: 'orden_compra.orden_compra_anticipo',
                                render: function( data, type, full, meta ){
                                    let tablaPagos = '';
                                    if (data.length > 0){
                                        $.each(data, function (index, val){
                                            if(val.tipo_pago !== null){
                                                if (val.es_ultimo){
                                                    var tipo_pago_nombre = (val.tipo_pago.nombre == 'Anticipos') ? 'Último anticipo' : val.tipo_pago.nombre;
                                                    tablaPagos+='<b class="text-danger">'+ tipo_pago_nombre +': $' + val.anticipo +'</b>';
                                                } else {
                                                    tablaPagos+=val.tipo_pago.nombre + ': $' + val.anticipo +'<br>';
                                                }
                                            }else{
                                                tablaPagos='<p class="text-danger">Por favor asigne un Tipo de Pago para mostrar el listado.</p>';
                                            }
                                        });
                                    } else {
                                        tablaPagos='--';
                                    }
                                    return tablaPagos;
                                }
                            },
                            {
                                data: 'orden_compra.orden_compra_anticipo', name: 'orden_compra.orden_compra_anticipo',
                                render: function( data, type, full, meta ){
                                    let saldoPorPagarHoy = 'N/A';
                                    if (data.length > 0){
                                        $.each(data, function (index, val){
                                            if(val.tipo_pago !== null && val.tipo_pago.nombre === 'Anticipos' && val.es_ultimo){
                                                var tipo_pago_nombre = (val.tipo_pago.nombre == 'Anticipos') ? 'Por pagar' : val.tipo_pago.nombre;
                                                saldoPorPagarHoy ='<b class="text-danger">'+ tipo_pago_nombre +': $' + val.anticipo +'</b>';
                                            }
                                        });
                                    } else {
                                        saldoPorPagarHoy='--';
                                    }
                                    return saldoPorPagarHoy;
                                }
                            },
                            {data: 'comentarios', name: 'comentarios', visible: false, orderable: false},
                            {data: 'estatus_id', name: 'estatus_id', visible: false},
                            {data: 'estatus.estatus', name: 'estatus_estatus'},
                        ],
                        layout: {
                            top1Start: {
                                buttons: [
                                    {
                                        extend: 'excel',
                                        text: '<i class="fa-solid fa-file-lines"></i> Imprimir Excel',
                                        messageTop: 'Pagos a proveedores',
                                        exportOptions: {
                                            //columns: [0,1,2,3,4,5,6,7,8,9,10],
                                            columns: ':visible'
                                        },
                                        className: 'btn btn-primary',
                                        excelStyles: [
                                            // {
                                            //     template: "blue_gray_medium",
                                            // },
                                            {
                                                cells: "3",
                                                style: {
                                                    font: {
                                                        name: "Arial",
                                                        size: "14",
                                                        color: "FFFFFF",
                                                        b: false,
                                                    },
                                                    fill: {
                                                        pattern: {
                                                            color: "E0592A",
                                                        }
                                                    }
                                                },
                                            },
                                        ]
                                    },
                                    {
                                        extend: 'print',
                                        text: '<i class="fa-solid fa-file-lines"></i> Imprimir avanzado',
                                        messageTop: 'Pagos a proveedores',
                                        exportOptions: {
                                            //columns: [0,1,2,3,4,5,6,7,8,9,10],
                                            //modifier: {selected: null}
                                            columns: ':visible',
                                        },
                                        className: 'btn btn-primary',
                                        customize: function (win) {
                                            $(win.document.body)
                                                .css('font-size', '10px')
                                                .prepend(
                                                    '<img src="<?php echo e(asset('Logotipo/Logotipo_Original.png')); ?>" width="100px" height="100px" style="position:relative; top:0; left:0;" />'
                                                );

                                            $(win.document.body)
                                                .find('table')
                                                .addClass('compact')
                                                .css('font-size', 'inherit');
                                        }
                                    },
                                    // {
                                    //     extend: 'pdfHtml5', download: 'open', orientation: 'landscape',
                                    //     text: '<i class="fa-solid fa-file-lines"></i> Imprimir',
                                    //     messageTop: 'Pagos a proveedores',
                                    //     exportOptions: {
                                    //         columns: [0,1,2,3,4,5,6,7,8,9,10],
                                    //         //columns: ':visible',
                                    //     },
                                    //     className: 'btn btn-primary',
                                    //     customize: function (doc) {
                                    //         doc.content.splice(1, 0, {
                                    //             margin: [0, 0, 0, 12],
                                    //             alignment: 'left',
                                    //             image: 'data:image/png;base64,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'
                                    //         });
                                    //     }
                                    // },
                                    'colvis'
                                ]
                            }
                        },
                         createdRow: function(row, data, dataIndex) {
                             $(row).attr('id', data.id);
                             $(row).attr('rowIndex', dataIndex);
                         },
                        //columnDefs: [
                            //{targets: [9,10], visible: false, orderable: false},
                        //]
                    });

                    $('#pagos-datatable tbody').on('click', '.btn_autorizado', function (e){
                        e.preventDefault();
                        var id_pago = $(this).data('id');
                        var data = {
                            id_pago: id_pago,
                            estatus_id: 3, //Autorizado
                        };
                        let title = 'Autorizar';
                        update_Estatus_Autorizado(data, title);
                    });

                    $('#pagos-datatable tbody').on('click', '.btn_cancelado', function (e){
                        e.preventDefault();
                        var id_pago = $(this).data('id');
                        var data = {
                            id_pago: id_pago,
                            estatus_id: 7, //Cancelado
                        }
                        let title = 'Cancelar';
                        update_Estatus_Autorizado(data, title);
                    });

                    $('#pagos-datatable tbody').on('click', '.btn_delete', function (e){
                        e.preventDefault();
                        var id_pago = $(this).data('id');
                        delete_pago(id_pago)
                    });

                    $('#pagos-datatable tbody').on('click', '.btn_enviar_correo', function (e){
                        e.preventDefault();
                        var id_pago = $(this).data('id');
                        var emails = $(this).data('emails');
                        $('#btn_enviar_correo-'+id_pago).attr("disabled", true);
                        $('.btn_enviar_correo').attr("disabled", true);
                        if (emails !== '' && emails !== null){
                            enviarCorreoServer(id_pago);
                        } else {
                            toastr.warning('No se puede enviar el correo, agrega al menos uno.');
                            $('#btn_enviar_correo-'+id_pago).attr("disabled", false); //habilitar
                            $('.btn_enviar_correo').attr("disabled", false);
                        }
                    });

                    $('#pdf_imprimir_seleccionados').off('click');
                    $("#pdf_imprimir_seleccionados").on("click", function () {
                        $('#pdf_imprimir_seleccionados').attr("disabled", true);
                        var selectedRows = pagos_datatableDT.rows('.selected').data().toArray();
                        if(selectedRows.length <= 10) {
                            imprimir_pdf(selectedRows);
                        } else {
                            toastr.warning('No se puede imprimir más de 10 registros.');
                            $('#pdf_imprimir_seleccionados').attr("disabled", false);
                        }
                    });

                    function delete_pago(id) {
                        if (id > 0 && id !== null && id !== "") {
                            Swal.fire({
                                title: "¿Está seguro de que desea eliminar el pago?",
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Si, eliminar!",
                                cancelButtonText: "No, cancelar!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    var url = APP_URL + '/pagos-a-proveedores/'+id;
                                    axios.delete(url)
                                        .then(response => {
                                            var resp = response.data;
                                            if(!resp.error){
                                                toastr.success(resp.message);
                                                pagos_datatableDT.draw(true);
                                            }else{
                                                toastr.warning('No se pudo eliminar el registro');
                                            }
                                        }).catch(e => {
                                        console.log(e);
                                        toastr.error('Ocurrio un error inesperado.');
                                    });
                                }
                            });

                        } else {
                            toastr.warning('Parametro incompleto para eliminar el registro');
                        }
                    }


                    $('#fecha_pago').change(function (e) {
                        var fecha_pago = $('#fecha_pago').val();
                        pagos_datatableDT.columns(3).search(fecha_pago).draw();
                    });

                    $('#orden_compra_id_select').on('select2:select', function (e) {
                        var data = e.params.data;
                        pagos_datatableDT.columns(4).search('^' + data.id + '$', true, false, true).draw();
                    });

                    $('#proveedor_id').on('select2:select', function (e) {
                        var data = e.params.data;
                        pagos_datatableDT.columns(6).search(data.id).draw();
                    });

                    $('#obra_id').on('select2:select', function (e) {
                        var data = e.params.data;
                        pagos_datatableDT.columns(8).search(data.id).draw();
                    });

                    $('#estatus_id').on('select2:select', function (e) {
                        var data = e.params.data;
                        pagos_datatableDT.columns(15).search(data.id).draw();
                    });

                    $(".js-programmatic-multi-clear").on("click", function () {
                        $('#fecha_pago').val('');
                        $('#orden_compra_id_select').val('').trigger('change');
                        $('#proveedor_id').val('').trigger('change');
                        $('#obra_id').val('').trigger('change');
                        $('#estatus_id').val(null).trigger('change');
                        pagos_datatableDT.columns([3,4,6,8,15]).search('').draw();
                    });

                    function update_Estatus_Autorizado(data, title){
                        if(data !== null && data !== false){
                            Swal.fire({
                                title: "¿Está seguro de que desea "+ title +" el pago a proveedor?",
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Si",
                                cancelButtonText: "No",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    var url_ = APP_URL + '/pago-update-estatus';
                                    axios.post(url_, data)
                                        .then(response => {
                                            var resp = response.data;
                                            console.log('resp -> ', resp);
                                            if(!resp.error){
                                                toastr.success(resp.message);
                                                var paginaActual = pagos_datatableDT.page.info().page;
                                                pagos_datatableDT.draw(true);
                                                pagos_datatableDT.page(paginaActual).draw(false);
                                            }else{
                                                toastr.warning(resp.message);
                                            }
                                        }).catch(e => {
                                        console.log(e);
                                        toastr.error('Ocurrio un error inesperado.');
                                    });
                                }
                            });
                        }else{
                            toastr.warning('No se pudo actualizar el estatus, intente de nuevo, si el problema persiste comunicarse con el administrador de la aplicación.');
                        }
                    }

                }); //End document-ready

                function enviarCorreoServer(clave){
                    if(clave !== null && clave !== ''){
                        var url_save = APP_URL + '/pagos-a-proveedores-print-pdf/' + clave + '/1';
                        axios.get(url_save)
                            .then(response =>{
                                var resp = response.data;
                                if(!resp.error){
                                    toastr.success('Correo electrónico enviado con éxito.');
                                }else{
                                    toastr.warning('Ocurrio un error al enviar el correo, contacte al administrador del sistema.');
                                }
                                $('#btn_enviar_correo-'+clave).attr("disabled", false); //habilitar
                                $('.btn_enviar_correo').attr("disabled", false);
                            }).catch(e => {
                            console.log(e);
                        });
                    } else {
                        toastr.warning('No se puede enviar el correo, faltan parámetros.');
                    }
                }

                function imprimir_pdf(data) {
                    if(data.length > 0){
                        var url_ = APP_URL + '/pagos-a-proveedores-print-pdf-list-selected';
                        axios.post(url_, data)
                            .then(response => {
                                var resp = response.data;
                                if(!resp.error){
                                    toastr.success(resp.message);
                                    pagos_datatableDT.draw(true);
                                    var href = APP_URL + '/' + resp.archivo_url;
                                    window.open(href, '_blank');
                                }else{
                                    toastr.warning(resp.message);
                                }
                                $('#pdf_imprimir_seleccionados').attr("disabled", false);
                            }).catch(e => {
                            console.log(e);
                            toastr.error('Ocurrio un error inesperado.');
                        });
                    } else {
                        toastr.warning('Debe seleccionar al menos un pago a proveedor.');
                        $('#pdf_imprimir_seleccionados').attr("disabled", false);
                    }
                }

            </script>

            <?php if(session()->has('success')): ?>
                <script>
                    toastr.success("<?php echo e(session('success')); ?>");
                </script>
            <?php endif; ?>

            <?php if(session()->has('message')): ?>
                <script>
                    toastr.error('Ocurrio un error inesperado.');
                </script>
            <?php endif; ?>
        <?php $__env->stopPush(); ?>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH /var/www/html/arista_app/resources/views/admin/pagos_a_proveedores/lista.blade.php ENDPATH**/ ?>