<?php $carbon = app('Carbon\Carbon'); ?>
<?php $Functions = app('App\Http\Helpers\FunctionsHelper'); ?>
    <!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Solicitud de compra</title>

    <?php if(env('APP_ENV') == 'production'): ?>
        <link rel="stylesheet" href="http://aristamid.com/css/app.css">
        <link href="http://aristamid.com/css/prints-solicitud-pdf.css" media="all" rel="stylesheet" type="text/css" />
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(base_path('public/css/app.css')); ?>">
        <link href="<?php echo e(base_path('public/css/prints-solicitud-pdf.css')); ?>" media="all" rel="stylesheet" type="text/css" />
    <?php endif; ?>

</head>
<body>
<?php
    use App\Http\Helpers\Consts;
?>

<?php $__currentLoopData = $solicitudes_de_compras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $solicitud_compra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<?php
    $solicitud_compra_clave_version = $solicitud_compra->clave_version;
    $obra = $solicitud_compra->obra;
    $ingeniero = $solicitud_compra->ingeniero;
?>










<div class="container-fluid">

        <div class="row">
            <div class="col-12">
                <div class="mb-1">
                    <table class="table tabla_sin_border">
                        <tbody>
                            <tr style="padding-bottom: 0!important;">
                                <td width="15%" class="no_border">
                                    <?php if(env('APP_ENV') == 'production'): ?>
                                        <img class="img-logo" src="<?php echo e(public_path('Logotipo/Logotipo_Original.png')); ?>" style="width: 100px!important; height: 100px!important;">
                                    <?php else: ?>
                                        <img class="img-logo" src="<?php echo e(public_path('Logotipo/Logotipo_Original.png')); ?>" style="width: 100px!important; height: 100px!important;">
                                    <?php endif; ?>
                                </td>
                                <td width="55%" class="no_border">
                                    <h1 class="titulo_arista">ARISTA AR SA DE CV</h1>
                                    <p class="direccion_arista">CALLE 19 X 56 NUMERO 363 PLAN DE AYALA NORTE, YUCATAN, CP. 97118</p>
                                    <p class="direccion_arista">RFC: AAR080509D22</p>
                                    <p class="direccion_arista">Tel.:999 944 5327</p>
                                </td>
                                <td width="30%" class="no_border">
                                    <table class="table tabla_con_border" style="margin-bottom: 0!important;">
                                        <thead>
                                            <tr>
                                                <th colspan="2"><p class="_title_requisicion_">REQUISICIÓN DE COMPRA</p></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">REQUISICIÓN SEMANAL N.</p></td>
                                                <td>
                                                    <p class="_requisicion_dato_"><?php echo e($solicitud_compra->codigo); ?></p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">OBRA:</p></td>
                                                <td>
                                                    <p class="_requisicion_dato_"><?php echo e($obra->nombre); ?></p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">ELABORÓ:</p></td>
                                                <td>
                                                    <p class="_requisicion_dato_"><?php echo e($ingeniero->nombre); ?></p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="bg_box_tabla_gris"><p class="_subtitle_requisicion_">FECHA SOLICITADA:</p></td>
                                                <td>
                                                    <p class="_requisicion_dato_"><?php echo e($Functions->formatDateFormat2($solicitud_compra->fecha_solicitud)); ?></p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>


    

        <div class="row">
            <div class="col-12">
                <div class="mt-1">
                    <table class="table tabla_con_border">
                        <thead>
                            <tr class="table_thead_bg_naranja">

                                <th scope="col">CÓDIGO</th>
                                <th scope="col">MATERIAL</th>
                                <th scope="col">UNIDAD</th>
                                <th scope="col">CANTIDAD</th>
                                <th scope="col">ÁREA DE USO</th>
                                <th scope="col">MARCA
                                <th scope="col">MODELO</th>
                                <th scope="col">OBSERVACIONES</th>
                                <th scope="col">COMENTARIO GRUPAL</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php
                            $lista_materiales = [];
                            if ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V1 || ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id == null)) {
                                $lista_materiales = $solicitud_compra->solicitudCompraProducto;
                            } else if ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id !== null) {
                                $lista_materiales = $solicitud_compra->SolicitudCompraProductoClon;
                            }
                        ?>

                        <?php $__currentLoopData = $lista_materiales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $material): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                //$comentario_Material_grupal = (!empty($material->RelSolicitudProductoComentarioMaterial)) ? $material->RelSolicitudProductoComentarioMaterial->comentariosMaterial->comentario : "";
                                $comentario_Material_grupal = "--";
                                if ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V1 || ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id == null)) {
                                    $comentario_Material_grupal = (!empty($material->RelSolicitudProductoComentarioMaterial)) ? $material->RelSolicitudProductoComentarioMaterial->comentariosMaterial->comentario : "";
                                }else if ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id !== null) {
                                    //$comentario_Material_grupal = (!empty($material->RelSolicitudProductoComentarioMaterialClon)) ? $material->RelSolicitudProductoComentarioMaterialClon->ComentarioMaterialClon->comentario : "";
                                }
                            ?>
                            <tr>

                                <td class="_padding_tb_ text-center"><?php echo e($material->producto->codigo); ?></td>
                                <td class="_padding_tb_"><?php echo e($material->producto->nombre); ?></td>
                                <td class="_padding_tb_ text-center"><?php echo e($material->unidad->nombre); ?></td>
                                <td class="_padding_tb_ text-center"><?php echo e($material->cantidad); ?></td>
                                <td class="_padding_tb_ text-center"><?php echo e($material->area_de_uso); ?></td>
                                <td class="_padding_tb_ text-center"><?php echo e($material->marca); ?></td>
                                <td class="_padding_tb_ text-center"><?php echo e($material->modelo); ?></td>
                                <td class="_padding_tb_ text-center"><?php echo e($material->observaciones); ?></td>
                                <td class="_padding_tb_ text-center"><?php echo e($comentario_Material_grupal); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>


    

    <section>
        <div class="mt-1">
            <table class="table tabla_con_border">
                <tbody>
                <tr>
                    <td width="60%">
                        <p class=""><?php echo e($solicitud_compra->observaciones); ?></p>
                    </td>
                    <td style="background-color: #ff9933;">
                        <p class="footer_oc_">FECHA DE ENTREGA SOLICITADA</p>
                        <p class="text-center"><?php echo e($Functions->formatDateFormat2($solicitud_compra->fecha_entrega)); ?></p>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </section>

</div>

<?php if(!$loop->last): ?>
    <div class="nueva-pagina"></div>
<?php endif; ?>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>
</html>
<?php /**PATH /var/www/html/arista_app/resources/views/admin/solicitud_de_compras/print_pdf_lista_solicitudes_de_compras.blade.php ENDPATH**/ ?>