<?php $carbon = app('Carbon\Carbon'); ?>
<?php $Functions = app('App\Http\Helpers\FunctionsHelper'); ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Orden de compra</title>

    <?php if(env('APP_ENV') == 'production'): ?>
        <link rel="stylesheet" href="http://aristamid.com/css/app.css">
        <link href="http://aristamid.com/css/prints-oc-pdf.css" media="all" rel="stylesheet" type="text/css" />
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(base_path('public/css/app.css')); ?>">
        <link href="<?php echo e(base_path('public/css/prints-oc-pdf.css')); ?>" media="all" rel="stylesheet" type="text/css" />
    <?php endif; ?>

</head>
<body>
<?php
    use App\Http\Helpers\Consts;

    //Estatus
    $estatus_por_autorizar = $estatus_por_autorizar->clave;
    $estatus_autorizado = $estatus_autorizado->clave;

    //O.C.
    $orden_compra_clave_version = $orden_compra->clave_version;
    $orden_compra_solicitud_compra_clon_id = $orden_compra->solicitud_compra_clon_id;
    $orden_compra_estatus = $orden_compra->estatus->clave;

    $proveedor = $orden_compra->proveedor;
    $lista_anticipos = $orden_compra->ordenCompraAnticipo;
?>











<?php if($solo_requisicion_compras === 0): ?>

<div class="container-fluid">
    <section>
        <div class="mb-1">
            <table class="table tabla_sin_border">
                <tbody>
                    <tr>
                        <td width="15%" class="no_border">
                            <?php if(env('APP_ENV') == 'production'): ?>
                                <img class="img-logo" src="<?php echo e(public_path('Logotipo/Logotipo_Original.png')); ?>" style="width: 100px!important; height: 100px!important;">
                            <?php else: ?>
                                <img class="img-logo" src="<?php echo e(public_path('Logotipo/Logotipo_Original.png')); ?>" style="width: 100px!important; height: 100px!important;">
                            <?php endif; ?>
                        </td>
                        <td width="55%" class="no_border">
                            <h1 class="titulo_arista">ARISTA AR SA DE CV</h1>
                            <p class="direccion_arista">CALLE 19 X 56 NUMERO 363 PLAN DE AYALA NORTE, YUCATAN, CP. 97118</p>
                            <p class="direccion_arista">RFC: AAR080509D22</p>
                            <p class="direccion_arista">Tel.:999 944 5327</p>
                        </td>
                        <td width="30%" class="no_border">
                            <h1 class="title_oc_header">ORDEN DE COMPRA</h1>
                            <p class="subtitle_oc_header"><?php echo e($orden_compra->codigo); ?>/<?php echo e(\Carbon\Carbon::parse($orden_compra->fecha_orden)->format('Y')); ?></p>
                            <h1 class="title_oc_header">OBRA</h1>
                            <p class="subtitle_oc_header"><?php echo e($orden_compra->solicitudCompra->obra->nombre); ?></p>
                            <?php if($obra_mantenimiento === $orden_compra->solicitudCompra->obra->clave): ?>
                            <h1 class="title_oc_header">COMENTARIO</h1>
                            <p class="subtitle_oc_header"><?php echo e($orden_compra->comentarios); ?></p>
                            <?php endif; ?>
                            <h1 class="title_oc_header">N<sup>o</sup> CONTROL</h1>
                            <p class="subtitle_oc_header"><?php echo e($orden_compra->solicitudCompra->obra->no_control); ?></p>
                            <h1 class="title_oc_header">FECHA</h1>
                            <p class="subtitle_oc_header" style="font-weight: normal;"><?php echo e($Functions->formatDateFormat2($orden_compra->fecha_orden)); ?></p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        
        <div class="mt-1">
            <h2 class="title_proveedor_">PROVEEDOR</h2>
            <table class="table tabla_sin_border">
                <tbody>
                    <tr>
                        <td style="width: 50%" class="no_border">
                            <table class="table tabla_sin_border">
                                <tbody>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">NOMBRE:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_" style="font-weight: bold;"><?php echo e($proveedor->razon_social); ?></p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">DIRECIÓN:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_"><?php echo e($proveedor->direccion); ?></p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">TELÉFONO:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_"><?php echo e($proveedor->telefono); ?></p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">CORREO:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_"><?php echo e($proveedor->email); ?></p></td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td style="width: 50%" class="no_border">
                            <table class="table tabla_sin_border">
                                <tbody>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">RFC:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_"><?php echo e($proveedor->rfc); ?></p></td>
                                    </tr>
                                    <tr>
                                        <th class="no_border bg_box_tabla_naranja"><p class="proveedor_datos_">CONTACTO:</p></th>
                                        <td class="no_border"><p class="proveedor_datos_text_"><?php echo e($proveedor->contacto); ?></p></td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        

        
        <div class="mt-1">
            <table class="table tabla_sin_border">
                <tbody>
                    <tr>
                        <td style="width: 33.33%" class="no_border">
                            <table class="table tabla_sin_border">
                                <tbody>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">L.A.B.:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_"></p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">VÍA:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_"></p><?php echo e($orden_compra->metodo_envio); ?></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">CONDICIONES DE PAGO:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_"></p><?php echo e($orden_compra->conticiones_de_pago); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td style="width: 33.33%" class="no_border">
                            <table class="table tabla_sin_border">
                                <tbody>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">FECHA DE ENTREGA:</p></th>
                                        <td class="no_border">
                                            <?php if($orden_compra->fecha_entrega): ?>
                                                <p class="oc_datos_text_"><?php echo e($Functions->formatDate($orden_compra->fecha_entrega)); ?></p>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">FECHA DE EMBARQUE:</p></th>
                                        <td class="no_border">
                                            <?php if($orden_compra->fecha_embarque): ?>
                                                <p class="oc_datos_text_"><?php echo e($Functions->formatDate($orden_compra->fecha_embarque)); ?></p>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">VENDEDOR:</p></th>
                                        <td class="no_border">
                                            <p class="oc_datos_text_"><?php echo e($orden_compra->vendedor); ?></p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td style="width: 33.33%" class="no_border">
                            <table class="table tabla_sin_border">
                                <tbody>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">CONSIGNAR A:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_">ARISTA AR SA DE CV</p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">FACTURAR A:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_">ARISTA AR SA DE CV</p></td>
                                    </tr>
                                    <tr>
                                        <th width="120px" class="no_border bg_box_tabla_gris"><p class="oc_datos_">RFC:</p></th>
                                        <td class="no_border"><p class="oc_datos_text_">AAR080509D22</p></td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        
    </section>

    <p class="condiciones_orden_">Previa aceptación de las condiciones e instrucciones que aparecen en esta orden de compra, sírvase enviarnos la &nbsp;<b>&nbsp;orden firmada</b>:</p>

    
    <section>
        <div class="mt-1">
            <table class="table tabla_sin_border">
                <thead>
                    <tr class="table_thead_bg_naranja">
                        <th scope="col">CÓDIGO</th>
                        <th scope="col">DESCRIPCIÓN</th>
                        <th scope="col">MARCA</th>
                        <th scope="col">MODELO</th>
                        <th scope="col">UNIDAD</th>
                        <th scope="col">CANTIDAD</th>
                        <th scope="col">PRECIO M.N.</th>
                        <th scope="col">IMPORTE M.N</th>
                    </tr>
                </thead>
                <tbody>

                <?php
                    $lista_materiales = [];
                    if ($orden_compra_clave_version === Consts::ORDEN_COMPRA_V1 || ($orden_compra_clave_version === Consts::ORDEN_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id == null)) {
                        $lista_materiales = $orden_compra->solicitudCompra->solicitudCompraProducto;
                    } else if ($orden_compra_clave_version === Consts::ORDEN_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id !== null) {
                        $lista_materiales = $orden_compra->SolicitudCompraClon->SolicitudCompraProductoClon;
                    }
                ?>

                <?php $__currentLoopData = $lista_materiales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $material): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="_padding_tb_ text-center"><?php echo e($material->producto->codigo); ?></td>
                        <td class="_padding_tb_"><?php echo e($material->producto->nombre); ?></td>
                        <td class="_padding_tb_"><?php echo e($material->marca); ?></td>
                        <td class="_padding_tb_"><?php echo e($material->modelo); ?></td>
                        <td class="_padding_tb_"><?php echo e($material->unidad->nombre); ?></td>
                        <td class="_padding_tb_"><?php echo e($material->cantidad); ?></td>
                        <?php if($orden_compra_clave_version === Consts::ORDEN_COMPRA_V1): ?>
                            <td class="_padding_tb_">$<?php echo e(number_format($material->precio_unitario, 2)); ?></td>
                            <td class="_padding_tb_">$<?php echo e(number_format($material->subtotal, 2)); ?></td>
                        <?php elseif($orden_compra_clave_version === Consts::ORDEN_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id == null): ?>
                            <td class="_padding_tb_">$<?php echo e(number_format($material->rel_solicitud_compra_producto_precio->precio_unitario, 2)); ?></td>
                            <td class="_padding_tb_">$<?php echo e(number_format($material->rel_solicitud_compra_producto_precio->subtotal, 2)); ?></td>
                        <?php elseif($orden_compra_clave_version === Consts::ORDEN_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id !== null): ?>
                            <td class="_padding_tb_">$<?php echo e(number_format($material->precio_unitario, 2)); ?></td>
                            <td class="_padding_tb_">$<?php echo e(number_format($material->subtotal, 2)); ?></td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
















                


                
                <tr style="margin-top: 10px!important;">
                    <td colspan="5" class="no_border" >
                        
                        <?php if(count($orden_compra->ordenCompraAnticipo) > 0): ?>
                            <?php $__currentLoopData = $lista_anticipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $anticipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="box_anticipos_green_ me-5">
                                    <p class="anticipos_result_ text-uppercase"><?php echo e($anticipo->comentario); ?> POR LA CANTIDAD DE <strong>$<?php echo e(number_format($anticipo->anticipo, 2)); ?></strong></p>
                                    <p class="anticipos_result_ text-uppercase"><?php echo e($anticipo->anticipo_letras); ?></p>
                                    <p class="anticipos_result_ text-uppercase">Forma de pago: <?php echo e($anticipo->forma_de_pago); ?></p>
                                    <p class="anticipos_result_"><?php echo e($Functions->formatDateFormat2($anticipo->fecha_anticipo)); ?></p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        
                    </td>
                    <td colspan="3" class="no_border">
                        <table class="table table-borderless tabla_sin_border">
                            <tbody>
                                <tr>
                                    <td width="50%" class="bg_box_tabla_naranja"><p class="proveedor_datos_">SUBTOTAL:</p></td>
                                    <td style="width: 50%;">$ <?php echo e(number_format($orden_compra->importe_sin_impuestos, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td width="50%" class="bg_box_tabla_naranja"><p class="proveedor_datos_">IVA <?php if($orden_compra->ivaImpuesto !== null): ?> <?php echo e($orden_compra->ivaImpuesto->nombre); ?> <?php endif; ?></p></td>
                                    <td>$ <?php echo e(number_format($orden_compra->monto_iva, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td width="50%" class="bg_box_tabla_naranja"><p class="proveedor_datos_">ISR</p></td>
                                    <td>$ <?php echo e(number_format($orden_compra->monto_isr, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td width="50%" class="bg_box_tabla_naranja"><p class="proveedor_datos_">TOTAL:</p></td>
                                    <td><strong>$ <?php echo e(number_format($orden_compra->total, 2)); ?></strong></td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
                
                </tbody>
            </table>
        </div>
    </section>
    

    <section>
        <div>
            <p class="importe_letras">Total en letras: <?php echo e($orden_compra->total_letras); ?></p>
            <p class="condiciones_orden_"><b>Comentario de Gloria</b>: <?php echo e($orden_compra->comentario_gloria); ?></p>
        </div>
    </section>

    <section>
        <div class="mt-1">
            <table class="table tabla_con_border">
                <tbody>
                    <tr>
                        <td width="90px;" style="vertical-align: bottom !important;">
                            <p class="no_control_"><?php echo e($orden_compra->solicitudCompra->obra->no_control); ?></p>
                            <p class="no_control_" style="margin-bottom: 5px !important;">N<sup>o</sup> CONTROL</p>
                        </td>
                        <td colspan="3">
                            <p class="footer_oc_">ORDEN COMPRA: <?php echo e($orden_compra->codigo); ?>/<?php echo e(\Carbon\Carbon::parse($orden_compra->fecha_orden)->format('Y')); ?></p>
                            <p class="footer_oc_obra_"><?php echo e($orden_compra->solicitudCompra->obra->nombre); ?></p>
                            <p class="footer_oc_obra_">OBRA</p>
                        </td>
                        <td style="vertical-align: bottom !important;">
                            <p class="footer_info_"><?php echo e($orden_compra->solicitudCompra->ingeniero->nombre); ?></p>
                            <p class="footer_info_bold">CONTROL OBRA</p>
                        </td>
                        <td style="vertical-align: bottom !important;">
                            <p class="footer_info_">Marcos Perez</p>
                            <p class="footer_info_bold">RES. DE OBRA</p>
                        </td>
                        <td style="vertical-align: bottom !important;">
                            <p class="footer_info_">Cindy Sosa</p>
                            <p class="footer_info_bold">ADMINISTRACIÓN</p>
                        </td>
                        <td style="vertical-align: bottom !important;">
                            <p class="footer_info_">Jorge Romero</p>
                            <p class="footer_info_bold">DIRECCIÓN</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </section>

</div>

<div class="nueva-pagina"></div>


<?php endif; ?>

<?php
    $solicitud_compra = [];
    if ($orden_compra_clave_version === Consts::ORDEN_COMPRA_V1 || ($orden_compra_clave_version === Consts::ORDEN_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id == null)) {
        $solicitud_compra = $orden_compra->solicitudCompra;
    } else if ($orden_compra_clave_version === Consts::ORDEN_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id !== null) {
        $solicitud_compra = $orden_compra->SolicitudCompraClon;
    }
?>

<?php echo $__env->make('admin.solicitud_de_compras.print_pdf_sol_compra', ['solicitud_compra' => $solicitud_compra, 'orden_compra_solicitud_compra_clon_id' => $orden_compra_solicitud_compra_clon_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>
<?php /**PATH /var/www/html/arista_app/resources/views/admin/ordenes_de_compras/print_pdf_oc.blade.php ENDPATH**/ ?>