<x-app-layout>
    <x-slot name="header">
        <h3 class="text-center">
            {{ __('Solicitud de compras') }}
        </h3>
    </x-slot>

    @push('styles')
        <link rel="stylesheet" href="{{asset('plugins2/bootstrap-datepicker/css/bootstrap-datepicker.min.css')}}">
    @endpush

    @php
        $estatus_por_autorizar = $estatus_por_autorizar->clave;
        $estatus_autorizado = $estatus_autorizado->clave;
        $estatus_finalizado = $estatus_finalizado->clave;
    @endphp

    <div class="panel">
        <div class="panel-body demo-nifty-alert">
            <div class="container-fluid">

                <div class="row mb-2">
                    <div class="col-12 d-flex justify-content-center">
                        <div class="float-left order-2 pr-1">

                            @can('solicitud_de_compras_create')
                                <a href="{{ route('solicitud-de-compras.create') }}" class="btn btn-primary px-2 py-2 text-white mx-2">
                                    <i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Crear solicitud
                                </a>

{{--                                <button type="button" id="btn_clonar_solicitud" class="btn btn-primary px-2 py-2 text-white mx-2"><i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Clonar solicitud</button>--}}
                            @endcan

{{--                                <a href="" class="btn btn-primary px-2 py-2 text-white">--}}
{{--                                    <i class="fa-solid fa-file-lines"></i>&nbsp;Importar desde excel--}}
{{--                                </a>--}}

                        </div>
                    </div>
                </div>

                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="obra_id" class="form-label">Obra</label>
                                        <select class="form-control" id="obra_id" name="obra_id"></select>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="ingeniero_id" class="form-label">Elaboro</label>
                                        <select class="form-control" id="ingeniero_id" name="ingeniero_id"></select>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="fecha_solicitud" class="form-label">Fecha solicitud</label>
                                        <div class="input-group date">
                                            <input type="text" class="form-control" name="fecha_solicitud" id="fecha_solicitud" autocomplete="off" placeholder="yyyy-mm-dd" readonly>
                                            <div class="input-group-addon">
                                                <i class="fa-regular fa-calendar-days"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="fecha_entrega" class="form-label">Fecha entrega</label>
                                        <div class="input-group date">
                                            <input type="text" class="form-control" name="fecha_entrega" id="fecha_entrega" autocomplete="off" placeholder="yyyy-mm-dd" readonly>
                                            <div class="input-group-addon">
                                                <i class="fa-regular fa-calendar-days"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <label for="estatus_id" class="form-label">Estatus</label>
                                        <select class="form-control" id="estatus_id" name="estatus_id"></select>
                                    </div>
                                    <div class="col-12 col-sm-2 col-md-2 col-lg-2">
                                        <button type="button" class="js-programmatic-multi-clear btn btn-primary mb-3 text-white mt-4" aria-label="Limpiar todo">Limpiar</button>
                                    </div>
                                </div>

                                @can('solicitud_de_compras_export')
                                <div class="row">
                                    <div class="col-12 d-flex justify-content-start">
                                        <button type="button" id="pdf_imprimir_seleccionados" class="btn btn-success text-white mt-2 mb-2"><i class="fa-solid fa-print"></i>&nbsp;PDF Imprimir seleccionados</button>
                                        <button type="button" id="imprimir_excel" target="_blank" class="btn btn-success text-white mt-2 mb-2 mx-2" aria-label="Imprimir Excel"><i class="fa-solid fa-print"></i>&nbsp;Imprimir Excel</button>
                                    </div>
                                </div>
                                @endcan

                                <div class="row mt-3">
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table id="solicitud-compras-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                                <thead>
                                                <tr>
                                                    <th>Clave</th>
                                                    <th>Acciones</th>
                                                    <th>Código</th>
                                                    <th>Clave de Obra</th>
                                                    <th>Obra</th>
                                                    <th>Elaboro</th>
                                                    <th>Fecha solicitud</th>
                                                    <th>Fecha entrega</th>
                                                    <th>Estatus</th>
                                                    <th>Estatus</th>
                                                    <th>Materiales</th>
                                                    <th>Comentarios adicionales</th>
                                                </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        @push('scripts')
            <script src="{{asset('plugins2/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>
            <script src="{{asset('plugins2/bootstrap-datepicker/locales/bootstrap-datepicker.es.min.js')}}"></script>
            <script type="text/javascript">
                var APP_URL = {!! json_encode(url('/')) !!};
                var solicitud_comprasDT = null;
                var $solicitud_de_compras_show = @json($solicitud_de_compras_show);
                var $solicitud_de_compras_edit = @json($solicitud_de_compras_edit);
                var $solicitud_de_compras_destroy = @json($solicitud_de_compras_destroy);
                var $solicitud_de_compras_export = @json($solicitud_de_compras_export);
                var $solicitud_de_compras_send_email = @json($solicitud_de_compras_send_email);
                var $solicitud_de_compras_authorized = @json($solicitud_de_compras_authorized);
                var $solicitud_de_compras_finalized = @json($solicitud_de_compras_finalized);
                //Estatus
                var estatus_por_autorizar = @json($estatus_por_autorizar);
                var estatus_autorizado = @json($estatus_autorizado);
                var estatus_finalizado = @json($estatus_finalizado);
                //Roles
                var $user_role_root_dev = @json($user_role_root_dev);
                var $user_role_super_usr_o_root_arq = @json($user_role_super_usr_o_root_arq);
                var $role_ing_jefe_gloria = @json($role_ing_jefe_gloria);
                var $role_ing = @json($role_ing);

                $(document).ready(function() {

                    $('#obra_id').select2({
                        width: '100%',
                        theme: "bootstrap",
                        placeholder: 'Selecciona una opción',
                        ajax: {
                            dataType: 'json',
                            url: APP_URL + "/get-lista-obras-select",
                            delay: 250,
                            data: function(params) {
                                return {
                                    search: params.term
                                }
                            },
                            processResults: function (data, page) {
                                return {
                                    results: data
                                };
                            }
                        },
                        cache: true,
                        //allowClear: true
                    });

                    $('#ingeniero_id').select2({
                        width: '100%',
                        theme: "bootstrap",
                        placeholder: 'Selecciona una opción',
                        ajax: {
                            dataType: 'json',
                            url: APP_URL + "/get-lista-ingenieros-select",
                            delay: 250,
                            data: function(params) {
                                return {
                                    search: params.term
                                }
                            },
                            processResults: function (data, page) {
                                return {
                                    results: data
                                };
                            }
                        },
                        cache: true
                    });

                    $('#fecha_solicitud').datepicker({
                        language: 'es',
                        autoclose: true,
                        format: "yyyy-mm-dd",
                        todayHighlight: true
                    });

                    $('#fecha_entrega').datepicker({
                        language: 'es',
                        autoclose: true,
                        format: "yyyy-mm-dd",
                        todayHighlight: true,
                    });

                    $('#estatus_id').select2({
                        width: '100%',
                        theme: "bootstrap",
                        placeholder: 'Selecciona una opción',
                        cache: true,
                        ajax: {
                            dataType: 'json',
                            url: APP_URL + "/get-lista-estatus-select",
                            delay: 250,
                            data: function(params) {
                                return {
                                    search: params.term,
                                    type: 'solicitud_compras'
                                }
                            },
                            processResults: function (data, page) {
                                return {
                                    results: data
                                };
                            }
                        },
                    });

                    solicitud_comprasDT = new DataTable('#solicitud-compras-datatable', {
                        lengthMenu: [[1,2,3,4,5,6,7,8,9,10,15,20,25,50,100,-1], [1,2,3,4,5,6,7,8,9,10,15,20,25,50,100, 'Todos']],
                        processing: true,
                        serverSide: true,
                        autoWidth: false,
                        pageLength: 10,
                        responsive: true,
                        scrollX: false,
                        fixedColumns: true,
                        fixedHeader: false,
                        select: {style:'multi'},
                        "language": {
                            "url": "../../plugins/DataTables/language.MX.json"
                        },
                        "order": [[ 0, "desc" ]],
                        ajax: {
                            url: '{{ route('solicitud-de-compras.get-lista-solicitud-compras') }}',
                            method: 'get',
                        },
                        columns: [
                            {data: 'id', name: 'id'},
                            {
                                data: null,
                                render: function( data, type, full, meta ){
                                    var botones = '';
                                    if ($solicitud_de_compras_export){
                                        botones += '<a href="/solicitud-de-compras-print-pdf/'+ data["id"] +'" class="btn btn-primary text-white mb-2 me-1" title="Imprimir" target="_blank">' +
                                            '<i class="fa-solid fa-print"></i>&nbsp;Imprimir' +
                                            '</a>';
                                    }
                                    if ($solicitud_de_compras_show){
                                        botones += '<a href="/solicitud-de-compras/'+ data["id"] +'" class="btn btn-success text-white mb-2 me-1" title="Ver información"><i class="fa-regular fa-eye"></i>&nbsp;Información</a>';
                                    }
                                    if(
                                        (($role_ing_jefe_gloria || $user_role_root_dev || $role_ing) && data.estatus.clave === estatus_por_autorizar)
                                        || (($user_role_super_usr_o_root_arq || $user_role_root_dev) && data.estatus.clave === estatus_autorizado)
                                    ) {
                                        botones += '<a href="/solicitud-de-compras/' + data["id"] + '/edit/" class="btn btn-primary text-white mb-2 me-1" title="Editar"><i class="fa-sharp fa-solid fa-pen-to-square"></i>&nbsp;Editar</a>';
                                    }
                                    if($solicitud_de_compras_destroy && data.estatus.clave === estatus_por_autorizar){
                                        botones += '<button id="btn_delete" data-id="' + data["id"] + '" class="btn btn-danger text-white mb-2 me-1" title="Eliminar"><i class="fa-sharp fa-solid fa-trash-can"></i>&nbsp;Eliminar</button>';
                                    }
                                    if($solicitud_de_compras_send_email){
                                        botones += '<button id="btn_enviar_correo-'+ data["id"] +'" data-id="'+ data["id"] +'" data-emails="'+ data["emails"] +'" class="btn_enviar_correo btn btn-success text-white mb-2 me-1" title="Enviar correo"><i class="fa-solid fa-envelope"></i>&nbsp;Enviar correo</button>';
                                    }
                                    if ($solicitud_de_compras_authorized && data.estatus.clave === estatus_por_autorizar){
                                        botones += '<button id="btn_autorizado-'+ data["id"] +'" data-id="'+ data["id"] +'" class="btn_autorizado btn btn-success text-white mb-2 me-1" title="Autorizado"><i class="fa-solid fa-arrow-up-right-from-square"></i>&nbsp;Autorizado</button>';
                                    }
                                    if ($solicitud_de_compras_finalized && data.estatus.clave === estatus_autorizado){
                                        botones += '<button id="btn_finalizado-'+ data["id"] +'" data-id="'+ data["id"] +'" class="btn_finalizado btn btn-success text-white mb-2 me-1" title="Finalizado"><i class="fa-solid fa-arrow-up-right-from-square"></i>&nbsp;Finalizado</button>';
                                    }
                                    return botones;
                                }
                            },
                            {data: 'codigo', name: 'codigo'},
                            {data: 'obra.id', name: 'obra_id', visible: false},
                            {data: 'obra.nombre', name: 'obra_nombre'},
                            {data: 'ingeniero.nombre', name: 'ingeniero_id'},
                            {data: 'fecha_solicitud', name: 'fecha_solicitud'},
                            {data: 'fecha_entrega', name: 'fecha_entrega'},
                            {data: 'estatus_id', name: 'estatus_id', visible: false},
                            {data: 'estatus.estatus', name: 'estatus_estatus'},
                            {data: 'conceptos_materiales', name: 'conceptos_materiales'},
                            {data: 'observaciones', name: 'observaciones'},
                        ],
                        layout: {
                            top1Start: {
                                buttons: [
                                    // {
                                    //     extend: 'excel',
                                    //     text: '<i class="fa-solid fa-file-lines"></i> Imprimir Excel',
                                    //     messageTop: 'Solicitud de compras',
                                    //     exportOptions: {
                                    //         columns: ':visible'
                                    //     },
                                    //     className: 'btn btn-primary',
                                    //     excelStyles: [
                                    //         {
                                    //             cells: "3",
                                    //             style: {
                                    //                 font: {
                                    //                     name: "Arial",
                                    //                     size: "14",
                                    //                     color: "FFFFFF",
                                    //                     b: false,
                                    //                 },
                                    //                 fill: {
                                    //                     pattern: {
                                    //                         color: "E0592A",
                                    //                     }
                                    //                 }
                                    //             },
                                    //         },
                                    //     ]
                                    // },
                                    {
                                        extend: 'print',
                                        text: '<i class="fa-solid fa-file-lines"></i> Imprimir avanzado',
                                        messageTop: 'Solicitud de compras',
                                        exportOptions: {
                                            columns: ':visible'
                                        },
                                        className: 'btn btn-primary',
                                        customize: function (win) {
                                            $(win.document.body)
                                                .css('font-size', '10px')
                                                .prepend(
                                                    '<img src="{{ asset('Logotipo/Logotipo_Original.png') }}" width="100px" height="100px" style="position:relative; top:0; left:0;" />'
                                                );

                                            $(win.document.body)
                                                .find('table')
                                                .addClass('compact')
                                                .css('font-size', 'inherit');
                                        }
                                    },
                                    'colvis'
                                ]
                            }
                        },
                        createdRow: function(row, data, dataIndex) {
                            $(row).attr('id', data.id);
                            $(row).attr('rowIndex', dataIndex);
                        },
                        columnDefs: [
                            {targets: [0], className: "text-center", orderable: true},
                            {targets: [1], className: "text-center", orderable: false},
                            {targets: [7], className: "text-left", orderable: false},
                            {targets: [-1], orderable: false},
                        ]
                    });

                    $('#solicitud-compras-datatable tbody').on('click', '#btn_delete', function (e){
                        e.preventDefault();
                        var clave = $(this).data('id');
                        delete_solicitud_compra(clave);
                    });

                    $('#pdf_imprimir_seleccionados').off('click');
                    $("#pdf_imprimir_seleccionados").on("click", function () {
                        $('#pdf_imprimir_seleccionados').attr("disabled", true);
                        var selectedRows = solicitud_comprasDT.rows('.selected').data().toArray();
                        if(selectedRows.length <= 10) {
                            imprimir_pdf(selectedRows);
                        } else {
                            toastr.warning('No se puede imprimir más de 10 solicitudes de compras.');
                            $('#pdf_imprimir_seleccionados').attr("disabled", false);
                        }
                    });

                    function delete_solicitud_compra(id) {
                        if (id > 0 && id !== null && id !== "") {
                            Swal.fire({
                                title: "¿Está seguro de que desea eliminar la solicitud de compra?",
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Si, eliminar!",
                                cancelButtonText: "No, cancelar!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    var url = APP_URL + '/solicitud-de-compras/'+id;
                                    axios.delete(url)
                                        .then(response => {
                                            var resp = response.data;
                                            if(!resp.error){
                                                toastr.success(resp.message);
                                                solicitud_comprasDT.draw(true);
                                            }else{
                                                toastr.warning('No se pudo eliminar el registro');
                                            }
                                        }).catch(e => {
                                        console.log(e);
                                        toastr.error('Ocurrio un error inesperado.');
                                    });
                                }
                            });

                        } else {
                            toastr.warning('Parametro incompleto para eliminar el registro');
                        }
                    }

                    $('#obra_id').on('select2:select', function (e) {
                        var data = e.params.data;
                        solicitud_comprasDT.columns(3).search(data.id).draw();
                    });

                    $('#ingeniero_id').on('select2:select', function (e) {
                        var data = e.params.data;
                        solicitud_comprasDT.columns(5).search(data.id).draw();
                    });

                    $('#fecha_solicitud').change(function (e) {
                        var fecha_solicitud = $('#fecha_solicitud').val();
                        solicitud_comprasDT.columns(6).search(fecha_solicitud).draw();
                    });

                    $('#fecha_entrega').change(function (e) {
                        var fecha_entrega = $('#fecha_entrega').val();
                        solicitud_comprasDT.columns(7).search(fecha_entrega).draw();
                    });

                    $('#estatus_id').on('select2:select', function (e) {
                        var data = e.params.data;
                        solicitud_comprasDT.columns(8).search(data.id).draw();
                    });

                    $(".js-programmatic-multi-clear").on("click", function () {
                        $('#obra_id').val(null).trigger('change');
                        $('#ingeniero_id').val(null).trigger('change');
                        $('#estatus_id').val(null).trigger('change');
                        $('#fecha_solicitud').val('');
                        $('#fecha_entrega').val('');
                        solicitud_comprasDT.columns([2,3,4,5,6]).search('').draw();
                    });

                    $('#solicitud-compras-datatable tbody').on('click', '.btn_enviar_correo', function (e){
                        e.preventDefault();
                        var clave = $(this).data('id');
                        var emails = $(this).data('emails');
                        $('#btn_enviar_correo-'+clave).attr("disabled", true);
                        if (emails !== '' && emails !== null){
                            enviarCorreoServer(clave);
                        } else {
                            toastr.warning('No se puede enviar el correo, agrega al menos uno.');
                            $('#btn_enviar_correo-'+clave).attr("disabled", false); //habilitar
                        }
                    });

                    //Btn Autorizado
                    $('#solicitud-compras-datatable tbody').on('click', '.btn_autorizado', function (e){
                        e.preventDefault();
                        var clave = $(this).data('id');
                        var data = {
                            id_solicitud: clave,
                        };
                        update_Estatus_Autorizado(data);
                    });

                    //Btn Finalizado
                    $('#solicitud-compras-datatable tbody').on('click', '.btn_finalizado', function (e){
                        e.preventDefault();
                        var clave = $(this).data('id');
                        var data = {
                            id_solicitud: clave,
                        };
                        cambiar_Estatus_Finalizado(data);
                    });

                    $('#btn_clonar_solicitud').off('click');
                    $("#btn_clonar_solicitud").on("click", function (){
                        $('#btn_clonar_solicitud').attr("disabled", true);
                        var selectDataRow = solicitud_comprasDT.rows('.selected').data();

                        if (selectDataRow.length > 0 && selectDataRow.length == 1){
                            selectDataRow = selectDataRow[0];

                            var href = APP_URL + '/solicitud-de-compras/' + selectDataRow.id +'/1';
                            //window.open(href, '_blank');
                            window.location.href = href;
                            $('#btn_clonar_solicitud').attr("disabled", false);
                        } else {
                            if(selectDataRow.length == 0){
                                toastr.warning('Debe seleccionar al menos una solicitud de compra para clonar.');
                                $('#btn_clonar_solicitud').attr("disabled", false);
                                return false;
                            }
                            if (selectDataRow.length > 1){
                                toastr.warning('Solo puede seleccionar una solicitud de compra para clonar.');
                                $('#btn_clonar_solicitud').attr("disabled", false);
                                return false;
                            }
                        }

                    });

                    $('#imprimir_excel').off('click');
                    $("#imprimir_excel").on("click", function (){
                        $('#imprimir_excel').attr("disabled", true);
                        var selectedRows = solicitud_comprasDT.rows('.selected').data().toArray();
                        if(selectedRows.length > 0 && selectedRows.length < 2) {
                            imprimir_excel(selectedRows);
                        } else {
                            toastr.warning('Solo puede seleccionar una solicitud de compra para imprimir.');
                            $('#imprimir_excel').attr("disabled", false);
                        }
                    });

                });//End-document-ready

                function enviarCorreoServer(clave){
                    if(clave !== null && clave !== ''){
                        var url_save = APP_URL + '/solicitud-de-compras-print-pdf/' + clave + '/1';
                        axios.get(url_save)
                            .then(response =>{
                                var resp = response.data;
                                if(!resp.error){
                                    toastr.success('Correo electrónico enviado con éxito.');
                                }else{
                                    toastr.warning('Ocurrio un error al enviar el correo, contacte al administrador del sistema.');
                                }
                                $('#btn_enviar_correo-'+clave).attr("disabled", false); //habilitar
                            }).catch(e => {
                            console.log(e);
                        });
                    } else {
                        toastr.warning('No se puede enviar el correo, faltan parámetros.');
                    }
                }

                function imprimir_pdf(data) {
                    if(data.length > 0){
                        var url_ = APP_URL + '/solicitud-de-compras-print-pdf-list-selected';
                        axios.post(url_, data)
                            .then(response => {
                                var resp = response.data;
                                if(!resp.error){
                                    toastr.success(resp.message);
                                    solicitud_comprasDT.draw(true);
                                    var href = APP_URL + '/' + resp.archivo_url;
                                    window.open(href, '_blank');
                                }else{
                                    toastr.warning(resp.message);
                                }
                                $('#pdf_imprimir_seleccionados').attr("disabled", false);
                            }).catch(e => {
                            console.log(e);
                            toastr.error('Ocurrio un error inesperado.');
                        });
                    } else {
                        toastr.warning('Debe seleccionar al menos una solicitud de compra.');
                        $('#pdf_imprimir_seleccionados').attr("disabled", false);
                    }
                }

                function update_Estatus_Autorizado(data){
                    if(data !== null && data !== false){
                        Swal.fire({
                            title: "¿Está seguro que desea Autorizar la solicitud de compra?",
                            text: "Si autoriza el usuario (Germán) podrá ver y editar el registro.",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#3085d6",
                            cancelButtonColor: "#d33",
                            confirmButtonText: "Si, Autorizar!",
                            cancelButtonText: "No, cancelar!",
                        }).then((result) => {
                            if (result.isConfirmed) {
                                var url_ = APP_URL + '/solicitud-de-compra-estatus-autorizado';
                                axios.post(url_, data)
                                    .then(response => {
                                        var resp = response.data;
                                        if(!resp.error){
                                            toastr.success(resp.message);
                                            var paginaActual = solicitud_comprasDT.page.info().page;
                                            solicitud_comprasDT.draw(true);
                                            solicitud_comprasDT.page(paginaActual).draw(false);
                                        }else{
                                            toastr.warning(resp.message);
                                        }
                                    }).catch(e => {
                                    toastr.error('Ocurrio un error inesperado.');
                                });
                            }
                        });
                    }else{
                        toastr.warning('No se pudo actualizar el estatus Autorizado, intente de nuevo, si el problema persiste comunicarse con el administrador de la aplicación.');
                    }
                }

                function cambiar_Estatus_Finalizado(data){
                    if(data !== null && data !== false){
                        Swal.fire({
                            title: "¿Está seguro que desea cambiar a Finalizado la solicitud de compra?",
                            text: "Si Finaliza ya no podrá ser usada en otra O.C.",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#3085d6",
                            cancelButtonColor: "#d33",
                            confirmButtonText: "Si, Finalizar!",
                            cancelButtonText: "No, cancelar!",
                        }).then((result) => {
                            if (result.isConfirmed) {
                                var url_ = APP_URL + '/solicitud-de-compra-estatus-finalizado';
                                axios.post(url_, data)
                                    .then(response => {
                                        var resp = response.data;
                                        if(!resp.error){
                                            toastr.success(resp.message);
                                            var paginaActual = solicitud_comprasDT.page.info().page;
                                            solicitud_comprasDT.draw(true);
                                            solicitud_comprasDT.page(paginaActual).draw(false);
                                        }else{
                                            toastr.warning(resp.message);
                                        }
                                    }).catch(e => {
                                    toastr.error('Ocurrio un error inesperado.');
                                });
                            }
                        });
                    }else{
                        toastr.warning('No se pudo actualizar el estatus Finalizado, intente de nuevo, si el problema persiste comunicarse con el administrador de la aplicación.');
                    }
                }

                function imprimir_excel(data) {
                    if(data.length > 0){
                        window.location.href = APP_URL + '/solicitud-de-compras-print-excel/'+ data[0].id;
                        $('#imprimir_excel').attr("disabled", false); //habilitar
                    } else {
                        toastr.warning('Debe seleccionar una solicitud de compra.');
                        $('#imprimir_excel').attr("disabled", false);
                    }
                }
            </script>

            @if (session()->has('success'))
                <script>
                    toastr.success("{{ session('success') }}");
                </script>
            @endif

            @if (session()->has('message'))
                <script>
                    toastr.error('Ocurrio un error inesperado.');
                </script>
            @endif
        @endpush
    </div>

</x-app-layout>
