<x-app-layout>
    <x-slot name="header">
        <h3 class="text-center">
            {{ __('Editar Solicitud de compra') }}
        </h3>
    </x-slot>

    @push('styles')
        <link rel="stylesheet" href="{{asset('plugins2/bootstrap-datepicker/css/bootstrap-datepicker.min.css')}}">
    @endpush

    <div class="bg-white overflow-hidden mt-4">

        @php
        $fecha_solicitud = '';
        $fecha_entrega = '';
        $solicitud_compra_id = 0;
        @endphp

        @if(!empty($solicitud_compra))
            @php
                $fecha_solicitud = $solicitud_compra->fecha_solicitud;
                $fecha_entrega = $solicitud_compra->fecha_entrega;
                $solicitud_compra_id = $solicitud_compra->id;
                $solicitud_compra_estatus_clave = $solicitud_compra->estatus->clave;
                $estatus_autorizado = $estatus_autorizado->clave;
                $estatus_finalizado = $estatus_finalizado->clave;
            @endphp
        {{-- Form --}}
        <div class="mt-4">
            <form id="form_solicitud_compra">
                <div class="shadow">

                    {{-- Datos generales--}}
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="obra_id" class="form-label">Obra <span class="_required_">*</span></label>
                                <select class="form-control save-required @error('obra_id') is-invalid @enderror" id="obra_id" name="obra_id" style="width: 100%;" tabindex="1" disabled>
                                    @if($solicitud_compra->obra)
                                        <option value="{{ $solicitud_compra->obra->id }}" selected="selected">{{ $solicitud_compra->obra->nombre }}</option>
                                    @endif
                                </select>
                                <x-jet-input-error for="obra_id" />
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="ingeniero_id" class="form-label">ING. <span class="_required_">*</span></label>
                                <select class="form-control save-required @error('ingeniero_id') is-invalid @enderror" id="ingeniero_id" name="ingeniero_id" style="width: 100%;" tabindex="2" disabled>
                                    @if($solicitud_compra->ingeniero)
                                        <option value="{{ $solicitud_compra->ingeniero->id }}" selected="selected">{{ $solicitud_compra->ingeniero->nombre }}</option>
                                    @endif
                                </select>
                                <x-jet-input-error for="ingeniero_id" />
                            </div>
                        </div>
                    </div>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="codigo" class="form-label">Código S.C.</label>
                                <input type="text" class="form-control @error('codigo') is-invalid @enderror" name="codigo" id="codigo" value="{{ $solicitud_compra->codigo }}" autocomplete="off" placeholder="Agregar código" tabindex="3" disabled>
                                <x-jet-input-error for="codigo" />
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="fecha_solicitud" class="form-label">Fecha de solicitud</label>
                                <div class="input-group date">
                                    <input type="text" class="form-control" name="fecha_solicitud" id="fecha_solicitud" autocomplete="off" placeholder="dd/mm/yyyy" tabindex="4" readonly disabled>
                                    <div class="input-group-addon">
                                        <i class="fa-regular fa-calendar-days"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="fecha_entrega" class="form-label">Fecha de entrega</label>
                                <div class="input-group date">
                                    <input type="text" class="form-control" name="fecha_entrega" id="fecha_entrega" autocomplete="off" placeholder="dd/mm/yyyy" tabindex="5" @if($solicitud_compra_estatus_clave === $estatus_finalizado) readonly disabled @endif>
                                    <div class="input-group-addon">
                                        <i class="fa-regular fa-calendar-days"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="observaciones" class="form-label">Comentarios adicionales</label>
                                <textarea class="form-control @error('observaciones') is-invalid @enderror" name="observaciones" id="observaciones" autocomplete="off" placeholder="Agregar Comentarios" tabindex="6" @if($solicitud_compra_estatus_clave === $estatus_finalizado) readonly disabled @endif>{{ $solicitud_compra->observaciones }}</textarea>
                            </div>
                        </div>
                    </div>
                    {{-- End-Datos generales--}}

                    {{-- Materiales--}}
                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Materiales</b></h5>
                            </div>
                        </div>

                        <div class="row mt-3">
                            @if($solicitud_compra_estatus_clave !== $estatus_finalizado)
                            <div class="col-6 col-sm-3 col-md-3 col-lg-2">
                                <p><button type="button" id="addRow" class="btn btn-primary text-white mb-2 me-1" title="Nuevo material" data-bs-toggle="modal" data-bs-target="#modalNewProducto"><i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Agregar material</button></p>
                            </div>
                            <div class="col-6 col-sm-3 col-md-3 col-lg-2">
                               <p><button type="button" id="btn-edit-row" class="btn btn-primary text-white mb-2 me-1" title="Editar material"><i class="fa-sharp fa-solid fa-pen-to-square"></i>&nbsp;Editar material</button></p>
                            </div>
                                @can('catalogo_de_productos_create')
                                <div class="col-6 col-sm-3 col-md-3 col-lg-2">
                                    <p><button type="button" id="btn_comentario_grupal" class="btn btn-primary text-white mb-2 me-1" title="Comentario grupal"><i class="fa-sharp fa-solid fa-plus"></i>&nbsp;Comentario grupal</button></p>
                                </div>
                                <div class="col-6 col-sm-3 col-md-3 col-lg-2">
                                    <p><button type="button" id="btn_edit_comentario_grupal" class="btn btn-primary text-white mb-2 me-1" title="Editar Comentario grupal"><i class="fa-sharp fa-solid fa-pen-to-square"></i>&nbsp;Editar Comentario grupal</button></p>
                                </div>
                                @endcan
                            @endif
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="productos-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                        <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Clave de registro</th>
                                            <th>Clave de Material</th>
                                            <th>Material</th>
                                            <th>Clave de Unidad</th>
                                            <th>Unidad</th>
                                            <th>Cantidad</th>
                                            <th>Área de uso</th>
                                            <th>Marca</th>
                                            <th>Modelo</th>
                                            <th>Observaciones</th>
                                            <th>Clave Comentario Grupal</th>
                                            <th>Comentario Grupal</th>
                                            <th>No. duplicado orden</th>
                                            @if($solicitud_compra_estatus_clave !== $estatus_finalizado)
                                            <th>Acciones</th>
                                            @endif
                                        </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- End-Materiales--}}

                    {{-- Emails --}}
                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Envio de correo</b></h5>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <label for="emails" class="form-label">Email</label>
                                <input type="text" class="form-control" name="emails" id="emails" value="{{ $solicitud_compra->emails }}" autocomplete="off" placeholder="Agregar Emails" tabindex="7">
                                <small>Ejemplo: demo@hotmail.com,demo2@gmail.com</small>
                            </div>
                            <div class="col-12">
                                <label for="email_asunto" class="form-label">Asunto</label>
                                <input type="text" class="form-control" name="email_asunto" id="email_asunto" value="{{ $solicitud_compra->email_asunto }}" autocomplete="off" placeholder="Agregar asunto" tabindex="8">
                            </div>
                            <div class="col-12">
                                <label for="email_contenido" class="form-label">Contenido</label>
                                <textarea class="form-control" name="email_contenido" id="email_contenido" placeholder="Agregar contenido" rows="3" tabindex="9">{{ $solicitud_compra->email_contenido }}</textarea>

                            </div>
                        </div>
                    </div>
                    {{-- End-Emails --}}

                    <hr>
                    <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                        <a href="{{ route('solicitud-de-compras.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Cancelar</a>
                        <button type="button" id="guardarSolicitudForm" class="btn btn-primary text-white" tabindex="10"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar</button>
                    </div>
                </div>
            </form>
        </div>
        {{-- End-Form --}}
        @else
            <div class="alert alert-warning" role="alert">
                <h5>La Solicitud de Compra no puede editarse porque ya no se encuentra en estatus pendiente.</h5>
            </div>
            <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                <a href="{{ route('solicitud-de-compras.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Regresar</a>
            </div>
        @endif

    </div>

    <!-- Modal -->
    <div class="modal fade" id="modalNewProducto" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Agregar Material</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="newFormModal">
                        <div class="px-4 py-1">
                            <div class="row">
                                <div class="col">
                                    <label for="producto_id" class="form-label">Material <span class="_required_">*</span></label>
                                    <div class="row">
                                        <div class="@can('catalogo_de_productos_create') col-10 @else col-12 @endcan">
                                            <select class="form-control save-required is-invalid" id="producto_id" name="producto_id" style="width: 100%;" tabindex="1"></select>
                                        </div>
                                        {{-- Ing no tiene permiso de crear material--}}
                                        @can('catalogo_de_productos_create')
                                        <div class="col-2">
                                            <button type="button" id="btn_crear_material" class="btn btn-primary text-white mb-2 me-1" title="Crear Material"><i class="fa-sharp fa-solid fa-plus"></i></button>
                                        </div>
                                        @endcan
                                    </div>
                                </div>
                                <div class="col">
                                    <label for="unidad_id" class="form-label">Unidad <span class="_required_">*</span></label>
                                    <select class="form-control save-required" id="unidad_id" name="unidad_id" style="width: 100%;" tabindex="2"></select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="cantidad" class="form-label">Cantidad <span class="_required_">*</span></label>
                                    <input type="text" class="form-control precio_decimal save-required" name="cantidad" id="cantidad" autocomplete="off" placeholder="Agregar Cantidad" tabindex="3">
                                </div>
                                <div class="col">
                                    <label for="area_de_uso" class="form-label">Área de uso</label>
                                    <input type="text" class="form-control" name="area_de_uso" id="area_de_uso" autocomplete="off" placeholder="Agregar área de uso" tabindex="4">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="marca" class="form-label">Marca</label>
                                    <input type="text" class="form-control" name="marca" id="marca" autocomplete="off" placeholder="Agregar marca" tabindex="5">
                                </div>
                                <div class="col">
                                    <label for="modelo" class="form-label">Modelo</label>
                                    <input type="text" class="form-control" name="modelo" id="modelo" autocomplete="off" placeholder="Agregar modelo" tabindex="6">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="observaciones_prod" class="form-label">Observaciones</label>
                                    <input type="text" class="form-control" name="observaciones_prod" id="observaciones_prod" autocomplete="off" placeholder="Agregar observaciones" tabindex="7">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i>&nbsp;Cerrar</button>
                    <button type="button" id="saveProductoNew" class="btn btn-primary text-white" tabindex="7"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Agregar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Fin-Modal -->

    <!-- Modal Materiales -->
    <div class="modal fade" id="modalEditProducto" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabelEdit" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="staticBackdropLabelEdit">Editar Material</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="newFormModal">
                        <div class="px-4 py-1">
                            <div class="row">
                                <input type="hidden" class="form-control" name="id_edit_material" id="id_edit_material" tabindex="3">

                                <div class="col">
                                    <label for="producto_nombre" class="form-label">Material <span class="_required_">*</span></label>
                                    <div class="row" id="row_material_activo">
                                        <div class="col-10">
                                            <input type="text" class="form-control" name="producto_nombre" id="producto_nombre" tabindex="3" disabled="disabled">
                                            <input type="hidden" class="form-control" name="producto_id" id="producto_id">
                                        </div>
                                        <div class="col-2">
                                            <button type="button" id="btn_cambiar_material" class="btn btn-primary text-white mb-2 me-1" title="Editar material"><i class="fa-sharp fa-solid fa-pen-to-square"></i></button>
                                        </div>
                                    </div>
                                    <div class="row d-none" id="row_select_editar_material">
                                        <div class="col-12">
                                            <select class="form-control is-invalid" id="producto_id_select_edit" name="producto_id_select_edit" style="width: 100%;" tabindex="1"></select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <label for="unidad_nombre" class="form-label">Unidad <span class="_required_">*</span></label>
                                    <div class="row" id="row_unidad_activa">
                                        <div class="col-10">
                                            <input type="text" class="form-control" name="unidad_nombre" id="unidad_nombre" tabindex="3" disabled="disabled">
                                            <input type="hidden" class="form-control" name="unidad_id" id="unidad_id">
                                        </div>
                                        <div class="col-2">
                                            <button type="button" id="btn_cambiar_unidad" class="btn btn-primary text-white mb-2 me-1" title="Editar unidad"><i class="fa-sharp fa-solid fa-pen-to-square"></i></button>
                                        </div>
                                    </div>
                                    <div class="row d-none" id="row_select_editar_unidad">
                                        <div class="col-12">
                                            <select class="form-control is-invalid" id="unidad_id_select_edit" name="unidad_id_select_edit" style="width: 100%;" tabindex="1"></select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="cantidad" class="form-label">Cantidad <span class="_required_">*</span></label>
                                    <input type="text" class="form-control precio_decimal save-required" name="cantidad" id="cantidad" autocomplete="off" placeholder="Agregar Cantidad" tabindex="3">
                                </div>
                                <div class="col">
                                    <label for="area_de_uso" class="form-label">Área de uso</label>
                                    <input type="text" class="form-control" name="area_de_uso" id="area_de_uso" autocomplete="off" placeholder="Agregar área de uso" tabindex="4">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="marca" class="form-label">Marca</label>
                                    <input type="text" class="form-control" name="marca" id="marca" autocomplete="off" placeholder="Agregar marca" tabindex="5">
                                </div>
                                <div class="col">
                                    <label for="modelo" class="form-label">Modelo</label>
                                    <input type="text" class="form-control" name="modelo" id="modelo" autocomplete="off" placeholder="Agregar modelo" tabindex="6">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="observaciones_prod" class="form-label">Observaciones</label>
                                    <input type="text" class="form-control" name="observaciones_prod" id="observaciones_prod" autocomplete="off" placeholder="Agregar observaciones" tabindex="7">
                                </div>
                            </div>
                            <div class="row d-none">
                                <div class="col">
                                    <label for="comentario_material_clave_aux" class="form-label">Clave Comentario Material</label>
                                    <input type="text" class="form-control" name="comentario_material_clave_aux" id="comentario_material_clave_aux">
                                </div>
                                <div class="col">
                                    <label for="comentario_material_aux" class="form-label">Comentario Material</label>
                                    <input type="text" class="form-control" name="comentario_material_aux" id="comentario_material_aux">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i>&nbsp;Cerrar</button>
                    <button type="button" id="editProductoNew" class="btn btn-primary text-white" tabindex="8"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Actualizar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Fin-Modal Materiales -->

    <!-- Modal Comentario Grupal-->
    <div class="modal fade" id="modalNewComentarioGrupal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticModalComentarioGrupal" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5">Agregar Comentario grupal</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="newFormModalComentario">
                        <div class="px-4 py-1">
                            <div class="row">
                                <div class="col">
                                    <label for="material_multi_select" class="form-label">Material <span class="_required_">*</span></label>
                                    <select class="form-control save-required is-invalid" id="material_multi_select" name="material_multi_select" style="width: 100%;" tabindex="1"></select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="comentario_grupal" class="form-label">Comentario <span class="_required_">*</span></label>
                                    <textarea class="form-control save-required" name="comentario_grupal" id="comentario_grupal" placeholder="Agregar comentario grupal" rows="4" tabindex="2"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i>&nbsp;Cerrar</button>
                    <button type="button" id="saveNewComentarioGrupal" class="btn btn-primary text-white" tabindex="7"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Fin-Modal-Comentario-Grupal -->

    <!-- Modal Edita | Comentario Grupal-->
    <div class="modal fade" id="modalEditComentarioGrupal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticModalComentarioGrupalEdit" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5">Editar Comentario grupal</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="FormModalComentarioGrupalEdit">
                        <div class="px-4 py-1">
                            <div class="row">
                                <div class="col">
                                    <label for="material_multi_select_edit" class="form-label">Material <span class="_required_">*</span></label>
                                    <input type="hidden" id="comentario_material_clave_edit" name="comentario_material_clave_edit">
                                    <div class="row" id="row_materiales_activos">
                                        <div class="col-10">
                                            <select class="form-control save-required is-invalid" id="material_multi_select_edit" name="material_multi_select_edit" style="width: 100%;" tabindex="1"></select>
                                        </div>
                                        <div class="col-2">
                                            <button type="button" id="btn_agregar_material" class="btn btn-primary text-white mb-2 me-1" title="Agregar material"><i class="fa-sharp fa-solid fa-plus"></i></button>
                                        </div>
                                    </div>
                                    <div class="row d-none" id="row_select_new_material_a_comentario">
                                        <div class="col-12">
                                            <label for="material_multi_select_edit" class="form-label">Agregar Material para el comentario</label>
                                        </div>
                                        <div class="col-12">
                                            <select class="form-control is-invalid" id="material_multi_select_new_edit" name="material_multi_select_new_edit" style="width: 100%;" tabindex="1"></select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="comentario_grupal_edit" class="form-label">Comentario <span class="_required_">*</span></label>
                                    <textarea class="form-control save-required" name="comentario_grupal_edit" id="comentario_grupal_edit" placeholder="Agregar comentario grupal" rows="4" tabindex="2"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i>&nbsp;Cerrar</button>
                    <button type="button" id="updateComentarioGrupal" class="btn btn-primary text-white" tabindex="7"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Fin-Modal-Edita-Comentario-Grupal -->

    <!-- Modal-Crear-Material -->
    <div class="modal fade" id="crearMaterialModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Crear Material</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div id="crearMaterial_Form_Modal" class="modal-body">
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <label for="crear_material_nombre" class="form-label">Nombre <span class="_required_">*</span></label>
                                <textarea class="form-control save-required" name="crear_material_nombre" id="crear_material_nombre" placeholder="Agregar nombre" rows="3" tabindex="1"></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="crear_material_descripcion" class="form-label">Descripción</label>
                                <textarea class="form-control" name="crear_material_descripcion" id="crear_material_descripcion" placeholder="Agregar descripción" rows="3" tabindex="2"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i>&nbsp;Cerrar</button>
                    <button type="button" id="bntCrearMaterial" class="btn btn-primary text-white"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Fin-Modal-Crear-Material -->

    @push('scripts')
        <script src="{{ asset('plugins/inputmask/jquery.inputmask.min.js') }}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/locales/bootstrap-datepicker.es.min.js')}}"></script>
        <script src="{{asset('js/admin.js')}}"></script>
        <script type="text/javascript">
            var APP_URL = {!! json_encode(url('/')) !!};
            var solicitud_compra_id = @json($solicitud_compra_id);
            var productosDT = null;
            var solicitud_compra_estatus_clave = '{{ $solicitud_compra_estatus_clave }}';
            var estatus_autorizado = @json($estatus_autorizado);
            var estatus_finalizado = @json($estatus_finalizado);

            $(document).ready(function($){
                 productosDT = new DataTable('#productos-datatable', {
                    "dom": '<"top"f><"datatable-scroll"rt><"bottom"ip><"clear">',
                    pageLength: 10,
                    responsive: true,
                    scrollX: false,
                    "language": {
                        "url": APP_URL + "/plugins/DataTables/language.MX.json"
                    },
                    columnDefs: [{ visible: false, targets: [1,2,4,11,13] }],
                    createdRow: function(row, data, dataIndex) {
                        $(row).attr('id', data[1]);
                        $(row).attr('rowIndex', dataIndex);
                        if (solicitud_compra_estatus_clave !== estatus_finalizado){
                            var botones = '<button id="btn-eliminar-'+ data[1] +'" data-id="' + data[1] + '" class="btn_delete_registro btn btn-danger text-white mb-2 me-1" title="Eliminar"><i class="fa-sharp fa-solid fa-trash-can"></i>&nbsp;Eliminar</button>';
                            $('td:eq(-1)', row).html(botones);
                        }
                    },
                });
                let counter = 1;

                //clear row selected
                productosDT.on('click', 'tbody tr', (e) => {
                    let classList = e.currentTarget.classList;

                    if (classList.contains('selected')) {
                        classList.remove('selected');
                    }
                    else {
                        productosDT.rows('.selected').nodes().each((row) => row.classList.remove('selected'));
                        classList.add('selected');
                    }
                });

                $('#obra_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    minimumResultsForSearch: -1,
                    cache: false
                });

                $('#ingeniero_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    minimumResultsForSearch: -1,
                    cache: false
                });

                $('#fecha_solicitud').datepicker({
                    language: 'es',
                    autoclose: true,
                    format: "dd/mm/yyyy",
                    todayHighlight: true,
                    //startDate: new Date()
                });
                var fSolicitud = moment('{{ $fecha_solicitud }}').format("DD-MM-YYYY");
                $('#fecha_solicitud').datepicker( 'setDate', fSolicitud );

                $('#fecha_entrega').datepicker({
                    language: 'es',
                    autoclose: true,
                    format: "dd/mm/yyyy",
                    todayHighlight: true,
                    //startDate: new Date()
                });

                let fFechaEntrega = '{{ $fecha_entrega }}';
                if(fFechaEntrega){
                    var fEntrega = moment('{{ $fecha_entrega }}').format("DD-MM-YYYY");
                    $('#fecha_entrega').datepicker( 'setDate', fEntrega );
                }

                $('#producto_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    ajax: {
                        dataType: 'json',
                        url: "/get-lista-productos-select",
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term
                            }
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                        }
                    },
                    cache: true,
                    dropdownParent: $('#modalNewProducto .modal-content')
                });

                $('#unidad_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    ajax: {
                        dataType: 'json',
                        url: "/get-lista-unidades-select",
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term
                            }
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                        }
                    },
                    cache: true,
                    dropdownParent: $('#modalNewProducto .modal-content')
                });

                // $('#cantidad').inputmask({
                //     alias: 'numeric',
                //     allowMinus: false,
                //     digits: 0,
                // });

                $("#cantidad").inputmask({
                    alias: 'decimal',
                    allowMinus: false,
                    digits: 2,
                    rightAlign: true,
                });

                const myModalEl = document.getElementById('modalNewProducto');
                myModalEl.addEventListener('hidden.bs.modal', event => {
                    $('#producto_id').val(null).change();
                    $('#unidad_id').val(null).change();
                    $("#cantidad").val("");
                    $("#area_de_uso").val("");
                    $("#marca").val("");
                    $("#modelo").val("");
                    $("#area_de_uso").val("");
                    $("#observaciones_prod").val("");
                });

                $('#saveProductoNew').off('click');
                $('#saveProductoNew').on('click', function (){
                    var idform = '#modalNewProducto #newFormModal';
                    if(validateForm(idform)){

                        var url_prod = APP_URL + '/get-producto-unidad-xclave/'+$('#producto_id').val() +'/'+$('#unidad_id').val();
                        axios.get(url_prod)
                            .then(response => {
                                var resp = response.data;
                                if(!resp.error){

                                    var data = {
                                        producto_id: $('#producto_id').val(),
                                        producto_nombre: resp.producto.nombre,
                                        unidad_id: $('#unidad_id').val(),
                                        unidad_nombre: resp.unidad.nombre,
                                        cantidad: $('#cantidad').val(),
                                        area_de_uso: $('#area_de_uso').val(),
                                        marca: $('#marca').val(),
                                        modelo: $('#modelo').val(),
                                        observaciones_prod: $('#observaciones_prod').val(),
                                        num_duplicado_order: 0,
                                    };

                                    var materialesRows = productosDT.rows().data().toArray();
                                    if(materialesRows.length > 0){
                                        let duplicado = encontrarDuplicadosPorIdMaterial(materialesRows, data);
                                        if (Object.keys(duplicado).length > 0){
                                            addNewRow(duplicado, 1);
                                        } else {
                                            addNewRow(data, 1);
                                        }
                                    } else {
                                        addNewRow(data, 1);
                                    }

                                    $("#modalNewProducto").modal('hide');

                                }else{
                                    toastr.warning('No se pudo obtener el material.');
                                }
                            }).catch(e => {
                            console.log(e);
                            toastr.error('Ocurrio un error inesperado.');
                        });
                    }
                });

                function addNewRow(data, type = 1) {
                    if (type == 1) { //new
                        productosDT.row
                            .add([
                                counter,
                                '',
                                data.producto_id,
                                data.producto_nombre,
                                data.unidad_id,
                                data.unidad_nombre,
                                data.cantidad,
                                data.area_de_uso,
                                data.marca,
                                data.modelo,
                                data.observaciones_prod,
                                '', //Clave Comentario Grupal
                                '', //Comentario Grupal
                                data.num_duplicado_order, //No. duplicado orden
                                '', //Acciones
                            ])
                            .draw(false);
                    } else if(type == 2){
                        var comentarios_material = (data.rel_solicitud_producto_comentario_material) ? data.rel_solicitud_producto_comentario_material.comentarios_material.comentario : "";
                        var comentarios_material_clave = (data.rel_solicitud_producto_comentario_material) ? data.rel_solicitud_producto_comentario_material.comentarios_material.id : "";
                        productosDT.row
                            .add([
                                counter,
                                data.id,
                                data.producto_id,
                                data.producto.nombre,
                                data.unidad_id,
                                data.unidad.nombre,
                                data.cantidad,
                                data.area_de_uso,
                                data.marca,
                                data.modelo,
                                data.observaciones,
                                comentarios_material_clave,
                                comentarios_material,
                                data.num_duplicado_order, //No. duplicado orden
                                '', //Acciones
                            ])
                            .draw(false);
                    }
                    counter++;
                }

                function editMaterialRow(data) {
                    const row = productosDT.rows().indexes().filter(function (index) {
                        return productosDT.row(index).data()[1] == data.id_edit_material;
                    });

                    const currentRowData = productosDT.row(row[0]).data();
                    const accionesHTML = $(productosDT.row(row[0]).node()).find('td:last-child').html();

                    if (row.length > 0) {
                        productosDT.row(row[0]).data([
                            productosDT.row(row[0]).data()[0],
                            data.id_edit_material || '',
                            data.producto_id,
                            data.producto_nombre,
                            data.unidad_id,
                            data.unidad_nombre,
                            data.cantidad,
                            data.area_de_uso,
                            data.marca,
                            data.modelo,
                            data.observaciones_prod,
                            data.comentario_material_clave_aux,
                            data.comentario_material_aux,
                            data.num_duplicado_order,
                            '', //Acciones
                        ]).draw(false);

                        // Reinsertar el HTML en la columna de acciones
                        $(productosDT.row(row[0]).node()).find('td:last-child').html(accionesHTML);
                    } else {
                        console.error("No se encontró la fila para actualizar.");
                    }
                }

                //Lista de Productos guardados
                let data_solicitud = @json($solicitud_compra);
                if(data_solicitud != null && data_solicitud != ''){
                    let data_solicitud_compra_producto = data_solicitud.solicitud_compra_producto;
                    $.each(data_solicitud_compra_producto, function (index, val){
                        addNewRow(val, 2);
                    });
                }

                //Editar Material
                $('#btn-edit-row').off('click');
                $('#btn-edit-row').on('click', function () {
                    let selectRow = productosDT.rows('.selected').nodes().length;

                    if (selectRow > 0) {
                        $('#modalEditProducto .modal-footer').hide();
                        let selectDataRow = productosDT.rows('.selected').data();
                        selectDataRow = selectDataRow[0];

                        let id_edit_material = selectDataRow[1]; //clave del registro
                        let producto_id = selectDataRow[2]; //clave del material
                        let unidad_id = selectDataRow[4]; //clave de unidad
                        let cantidad = selectDataRow[6];
                        let area_uso = selectDataRow[7];
                        let marca = selectDataRow[8];
                        let modelo = selectDataRow[9];
                        let observaciones = selectDataRow[10];
                        let comentario_material_clave = selectDataRow[11];
                        let comentario_material = selectDataRow[12];

                        var url_prod = APP_URL + '/get-producto-unidad-xclave/' + producto_id + '/' + unidad_id;
                        $('#modalEditProducto').modal('show');
                        $('#modalEditProducto #staticBackdropLabelEdit').text('Cargando Material...');

                        axios.get(url_prod)
                            .then(response => {
                                var resp = response.data;
                                if (!resp.error) {

                                    producto_nombre = resp.producto.nombre;
                                    unidad_nombre = resp.unidad.nombre;

                                    $('#modalEditProducto #id_edit_material').val(id_edit_material);
                                    $('#modalEditProducto #producto_id').val(producto_id);
                                    $('#modalEditProducto #producto_nombre').val(producto_nombre);
                                    $('#modalEditProducto #unidad_nombre').val(unidad_nombre);
                                    $('#modalEditProducto #unidad_id').val(unidad_id);
                                    $('#modalEditProducto #cantidad').val(cantidad);
                                    $('#modalEditProducto #area_de_uso').val(area_uso);
                                    $('#modalEditProducto #marca').val(marca);
                                    $('#modalEditProducto #modelo').val(modelo);
                                    $('#modalEditProducto #observaciones_prod').val(observaciones);
                                    $('#modalEditProducto #comentario_material_clave_aux').val(comentario_material_clave);
                                    $('#modalEditProducto #comentario_material_aux').val(comentario_material);

                                    $('#editProductoNew').attr("disabled", false);
                                    $('#modalEditProducto #staticBackdropLabelEdit').text('Editar Material');
                                } else {
                                    toastr.warning('No se pudo obtener el material.');
                                    $('#modalEditProducto').modal('hide');
                                    $('#editProductoNew').attr("disabled", false);
                                }
                            }).catch(e => {
                                console.log(e);
                                toastr.error('Ocurrio un error inesperado.');
                                $('#modalEditProducto').modal('hide');
                                $('#editProductoNew').attr("disabled", false);
                            }).finally(function() {
                                $('#modalEditProducto .modal-footer').show('fast');
                            });
                    } else {
                        toastr.warning('Debe seleccionar un material para editarlo.');
                    }
                });

                //select para editar Material
                $('#producto_id_select_edit').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    ajax: {
                        dataType: 'json',
                        url: "/get-lista-productos-select",
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term
                            }
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                            console.log("¡Hola, mundo select!");
                        }
                    },
                    cache: true,
                    dropdownParent: $('#modalEditProducto .modal-content')
                });

                $('#producto_id_select_edit').on('select2:select', function (e) {
                    var data = e.params.data;
                    $('#modalEditProducto #producto_id').val(data.id);
                    $('#modalEditProducto #producto_nombre').val(data.text);
                    $('#row_select_editar_material').addClass('d-none');
                    $('#row_material_activo').removeClass('d-none');
                });

                $('#btn_cambiar_material').off('click');
                $("#btn_cambiar_material").on("click", function () {
                    $('#row_select_editar_material').removeClass('d-none');
                    $('#row_material_activo').addClass('d-none');
                });

                //select para editar unidad
                $('#unidad_id_select_edit').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    ajax: {
                        dataType: 'json',
                        url: "/get-lista-unidades-select",
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term
                            }
                        },
                        processResults: function (data, page) {
                            return {
                                results: data
                            };
                        }
                    },
                    cache: true,
                    dropdownParent: $('#modalEditProducto .modal-content')
                });

                $('#unidad_id_select_edit').on('select2:select', function (e) {
                    var data = e.params.data;
                    $('#modalEditProducto #unidad_id').val(data.id);
                    $('#modalEditProducto #unidad_nombre').val(data.text);
                    $('#row_select_editar_unidad').addClass('d-none');
                    $('#row_unidad_activa').removeClass('d-none');
                });

                $('#btn_cambiar_unidad').off('click');
                $("#btn_cambiar_unidad").on("click", function () {
                    $('#row_select_editar_unidad').removeClass('d-none');
                    $('#row_unidad_activa').addClass('d-none');
                });

                $('#editProductoNew').off('click');
                $('#editProductoNew').on('click', function () {
                    var data = {
                        id_edit_material: $('#modalEditProducto #id_edit_material').val(),
                        solicitud_compra_id: $('#modalEditProducto #solicitud_compra_id').val(),
                        producto_id: $('#modalEditProducto #producto_id').val(),
                        producto_nombre: $('#modalEditProducto #producto_nombre').val(),
                        unidad_id: $('#modalEditProducto #unidad_id').val(),
                        unidad_nombre: $('#modalEditProducto #unidad_nombre').val(),
                        cantidad: $('#modalEditProducto #cantidad').val(),
                        area_de_uso: $('#modalEditProducto #area_de_uso').val(),
                        marca: $('#modalEditProducto #marca').val(),
                        modelo: $('#modalEditProducto #modelo').val(),
                        observaciones_prod: $('#modalEditProducto #observaciones_prod').val(),
                        comentario_material_clave_aux: $('#modalEditProducto #comentario_material_clave_aux').val(),
                        comentario_material_aux: $('#modalEditProducto #comentario_material_aux').val(),
                        num_duplicado_order: 0,
                    };

                    var materialesRows = productosDT.rows().data().toArray();
                    if(materialesRows.length > 0){
                        let duplicado = encontrarDuplicadosPorIdMaterial(materialesRows, data);
                        if (Object.keys(duplicado).length > 0){
                            editMaterialRow(duplicado);
                        } else {
                            editMaterialRow(data);
                        }
                    } else {
                        editMaterialRow(data);
                    }

                    $('#modalEditProducto').modal('hide');
                });

                // $('#btn-delete-row').off('click');
                // $('#btn-delete-row').on('click', function (){
                //     let selectRow = productosDT.rows('.selected').nodes().length;
                //     if (selectRow > 0) {
                //         Swal.fire({
                //             title: "¿Está seguro que desea eliminar el Material?",
                //             icon: "warning",
                //             showCancelButton: true,
                //             confirmButtonColor: "#3085d6",
                //             cancelButtonColor: "#d33",
                //             confirmButtonText: "Si, eliminar!",
                //             cancelButtonText: "No, cancelar!",
                //         }).then((result) => {
                //             if (result.isConfirmed) {
                //                 productosDT.row('.selected').remove().draw(false);
                //             }
                //         });
                //     } else {
                //         toastr.warning('Debe seleccionar un material para eliminarlo.');
                //     }
                // });

                /**
                 * Guardar Solicitud de compras - Update datos
                 */
                $('#guardarSolicitudForm').off('click');
                $('#guardarSolicitudForm').on('click', function (){
                    var id_form_sol = '#form_solicitud_compra';
                    if(validateForm(id_form_sol)){

                        var materialesRows = productosDT.rows().data().toArray();
                        if(materialesRows.length === 0){
                            toastr.warning('Debe agregar almenos un material.');
                        }else{
                            $('#guardarSolicitudForm').attr("disabled", true);
                            var data = {
                                obra_id: $('#obra_id').val(),
                                ingeniero_id: $('#ingeniero_id').val(),
                                fecha_entrega: $('#fecha_entrega').val(),
                                observaciones: $('#observaciones').val(),
                                productos_data: materialesRows,
                                emails: $('#emails').val(),
                                email_asunto: $('#email_asunto').val(),
                                email_contenido: $('#email_contenido').val(),
                            };
                            updateSolicitudCompra(data);
                        }
                    }
                });

                $('#productos-datatable tbody').off('click', '.btn_delete_registro');
                $('#productos-datatable tbody').on('click', '.btn_delete_registro', function (e){
                    e.preventDefault();
                    var id_reg = $(this).data('id');
                    var row = $(this).parents('tr');
                    Swal.fire({
                        title: "¿Está seguro que desea eliminar el Material?",
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#3085d6",
                        cancelButtonColor: "#d33",
                        confirmButtonText: "Si, eliminar!",
                        cancelButtonText: "No, cancelar!",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            eliminarMaterial_db(id_reg, row);
                        }
                    });
                });

                //Modal Editar Material
                $('#modalEditProducto').one('show.bs.modal', function (e) {
                    //$('#modalEditProducto #cantidad').attr("disabled", true);
                }).on('hidden.bs.modal', function(e){
                    document.activeElement.blur();
                    $('#modalEditProducto #id_edit_material').val('');
                    $('#modalEditProducto #producto_nombre').val('');
                    $('#modalEditProducto #unidad_nombre').val('');
                    $('#modalEditProducto #cantidad').val('');
                    $('#modalEditProducto #area_de_uso').val('');
                    $('#modalEditProducto #marca').val('');
                    $('#modalEditProducto #modelo').val('');
                    $('#modalEditProducto #observaciones_prod').val('');
                    $(':focus').blur();
                });


                //boton agregar Comentario Grupal
                $('#btn_comentario_grupal').off('click');
                $('#btn_comentario_grupal').on('click', function (){
                    $('#modalNewComentarioGrupal').modal('show');
                });

                //Open Modal Comentario Grupal
                $('#modalNewComentarioGrupal').one('show.bs.modal', function (e) {
                    var url_materiales_solicitud = APP_URL + '/get-lista-materiales-by-solicitud-select/' + {{ $solicitud_compra_id }};

                    $('#material_multi_select').select2({
                        width: '100%',
                        theme: "bootstrap",
                        multiple: true,
                        placeholder: {
                            id: '-1',
                            text: "Seleccione uno o más",
                            width: '100%'
                        },
                        ajax: {
                            dataType: 'json',
                            url: url_materiales_solicitud,
                            delay: 250,
                            data: function (params) {
                                return {
                                    search: params.term,
                                    //type: 'disponibles'
                                }
                            },
                            processResults: function (data, page) {
                                return {
                                    results: data
                                };
                            }
                        },
                        cache: false,
                        dropdownParent: $('#modalNewComentarioGrupal .modal-content'),
                        allowClear: true
                    });
                }).on('hidden.bs.modal', function(e){
                    //limpia campos form
                    $('#material_multi_select').val(null).trigger('change');
                    $('#comentario_grupal').val('');
                });

                //save Comentario Grupal
                $('#saveNewComentarioGrupal').off('click');
                $('#saveNewComentarioGrupal').on('click', function (){
                    var idform = '#modalNewComentarioGrupal #newFormModalComentario';
                    //if(validateForm(idform)){
                        var data = {
                            solicitud_compra_id: solicitud_compra_id,
                            clave_solicitud_compra_producto: $('#material_multi_select').val(),
                            comentario: $('#comentario_grupal').val(),
                        }

                        createComentarioMaterial(data);
                    //}
                });

                //boton Editar Comentario Grupal
                $('#btn_edit_comentario_grupal').off('click');
                $('#btn_edit_comentario_grupal').on('click', function (){
                    let selectRow = productosDT.rows('.selected').nodes().length;
                    if (selectRow > 0) {
                        var selectDataRow = productosDT.rows('.selected').data();
                        selectDataRow = selectDataRow[0];
                        var id_comentario_material = selectDataRow[11]; //clave del registro
                        if (id_comentario_material !== null && id_comentario_material !== '')  {
                            $('#modalEditComentarioGrupal').modal('show');

                            var url_prod = APP_URL + '/get-comentario-grupal-xclave/' + id_comentario_material;
                            axios.get(url_prod)
                                .then(response => {
                                    var resp = response.data;
                                    if (!resp.error) {
                                        let comentario = resp.comentario_material.comentario;

                                        $('#modalEditComentarioGrupal #comentario_material_clave_edit').val(id_comentario_material);
                                        $('#modalEditComentarioGrupal #comentario_grupal_edit').val(comentario);

                                    } else {
                                        toastr.warning('No se pudo obtener el comentario del material.');
                                        $('#modalEditComentarioGrupal').modal('hide');
                                    }
                                }).catch(e => {
                                toastr.error('Ocurrio un error inesperado.');
                            });

                            //Select Materiales con comentario grupal
                            var materialesSelect = $('#material_multi_select_edit');
                            materialesSelect.select2({
                                width: '100%',
                                theme: "bootstrap",
                                multiple: true,
                                placeholder: {
                                    id: '-1',
                                    text: "Seleccione uno o más",
                                    width: '100%'
                                },
                                cache: false,
                                dropdownParent: $('#modalEditComentarioGrupal .modal-content'),
                                allowClear: true
                            });

                            //pre-seleccion
                            $.ajax({
                                type: 'GET',
                                url: url_prod
                            }).then(function (data) {
                                $.each(data.materiales, function (index, value) {
                                    var option = new Option(value.solicitud_compra_producto.producto.nombre, value.id, true, true);
                                    materialesSelect.append(option).trigger('change');
                                });

                                materialesSelect.trigger({
                                    type: 'select2:select',
                                    params: {
                                        data: data
                                    }
                                });
                            });

                            //obtener todos los materiales de la solicitud
                            var url_materiales_solicitud = APP_URL + '/get-lista-materiales-by-solicitud-select/' + {{ $solicitud_compra_id }};
                            $('#material_multi_select_new_edit').select2({
                                width: '100%',
                                theme: "bootstrap",
                                multiple: true,
                                placeholder: {
                                    id: '-1',
                                    text: "Seleccione uno o más",
                                },
                                ajax: {
                                    dataType: 'json',
                                    url: url_materiales_solicitud,
                                    delay: 250,
                                    data: function (params) {
                                        return {
                                            search: params.term,
                                            //type: 'all',
                                        }
                                    },
                                    processResults: function (data, page) {
                                        return {
                                            results: data
                                        };
                                    }
                                },
                                cache: false,
                                dropdownParent: $('#modalEditComentarioGrupal .modal-content'),
                                allowClear: true
                            });

                        } else {
                            $('#modalEditComentarioGrupal').modal('hide');
                            toastr.warning('Para poder editar debe tener al menos un comentario.');
                        }
                    } else {
                        toastr.warning('Debe seleccionar un material para editar el comentario grupal.');
                    }
                });

                //Open Modal Editar Comentario Grupal
                $('#modalEditComentarioGrupal').one('show.bs.modal', function (e){
                    //
                }).on('hidden.bs.modal', function(e){
                    //limpia campos form
                    $('#comentario_material_clave_edit').val('');
                    $('#material_multi_select_edit').val(null).trigger('change');
                    $('#row_select_new_material_a_comentario').addClass('d-none');
                    $('#material_multi_select_new_edit').val(null).trigger('change');
                    $('#comentario_grupal_edit').val('');
                });

                //btn Agregar Material nuevo a comentario
                $('#btn_agregar_material').off('click');
                $("#btn_agregar_material").on("click", function () {
                    $('#row_select_new_material_a_comentario').removeClass('d-none');
                });

                //Actualiza Materiales y comentario Grupal
                $('#updateComentarioGrupal').off('click');
                $('#updateComentarioGrupal').on('click', function (){
                    var idform = '#modalEditComentarioGrupal #FormModalComentarioGrupalEdit';
                    //if(validateForm(idform)){
                    var data = {
                        solicitud_compra_id: solicitud_compra_id,
                        comentario_material_clave_edit: $('#comentario_material_clave_edit').val(),
                        claves_solicitud_compra_producto_edit: $('#material_multi_select_edit').val(),
                        claves_nuevas_materiales_solicitud: $('#material_multi_select_new_edit').val(),
                        comentario_edit: $('#comentario_grupal_edit').val(),
                    }

                    updateComentarioGrupalMaterial(data);
                    //}
                });

                //===== Crear Material =====
                $("#btn_crear_material").off('click');
                $("#btn_crear_material").on("click", function (){
                    $('#crearMaterialModal').modal('show');
                });

                $("#bntCrearMaterial").off('click');
                $("#bntCrearMaterial").on("click", function (){
                    $('#bntCrearMaterial').attr("disabled", true); //Disabled
                    var idform = '#crearMaterialModal #crearMaterial_Form_Modal';
                    if (validateForm(idform)) {
                        var data = {
                            nombre: $('#crear_material_nombre').val(),
                            descripcion: $('#crear_material_descripcion').val()
                        };

                        var url_save = APP_URL + '/catalogo-de-productos.crear-material';
                        axios.post(url_save, data)
                            .then(response => {
                                var resp = response.data;
                                if(!resp.error) {
                                    toastr.success(resp.message);
                                    var new_material = resp.data; //Producto

                                    // create the option and append to Select2
                                    var option = new Option(new_material.nombre, new_material.id, true, true);
                                    $('#producto_id').append(option).trigger('change');

                                    $('#crearMaterialModal').modal('hide');
                                    //limpia form
                                    $('#crear_material_nombre').val('');
                                    $('#crear_material_descripcion').val('');
                                    $('#bntCrearMaterial').attr("disabled", false); //habilitar
                                } else {
                                    toastr.warning(resp.message);
                                    $('#bntCrearMaterial').attr("disabled", false); //habilitar
                                }
                            }).catch(e => {
                            console.log(e);
                            toastr.warning('No se puede guardar el Material');
                        });
                    } else {
                        $('#bntCrearMaterial').attr("disabled", false); //habilitar
                    }
                });
                //===== Fin-Crear Material =====

            }); //End-document-ready

            function updateSolicitudCompra(data){
                if(data !== null && data !== false){
                    var url_save = APP_URL + '/solicitud-de-compras/' + {{ $solicitud_compra_id }};
                    axios.put(url_save, data)
                        .then(response =>{
                            var resp = response.data;
                            if(!resp.error){
                                toastr.success(resp.message);
                                setTimeout(function (){
                                    window.location.href = APP_URL + '/solicitud-de-compras/'+ {{ $solicitud_compra_id }} +'/edit';
                                }, 1200);
                            }else{
                                toastr.warning(resp.message);
                                $('#guardarSolicitudForm').attr("disabled", false);
                            }
                        }).catch(e => {
                        console.log(e);
                    });
                }else{
                    toastr.warning('No se puede guardar la solicitud de compra');
                }
            }

            function eliminarMaterial_db(clave_registro, row) {
                if(clave_registro > 0) {
                    var url_save = APP_URL + '/solicitud-de-compra-eliminar-material/' + clave_registro;
                    axios.delete(url_save)
                        .then(response => {
                            var resp = response.data;
                            if(!resp.error){
                                toastr.success(resp.message);
                                productosDT.row('.selected').remove().draw(false);
                                window.location.href = APP_URL + '/solicitud-de-compras/' + {{ $solicitud_compra_id }} + '/edit';
                            }else{
                                toastr.warning('No se pudó eliminar el registro');
                            }
                        }).catch(e => {
                        console.log(e);
                        toastr.error('Ocurrio un error inesperado.');
                    });
                }else{
                    if (row) {
                        var mRows_length = productosDT.rows().data().toArray().length;
                        if (mRows_length === 1) {
                            toastr.warning('No se pudó eliminar el registro, porque debe agregar almenos un material.');
                        } else {
                            productosDT.row(row).remove().draw(false);
                        }
                    } else {
                        toastr.warning('Debe seleccionar un material para eliminarlo.');
                    }
                }
            }

            //Guarda Comentario grupal para los materiales seleccionados
            function createComentarioMaterial(data) {
                if(data !== null && data !== false) {
                    var url_save = APP_URL + '/solicitud-de-compras-store-comentario-material';
                    axios.post(url_save, data)
                        .then(response => {
                            var resp = response.data;
                            if (!resp.error) {
                                toastr.success(resp.message);
                                $("#modalNewComentarioGrupal").modal('hide');
                                //limpia campos form
                                $('#material_multi_select').val(null).trigger('change');
                                $('#comentario_grupal').val('');
                                window.location.href = APP_URL + '/solicitud-de-compras/' + {{ $solicitud_compra_id }} + '/edit';
                                //$('#productos-datatable').DataTable().ajax.reload();
                            } else {
                                toastr.warning(resp.message);
                            }
                        }).catch(e => {
                        toastr.error('Ocurrió un error inesperado, contacte al administrador de la aplicación.');
                    });
                } else {
                    toastr.warning('Faltan parametros: No se puede guardar el comentario para el material.');
                }
            }

            //Actualiza Comentario Grupal para los materiales
            function updateComentarioGrupalMaterial(data) {
                if(data !== null && data !== false) {
                    var url_update = APP_URL + '/solicitud-de-compras-update-comentario-material/' + data.comentario_material_clave_edit;
                    axios.put(url_update, data)
                        .then(response => {
                            var resp = response.data;
                            if(!resp.error){
                                toastr.success(resp.message);
                                $('#modalEditComentarioGrupal').modal('hide');
                                window.location.href = APP_URL + '/solicitud-de-compras/' + {{ $solicitud_compra_id }} + '/edit';
                            }else{
                                toastr.warning(resp.message);
                                $('#updateComentarioGrupal').attr("disabled", false);
                            }
                        }).catch(e => {
                        console.log(e);
                    });
                } else {
                    toastr.warning('Faltan parametros: No se puede actualizar el comentario para el material.');
                }
            }

            function encontrarDuplicadosPorIdMaterial(listaMateriales, data_new) {
                let contador = 0;
                let duplicado_new = {};

                for (const item_old of listaMateriales) {
                    let idProducto_old = item_old[2]; //producto_id en tabla
                    let idProducto_New = data_new.producto_id;

                    if (idProducto_old == idProducto_New) {
                        //Si coincide es duplicado
                        contador = parseInt(item_old[13]) + 1;
                        duplicado_new = {...data_new, num_duplicado_order: contador};
                    }
                }

                return duplicado_new;
            }

        </script>
    @endpush

</x-app-layout>
