<x-app-layout>
    <x-slot name="header">
        <h3 class="text-center">
            {{ __('Ver pago a proveedor') }}
        </h3>
    </x-slot>

    @push('styles')
        <link rel="stylesheet" href="{{asset('plugins2/bootstrap-datepicker/css/bootstrap-datepicker.min.css')}}">
    @endpush

    <div class="bg-white overflow-hidden mt-4">

        {{-- Form --}}
        <div class="mt-4">
            <form id="form_pago_a_proveedor">
                <div class="shadow">

                    {{-- Datos generales--}}
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="orden_compra_id" class="form-label">Orden de compra<span class="_required_">*</span></label>
                                <select class="form-control save-required" id="orden_compra_id" name="orden_compra_id" style="width: 100%;" tabindex="1" disabled>
                                    @if($pago_proveedor->ordenCompra)
                                        <option value="{{ $pago_proveedor->ordenCompra->id }}" selected="selected">{{ $pago_proveedor->ordenCompra->codigo }}</option>
                                    @endif
                                </select>
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="fecha_pago" class="form-label">Fecha de pago <span class="_required_">*</span></label>
                                <div class="input-group date">
                                    <input type="text" class="form-control save-required" name="fecha_pago" id="fecha_pago" autocomplete="off" placeholder="dd/mm/yyyy" tabindex="2" readonly disabled>
                                    <div class="input-group-addon">
                                        <i class="fa-regular fa-calendar-days"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <label for="conceptos_materiales" class="form-label">Concepto <span class="_required_">*</span></label>
                                <textarea class="form-control save-required" name="conceptos_materiales" id="conceptos_materiales" placeholder="Agregar concepto" rows="3" tabindex="3" disabled>{{ $pago_proveedor->conceptos_materiales }}</textarea>
                                <x-jet-input-error for="conceptos_materiales" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="comentarios" class="form-label">Comentario</label>
                                <input type="text" class="form-control" name="comentarios" id="comentarios" value="{{ $pago_proveedor->comentarios }}" autocomplete="off" placeholder="Agregar comentario" tabindex="4" disabled>
                            </div>
                        </div>
                        <div class="row text-center">
                            <div class="col">
                                <label for="archivo_pdf" class="form-label">Arrastra o sube un archivo PDF</label>
                                <div id="dropzoneContainer">
                                    <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                        <input id="url_factura_pdf" name="url_factura_pdf" type="hidden" class="form-control">
                                        <input id="url_resumen_pdf" name="url_resumen_pdf" type="hidden" class="form-control">
                                        <form id="uploadForm" method="POST" enctype="multipart/form-data">
                                            @csrf
                                            <div id="filePreviewFactura" style="display: none; margin-top: 20px;">
                                                <p><strong><a id="verFacturaPdf" href="{{url('/')}}/{{ $pago_proveedor->url_factura_pdf ?? '#' }}" target="_blank">Ver archivo</a></strong></p>
                                                <embed id="pdfPreviewFactura" src="" type="application/pdf" width="100%" height="200px"></embed>
                                            </div>
                                            <div id="filePreviewResumen" style="display: none; margin-top: 20px;">
                                                <p><strong><a id="verResumenPdf" href="{{url('/')}}/{{ $pago_proveedor->url_resumen_pdf ?? '#' }}" target="_blank">Ver archivo</a></strong></p>
                                                <embed id="pdfPreviewResumen" src="" type="application/pdf" width="100%" height="200px"></embed>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- End-Datos generales--}}

                    {{-- Emails --}}
                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Envio de correo</b></h5>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <label for="emails" class="form-label">Email</label>
                                <input type="text" class="form-control" name="emails" id="emails" value="{{ $pago_proveedor->emails }}" autocomplete="off" placeholder="Agregar Emails" tabindex="7" disabled>
                                <small>Ejemplo: demo@hotmail.com,demo2@gmail.com</small>
                            </div>
                            <div class="col-12">
                                <label for="email_asunto" class="form-label">Asunto</label>
                                <input type="text" class="form-control" name="email_asunto" id="email_asunto" value="{{ $pago_proveedor->email_asunto }}" autocomplete="off" placeholder="Agregar asunto" tabindex="8" disabled>
                            </div>
                            <div class="col-12">
                                <label for="email_contenido" class="form-label">Contenido</label>
                                <textarea class="form-control" name="email_contenido" id="email_contenido" placeholder="Agregar contenido" rows="3" tabindex="9" disabled>{{ $pago_proveedor->email_contenido }}</textarea>

                            </div>
                        </div>
                    </div>
                    {{-- End-Emails --}}

                    <hr>
                    <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                        <a href="{{ route('pagos-a-proveedores.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Cancelar</a>
                    </div>
                </div>
            </form>
        </div>
        {{-- End-Form --}}

    </div>


    @push('scripts')
        <script src="{{ asset('plugins/inputmask/jquery.inputmask.min.js') }}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/locales/bootstrap-datepicker.es.min.js')}}"></script>
        <script src="{{asset('js/admin.js')}}"></script>
        <script type="text/javascript">
            var APP_URL = {!! json_encode(url('/')) !!};

            let currentFileF = null;
            let currentFileP = null;
            const previewContainerFactura = document.getElementById("filePreviewFactura");
            const previewContainerResumen = document.getElementById("filePreviewResumen");
            const pdfPreviewFactura = document.getElementById("pdfPreviewFactura");
            const pdfPreviewResumen = document.getElementById("pdfPreviewResumen");
            const urlFacturaPdf = '{{$pago_proveedor->url_factura_pdf}}';
            const urlResumenPdf = '{{$pago_proveedor->url_resumen_pdf}}';


            $(document).ready(function($) {
                if (urlFacturaPdf) {
                    console.log('Previsualizar factura:',urlFacturaPdf);
                    url_factura_pdf
                    $('#url_factura_pdf').val(urlFacturaPdf);
                    pdfPreviewFactura.src = APP_URL + '/' + urlFacturaPdf;
                    previewContainerFactura.style.display = "block";

                }

                if (urlResumenPdf) {
                    console.log('Previsualizar resumen:',urlResumenPdf);
                    $('#url_resumen_pdf').val(urlResumenPdf);
                    pdfPreviewResumen.src = APP_URL + '/' + urlResumenPdf;
                    previewContainerResumen.style.display = "block";
                }

                Dropzone.autoDiscover = false;
                const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                const dropzoneFactura = new Dropzone("#dropzone-factura", {
                    url: "/pagos-a-proveedores-upload-pdf/factura",
                    maxFiles: 1,
                    acceptedFiles: ".pdf",
                    addRemoveLinks: true,
                    dictDefaultMessage: "Arrastra aquí la factura (PDF) o haz clic para subir",
                    headers: {
                        'X-CSRF-TOKEN': csrfToken,
                    },
                    autoProcessQueue: true,
                    init: function () {
                        this.on("sending", function (file, xhr, formData) {
                            toastr.info("Subiendo archivo.");
                            $('#guardarBtn').attr('disabled', true);
                        });

                        this.on("addedfile", function (file) {
                            if (currentFileF) {
                                const confirmReplace = confirm("Ya tienes un archivo subido. ¿Quieres reemplazarlo?");
                                if (!confirmReplace) {
                                    this.removeFile(file);
                                    return;
                                }
                                this.removeFile(currentFileF);
                                currentFileF = null;
                            }
                            currentFileF = file;
                            this.processQueue();
                        });

                        this.on("complete", function (file) {
                            console.log("Operación completada.");
                            $('#guardarBtn').attr('disabled', false);
                        });
                    },

                    success: function (file, response) {
                        console.log("Factura subida:", response.filePath);
                        toastr.success("Factura subida");
                        $('#url_factura_pdf').val(response.filePath);
                        if (response.filePath) {
                            pdfPreviewFactura.src = response.filePath;
                            document.getElementById("verFacturaPdf").href = response.filePath;
                            previewContainerFactura.style.display = "block";
                        }
                    },
                    removedfile: function (file) {
                        console.log("Factura eliminada:", file);
                        $('#url_factura_pdf').val('');
                        file.previewElement.remove();
                        pdfPreviewFactura.src = '';
                        previewContainerFactura.style.display = "none";
                    },
                    error: function (file, errorMessage) {
                        console.error("Error al subir la factura:", errorMessage);
                        toastr.warning("No se pudo subir el archivo al proveedor");
                    },
                });

                const dropzoneResumen = new Dropzone("#dropzone-resumen", {
                    url: "/pagos-a-proveedores-upload-pdf/resumen",
                    maxFiles: 1,
                    acceptedFiles: ".pdf",
                    addRemoveLinks: true,
                    dictDefaultMessage: "Arrastra aquí el resumen (PDF) o haz clic para subir",
                    headers: {
                        'X-CSRF-TOKEN': csrfToken,
                    },
                    init: function () {
                        this.on("sending", function (file, xhr, formData) {
                            toastr.info("Subiendo archivo.");
                            $('#guardarBtn').attr('disabled', true);
                        });

                        this.on("addedfile", function (file) {
                            if (currentFileP) {
                                const confirmReplace = confirm("Ya tienes un archivo subido. ¿Quieres reemplazarlo?");
                                if (!confirmReplace) {
                                    this.removeFile(file);
                                    return;
                                }
                                this.removeFile(currentFileP);
                                currentFileP = null;
                            }
                            currentFileP = file;
                            this.processQueue();
                        });

                        this.on("complete", function (file) {
                            console.log("Operación completada.");
                            $('#guardarBtn').attr('disabled', false);
                        });
                    },
                    success: function (file, response) {
                        console.log("Archivo de resumen subido.:", response.filePath);
                        toastr.success("Archivo resumen subido.");
                        $('#url_resumen_pdf').val(response.filePath);
                        if (response.filePath) {
                            console.log('Previsualizar resumen:',response.filePath);
                            pdfPreviewResumen.src = response.filePath;
                            document.getElementById("verResumenPdf").href = response.filePath;
                            previewContainerResumen.style.display = "block";
                        }
                    },
                    removedfile: function (file) {
                        console.log("Resumen eliminado:", file);
                        $('#url_resumen_pdf').val('');
                        file.previewElement.remove();
                        pdfPreviewResumen.src = '';
                        previewContainerResumen.style.display = "none";
                    },
                    error: function (file, errorMessage) {
                        console.error("Error al subir resumen:", errorMessage);
                        toastr.warning("No se pudo subir el archivo resumen");
                    },
                });

                $('#orden_compra_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                });

                $('#fecha_pago').datepicker({
                    language: 'es',
                    autoclose: true,
                    format: "dd/mm/yyyy",
                    todayHighlight: true,
                    //startDate: new Date()
                });

                var fFechaPago = '{{ $pago_proveedor->fecha_pago }}';
                if(fFechaPago){
                    var fPago = moment(fFechaPago).format("DD-MM-YYYY");
                    $('#fecha_pago').datepicker( 'setDate', fPago );
                }

            }); //End-document-ready
        </script>

        @if (session()->has('success'))
            <script>
                toastr.success("{{ session('success') }}");
            </script>
        @endif

        @if (session()->has('message'))
            <script>
                toastr.error('Ocurrio un error inesperado.');
            </script>
        @endif

    @endpush

</x-app-layout>
