<x-app-layout>
    <x-slot name="header">
        <h3 class="text-center">
            {{ __('Ver Orden de compra') }}
        </h3>
    </x-slot>

    @push('styles')
        <link rel="stylesheet" href="{{asset('plugins2/bootstrap-datepicker/css/bootstrap-datepicker.min.css')}}">
    @endpush

    @php
        $orden_compra_estatus = $orden_compra->estatus->clave;
        $estatus_por_autorizar = $estatus_por_autorizar->clave;
        $estatus_autorizado = $estatus_autorizado->clave;
        $fecha_orden = $orden_compra->fecha_orden;
        $orden_compra_clave_version = $orden_compra->clave_version;
    @endphp

    <div class="bg-white overflow-hidden mt-4">

        {{-- Form --}}
        <div class="mt-4">
            <form id="form_orden_compra">
                <div class="shadow">

                    {{-- Datos generales--}}
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="solicitud_compra_id" class="form-label">Solicitud compra <span class="_required_">*</span></label>
                                <select class="form-control save-required @error('solicitud_compra_id') is-invalid @enderror" id="solicitud_compra_id" name="solicitud_compra_id" tabindex="2" disabled>
                                    @if($orden_compra->solicitudCompra)
                                        <option value="{{ $orden_compra->solicitudCompra->id }}" selected="selected">
                                            {{ $orden_compra->solicitudCompra->codigo }}
                                        </option>
                                    @endif
                                </select>
                                <x-jet-input-error for="solicitud_compra_id" />
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label for="proveedor_id" class="form-label">Proveedor <span class="_required_">*</span></label>
                                <select class="form-control save-required @error('proveedor_id') is-invalid @enderror" id="proveedor_id" name="proveedor_id" tabindex="1" disabled>
                                    @if($orden_compra->proveedor)
                                        <option value="{{ $orden_compra->proveedor->id }}" selected="selected">{{ $orden_compra->proveedor->razon_social }}</option>
                                    @endif
                                </select>
                                <x-jet-input-error for="proveedor_id" />
                            </div>
                        </div>
                    </div>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <label for="codigo" class="form-label">Código O.C.</label>
                                <input type="text" class="form-control" name="codigo" id="codigo" value="{{ $orden_compra->codigo }}" autocomplete="off" tabindex="3" disabled>
                                <x-jet-input-error for="codigo" />
                            </div>
                            <div class="col">
                                <label for="vendedor" class="form-label">Vendedor</label>
                                <input type="text" class="form-control" name="vendedor" id="vendedor" value="{{ $orden_compra->vendedor }}" autocomplete="off" placeholder="Agregar vendedor" tabindex="3" readonly disabled>
                            </div>
                            <div class="col">
                                <label for="metodo_envio" class="form-label">Método de envío</label>
                                <input type="text" class="form-control" name="metodo_envio" id="metodo_envio" value="{{ $orden_compra->metodo_envio }}" autocomplete="off" placeholder="Agregar método de envío" tabindex="4" readonly disabled>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="conticiones_de_pago" class="form-label">Conticiones de pago</label>
                                <input type="text" class="form-control" name="conticiones_de_pago" id="conticiones_de_pago" value="{{ $orden_compra->conticiones_de_pago }}" autocomplete="off" placeholder="Agregar conticiones de pago" tabindex="5" readonly disabled>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="fecha_orden" class="form-label">Fecha de O.C.</label>
                                <div class="input-group date">
                                    <input type="text" class="form-control" name="fecha_orden" id="fecha_orden" autocomplete="off" placeholder="dd/mm/yyyy" readonly disabled>
                                    <div class="input-group-addon">
                                        <i class="fa-regular fa-calendar-days"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="col">
                                <label for="fecha_embarque" class="form-label">Fecha de embarque</label>
                                <div class="input-group date">
                                    <input type="text" class="form-control" name="fecha_embarque" id="fecha_embarque" autocomplete="off" placeholder="dd/mm/yyyy" tabindex="5" readonly disabled>
                                    <div class="input-group-addon">
                                        <i class="fa-regular fa-calendar-days"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="col">
                                <label for="fecha_entrega" class="form-label">Fecha de entrega</label>
                                <div class="input-group date">
                                    <input type="text" class="form-control" name="fecha_entrega" id="fecha_entrega" autocomplete="off" placeholder="dd/mm/yyyy" tabindex="5" readonly disabled>
                                    <div class="input-group-addon">
                                        <i class="fa-regular fa-calendar-days"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="comentarios" class="form-label">Comentario</label>
                                <textarea class="form-control" name="comentarios" id="comentarios" autocomplete="off" placeholder="Agregar comentario" tabindex="18" readonly disabled>{{ $orden_compra->comentarios }}</textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="comentario_gloria" class="form-label">Comentario de Gloria</label>
                                <textarea class="form-control" name="comentario_gloria" id="comentario_gloria" placeholder="Agregar comentario de Gloria" rows="3" tabindex="9" disabled>{{ $orden_compra->comentario_gloria }}</textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <div id="filePreview" style="display: none; margin-top: 20px;">
                                    <p><strong><a id="verArchivoPdf" href="{{url('/')}}/{{$orden_compra->url_descarga_pdf ?? '#'}}" target="_blank">Ver archivo</a></strong></p>
                                    <embed id="pdfPreview" src="" type="application/pdf" width="100%" height="200px"></embed>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- End-Datos generales--}}

                    {{-- Materiales--}}
                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Materiales</b></h5>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="productos-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                        <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Clave Solicitud Compra</th>
                                            <th>Clave de Material</th>
                                            <th>Material</th>
                                            <th>Clave de Unidad</th>
                                            <th>Unidad</th>
                                            <th>Cantidad</th>
                                            <th>Área de uso</th>
                                            <th>Marca</th>
                                            <th>Modelo</th>
                                            <th>Observaciones</th>
                                            <th>Precio lista</th>
                                            <th>Precio unitario</th>
                                            <th>Importe</th>
                                            <th>Descuento</th>
                                            <th>Total</th>
{{--                                            <th>Clave IVA compuesta</th>--}}
{{--                                            <th>Clave de IVA</th>--}}
{{--                                            <th>IVA %</th>--}}
{{--                                            <th>Monto IVA</th>--}}
{{--                                            <th>Total</th>--}}
{{--                                            <th>Total en letras</th>--}}
                                        </tr>
                                        </thead>
                                        <tbody></tbody>
                                        <tfoot>
                                            <tr>
                                                <th colspan="20" style="text-align:right">Total:</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <label class="form-label d-none">SUBTOTAL:</label>
                                <input type="hidden" class="form-control" name="subtotal_global_input" id="subtotal_global_input" value="{{ $orden_compra->importe_sin_impuestos }}">
                                <label class="form-label d-none">IVA</label>
                                <input type="hidden" class="form-control" name="iva_porc_global_input" id="iva_porc_global_input" value="@if($orden_compra->ivaImpuesto !== null) {{ $orden_compra->ivaImpuesto->iva }} @endif">
                                <label class="form-label d-none">Monto IVA</label>
                                <input type="hidden" class="form-control" name="monto_iva_global_input" id="monto_iva_global_input" value="{{ $orden_compra->monto_iva }}">
                                <label class="form-label d-none">ISR</label>
                                <input type="hidden" class="form-control" name="aplicar_isr_activo" id="aplicar_isr_activo" value="{{ $orden_compra->proveedor->aplica_isr }}">
                                <input type="hidden" class="form-control" name="aplica_monto_isr" id="aplica_monto_isr" value="{{ $orden_compra->proveedor->aplica_monto_isr }}">
                                <input type="hidden" class="form-control" name="monto_isr_global_input" id="monto_isr_global_input" value="{{ $orden_compra->monto_isr }}">
                                <label class="form-label d-none">TOTAL:</label>
                                <input type="hidden" class="form-control" name="total_global_input" id="total_global_input" value="{{ $orden_compra->total }}">
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                <div class="table-responsive">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <th>SUBTOTAL:</th>
                                            <td><p id="importe_sin_impuestos_text">MXN $</p></td>
                                        </tr>
                                        <tr>
                                            <td><p id="iva_nombre">IVA %</p></td>
                                            <td><p id="monto_iva_text">MXN $</p></td>
                                        </tr>
                                        <tr>
                                            <td><p id="iva_nombre">ISR</p></td>
                                            <td><p id="monto_isr_text">MXN $</p></td>
                                        </tr>
                                        <tr>
                                            <th>TOTAL:</th>
                                            <th><p id="monto_total_text">MXN $</p></th>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="col-12">
                                <label for="total_letras" class="form-label">Total en letras</label>
                                <input type="text" class="form-control" name="total_letras" id="total_letras" value="{{ $orden_compra->total_letras }}" autocomplete="off" placeholder="Agregar total en letras" readonly disabled>
                            </div>
                        </div>
                    </div>
                    {{-- End-Materiales--}}

                    {{-- Lista-de-Anticipos --}}
                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Pagos y Anticipos</b></h5>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-sm-5 col-md-6 col-lg-6">
                                <label for="tipo_pago_id" class="form-label">Tipo de Pago <span class="_required_">*</span></label>
                                <select class="form-control save-required" id="tipo_pago_id" name="tipo_pago_id" disabled readonly>
                                    @if($options_tipoPago)
                                        {!! $options_tipoPago !!}
                                    @endif
                                </select>
                            </div>
                            <div class="col-12 col-sm-5 col-md-6 col-lg-6">
                                <label class="form-label"><b>Saldo por pagar</b></label>
                                <input type="text" class="form-control" name="total_saldo_por_pagar" id="total_saldo_por_pagar" disabled>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table id="anticipos-datatable" class="table table-striped table-bordered responsive" cellspacing="0" width="100%">
                                        <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Comentario</th>
                                            <th>Anticipo</th>
                                            <th>Total letras</th>
                                            <th>Forma de pago</th>
                                            <th>Fecha de pago</th>
                                        </tr>
                                        </thead>
                                        <tbody></tbody>
                                        <tfoot>
                                            <tr>
                                                <th colspan="20" style="text-align:right">Total:</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- End-Lista-de-Anticipos --}}

                    {{-- Emails --}}
                    <hr>
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <h5 class="text-center"><b>Envio de correo</b></h5>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <label for="emails" class="form-label">Email</label>
                                <input type="text" class="form-control" name="emails" id="emails" value="{{ $orden_compra->emails }}" autocomplete="off" placeholder="Agregar Emails" tabindex="10" readonly disabled>
                                <small>Ejemplo: demo@hotmail.com,demo2@gmail.com</small>
                            </div>
                            <div class="col-12">
                                <label for="email_asunto" class="form-label">Asunto</label>
                                <input type="text" class="form-control" name="email_asunto" id="email_asunto" value="{{ $orden_compra->email_asunto }}" autocomplete="off" placeholder="Agregar asunto" tabindex="11" readonly disabled>
                            </div>
                            <div class="col-12">
                                <label for="email_contenido" class="form-label">Contenido</label>
                                <textarea class="form-control" name="email_contenido" id="email_contenido" placeholder="Agregar contenido" rows="3" tabindex="12" readonly disabled>{{ $orden_compra->email_contenido }}</textarea>

                            </div>
                        </div>
                    </div>
                    {{-- End-Emails --}}

                    <hr>
                    <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                        <a href="{{ route('ordenes-de-compras.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Cancelar</a>
                    </div>
                </div>
            </form>
        </div>
        {{-- End-Form --}}

    </div>


    @push('scripts')
        <script src="{{ asset('plugins/inputmask/jquery.inputmask.min.js') }}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>
        <script src="{{asset('plugins2/bootstrap-datepicker/locales/bootstrap-datepicker.es.min.js')}}"></script>
        <script src="{{asset('js/admin.js')}}"></script>
        <script type="text/javascript">
            var APP_URL = {!! json_encode(url('/')) !!};
            var $orden_compra_clave_version = @json($orden_compra_clave_version);
            var $orden_compra_solicitud_compra_clon_id = @json($orden_compra->solicitud_compra_clon_id);
            //Estatus O.C.
            var $orden_compra_estatus = @json($orden_compra_estatus);
            var $estatus_por_autorizar = @json($estatus_por_autorizar);
            var $estatus_autorizado = @json($estatus_autorizado);

            //Total Global
            const subtotal_global_input = document.querySelector("#subtotal_global_input");
            const iva_porc_global_input = document.querySelector("#iva_porc_global_input");
            const monto_iva_global_input = document.querySelector("#monto_iva_global_input");
            const aplicar_isr_activo = document.querySelector("#aplicar_isr_activo");
            const aplica_monto_isr = document.querySelector("#aplica_monto_isr");
            const monto_isr_global_input = document.querySelector("#monto_isr_global_input");
            const total_global_input = document.querySelector("#total_global_input");
            const total_letras = document.querySelector("#total_letras");

            const previewContainer = document.getElementById("filePreview");
            const pdfPreview = document.getElementById("pdfPreview");
            const urlDescargaPdf = '{{$orden_compra->url_descarga_pdf}}';

            //Pagos/Anticipos DT
            var anticiposDT = null;
            var tipo_pago_selected_default = '{{ $orden_compra->tipo_pago_id }}';
            var total_saldo_por_pagar_input = document.querySelector("#total_saldo_por_pagar");

            $(document).ready(function($){
                if (urlDescargaPdf)  {
                    console.log('Previsualizar archivo:',urlDescargaPdf);
                    pdfPreview.src = APP_URL + `/{{$orden_compra->url_descarga_pdf}}`;
                    previewContainer.style.display = "block";
                }

                $('#solicitud_compra_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    cache: false,
                });

                $('#proveedor_id').select2({
                    width: '100%',
                    theme: "bootstrap",
                    placeholder: 'Selecciona una opción',
                    cache: false,
                });

                $('#fecha_orden').datepicker({
                    language: 'es',
                    autoclose: true,
                    format: "dd/mm/yyyy",
                    todayHighlight: true,
                    //startDate: new Date()
                });
                var Ffecha_orden = moment('{{ $fecha_orden }}').format("DD-MM-YYYY");
                $('#fecha_orden').datepicker( 'setDate', Ffecha_orden );

                $('#fecha_entrega').datepicker({
                    language: 'es',
                    autoclose: true,
                    format: "dd/mm/yyyy",
                    todayHighlight: true,
                    //startDate: new Date()
                });

                let fFechaEntrega = '{{ $orden_compra->fecha_entrega }}';
                if(fFechaEntrega){
                    var fEntrega = moment(fFechaEntrega).format("DD-MM-YYYY");
                    $('#fecha_entrega').datepicker( 'setDate', fEntrega );
                }

                $('#fecha_embarque').datepicker({
                    language: 'es',
                    autoclose: true,
                    format: "dd/mm/yyyy",
                    todayHighlight: true,
                    //startDate: new Date()
                });

                let fFechaEmbarque = '{{ $orden_compra->fecha_embarque }}';
                if(fFechaEmbarque){
                    var fEntrega = moment(fFechaEmbarque).format("DD-MM-YYYY");
                    $('#fecha_embarque').datepicker( 'setDate', fEntrega );
                }

                //------------- Materiales -------------
                const productosDT = new DataTable('#productos-datatable', {
                    "dom": '<"top"f><"datatable-scroll"rt><"bottom"ip><"clear">',
                    pageLength: 6,
                    responsive: true,
                    scrollX: false,
                    "language": {
                        "url": APP_URL + "/plugins/DataTables/language.MX.json"
                    },
                    columnDefs: [
                        { visible: false, targets: [1,2,4] },
                        {
                            targets: [11, 12, 13, 14, 15], // Precios, Descuento y Total materiales
                            render: function (data, type, row) {
                                if (type === 'display' || type === 'filter') {
                                    let num = parseFloat(data);
                                    if (isNaN(num)) return data;
                                    return num.toLocaleString('es-MX', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                                }
                                return data;
                            }
                        }
                    ],
                    footerCallback: function (row, data, start, end, display){
                        let api = this.api();
                        let formatNumber = function (num) {
                            return new Intl.NumberFormat('es-MX', {
                                style: 'currency',
                                currency: 'MXN',
                                minimumFractionDigits: 2,
                                maximumFractionDigits: 2
                            }).format(num);
                        };

                        // Remove the formatting to get integer data for summation
                        let intVal = function (i) {
                            return typeof i === 'string'
                                ? i.replace(/[\$,]/g, '') * 1
                                : typeof i === 'number'
                                    ? i
                                    : 0;
                        };

                        // Total over all pages
                        var total = api
                            .column(15)
                            .data()
                            .reduce((a, b) => intVal(a) + intVal(b), 0);
                        total = roundUsingToFixed(total, 2);

                        // Total over this page
                        var pageTotal = api
                            .column(15, { page: 'current' })
                            .data()
                            .reduce((a, b) => intVal(a) + intVal(b), 0);
                        pageTotal = roundUsingToFixed(pageTotal, 2);

                        // Update footer
                        $( api.column(0).footer()).html(
                            'Total x pag.: '+formatNumber(pageTotal) +' ( TOTAL:  '+ formatNumber(total) +' )'
                        );

                        //Global Total
                        subtotal_global_input.value = total;
                        monto_iva_global_input.value = calcula_monto_iva(total, iva_porc_global_input.value);
                        //total_global_input.value = calcular_Monto_Total(subtotal_global_input.value, monto_iva_global_input.value);
                        monto_isr_global_input.value = calcular_monto_isr(aplicar_isr_activo.value, subtotal_global_input.value, aplica_monto_isr.value);
                        total_global_input.value = calcular_Monto_Total(subtotal_global_input.value, monto_iva_global_input.value, aplicar_isr_activo.value, monto_isr_global_input.value);
                        $('#importe_sin_impuestos_text').text('MXN ' + formatNumber(subtotal_global_input.value));
                        $('#iva_nombre').text('IVA ' + iva_porc_global_input.value +'%');
                        $('#monto_iva_text').text('MXN ' + formatNumber(monto_iva_global_input.value));
                        $('#monto_isr_text').text('MXN $ ' + formatNumber(monto_isr_global_input.value));
                        $('#monto_total_text').text('MXN ' + formatNumber(total_global_input.value));

                    }
                });
                let counter = 1;

                //Lista de Materiales guardados
                if(($orden_compra_clave_version === 'ORDEN_COMPRA_V1' || $orden_compra_clave_version === 'ORDEN_COMPRA_V2') && $orden_compra_solicitud_compra_clon_id == null) {
                    var data_solicitud = @json($orden_compra->solicitudCompra);
                    if(data_solicitud != null && data_solicitud != ''){
                        let data_solicitud_compra_producto = data_solicitud.solicitud_compra_producto;
                        $.each(data_solicitud_compra_producto, function (index, val){
                            addMaterialRowDT(val, 'EDIT_MATERIAL_CON_PRECIO');
                        });
                    } else {
                        toastr.warning("Error no se pudo obtener los Materiales.");
                    }
                } else if ($orden_compra_clave_version === 'ORDEN_COMPRA_V2' && $orden_compra_solicitud_compra_clon_id !== null) {
                    var data_SolicitudCompraClon = @json($orden_compra->SolicitudCompraClon);
                    if(data_SolicitudCompraClon != null && data_SolicitudCompraClon != '') {
                        let data_solicitud_compra_producto_clon = data_SolicitudCompraClon.solicitud_compra_producto_clon;
                        $.each(data_solicitud_compra_producto_clon, function (index, material){
                            addMaterialRowDT(material, 'EDIT_MATERIAL_CON_PRECIO');
                        });
                    } else {
                        toastr.warning("Error no se pudo obtener los Materiales.");
                    }
                }

                //Agrega Material a la fila de la tabla
                function addMaterialRowDT(data, type = '') {
                    if ($orden_compra_clave_version === 'ORDEN_COMPRA_V1') {
                        productosDT.row
                            .add([
                                counter,
                                data.solicitud_compra_id,
                                data.producto_id,
                                data.producto.nombre,
                                data.unidad_id,
                                data.unidad.nombre,
                                data.cantidad,
                                data.area_de_uso,
                                data.marca,
                                data.modelo,
                                data.observaciones,
                                data.precio_lista,
                                data.precio_unitario,
                                data.importe,
                                data.descuento,
                                data.subtotal, //formatNumberComas(data.subtotal)
                            ])
                            .draw(false);
                    } else if($orden_compra_clave_version === 'ORDEN_COMPRA_V2' && $orden_compra_solicitud_compra_clon_id == null) {
                        //Sin clon
                        let material_precio = data.rel_solicitud_compra_producto_precio;
                        productosDT.row
                            .add([
                                counter,
                                data.solicitud_compra_id,
                                data.producto_id,
                                data.producto.nombre,
                                data.unidad_id,
                                data.unidad.nombre,
                                data.cantidad,
                                data.area_de_uso,
                                data.marca,
                                data.modelo,
                                data.observaciones,
                                material_precio.precio_lista,
                                material_precio.precio_unitario,
                                material_precio.importe,
                                material_precio.descuento,
                                material_precio.subtotal, //formatNumberComas(material_precio.subtotal)
                            ])
                            .draw(false);
                    } else if ($orden_compra_clave_version === 'ORDEN_COMPRA_V2' && $orden_compra_solicitud_compra_clon_id !== null) {
                        //Si Existe clon
                        productosDT.row
                            .add([
                                counter,
                                data.solicitud_compra_clon_id,
                                data.producto_id,
                                data.producto.nombre,
                                data.unidad_id,
                                data.unidad.nombre,
                                data.cantidad,
                                data.area_de_uso,
                                data.marca,
                                data.modelo,
                                data.observaciones,
                                data.precio_lista,
                                data.precio_unitario,
                                data.importe,
                                data.descuento,
                                data.subtotal, //formatNumberComas(data.subtotal)
                            ])
                            .draw(false);
                    }
                    counter++;
                }

                //---------------- Anticipos ------------------
                 anticiposDT = new DataTable('#anticipos-datatable', {
                    "dom": '<"top"f><"datatable-scroll"rt><"bottom"ip><"clear">',
                    pageLength: 6,
                    responsive: true,
                    scrollX: false,
                    "language": {
                        "url": APP_URL + "/plugins/DataTables/language.MX.json"
                    },
                    columnDefs: [
                        {
                            targets: 2, // Columna "Anticipo"
                            render: function (data, type, row) {
                                if (type === 'display' || type === 'filter') {
                                    let num = parseFloat(data);
                                    if (isNaN(num)) return data;
                                    return num.toLocaleString('es-MX', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                                }
                                return data;
                            }
                        }
                    ],
                    footerCallback: function (row, data, start, end, display){
                        let api = this.api();
                        let formatNumber = function (num) {
                            return new Intl.NumberFormat('es-MX', {
                                style: 'currency',
                                currency: 'MXN',
                                minimumFractionDigits: 2,
                                maximumFractionDigits: 2
                            }).format(num);
                        };

                        // Remove the formatting to get integer data for summation
                        let intVal = function (i) {
                            return typeof i === 'string'
                                ? i.replace(/[\$,]/g, '') * 1
                                : typeof i === 'number'
                                    ? i
                                    : 0;
                        };

                        // Total over all pages
                        var total = api
                            .column(2)
                            .data()
                            .reduce((a, b) => intVal(a) + intVal(b), 0);
                        total = roundUsingToFixed(total, 2);

                        // Total over this page
                        var pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce((a, b) => intVal(a) + intVal(b), 0);
                        pageTotal = roundUsingToFixed(pageTotal, 2);

                        // Update footer
                        $( api.column(0).footer()).html(
                            'Total x pag.: '+ formatNumber(pageTotal) +' ( TOTAL: '+ formatNumber(total) +' )'
                        );

                        //Total Saldo por pagar
                        var saldo_aux = calcular_Total_saldo_Por_Pagar(total_global_input.value, total);
                        total_saldo_por_pagar_input.value = formatNumber(saldo_aux);

                    }
                });
                let counter_anticipos = 1;

                //Lista de Anticipos guardados
                let data_anticipos_list = @json($orden_compra->ordenCompraAnticipo);
                if(data_anticipos_list != null && data_anticipos_list != ''){
                    $.each(data_anticipos_list, function (index, val){
                        addRowAnticipos(val, 2);
                    });
                }

                function addRowAnticipos(data, type = 1) {
                    if (type == 1) {
                        anticiposDT.row
                            .add([
                                counter_anticipos,
                                // data.producto_id,
                            ])
                            .draw(false);
                    } else if(type == 2){
                        let fdePago = moment(data.fecha_anticipo, 'YYYY-MM-DD').format("DD/MM/YYYY");
                        anticiposDT.row
                            .add([
                                counter_anticipos,
                                data.comentario,
                                data.anticipo,
                                data.anticipo_letras,
                                data.forma_de_pago,
                                fdePago,
                            ])
                            .draw(false);
                    }
                    counter_anticipos++;
                }

            });  //End-document-ready

            // Calcula el monto del IVA
            function calcula_monto_iva(subtotal, iva_porcentaje) {
                var monto_iva = 0;
                if (iva_porcentaje > 0){
                    monto_iva = parseFloat(subtotal) * (iva_porcentaje / 100);
                    monto_iva = roundUsingToFixed(monto_iva, 2);
                }
                return monto_iva;
            }

            function calcular_monto_isr(aplicar_isr, subtotal, monto_isr_aplicado) {
                var monto_isr = 0;
                if (aplicar_isr == 1) {
                    monto_isr = subtotal * monto_isr_aplicado;
                    monto_isr = roundUsingToFixed(monto_isr, 2);
                }
                return monto_isr;
            }

            function calcular_Monto_Total(subtotal, monto_iva, aplicar_isr, monto_isr){
                var monto_total = 0;
                monto_total = parseFloat(subtotal) + parseFloat(monto_iva);
                monto_total = roundUsingToFixed(monto_total, 2);
                if (aplicar_isr == 1){
                    monto_total = roundUsingToFixed(monto_total - monto_isr, 2);
                }
                return monto_total;
            }

            function calcular_Total_saldo_Por_Pagar(total_a_pagar, total_anticipos){
                var saldo_pendiente = 0;
                saldo_pendiente = parseFloat(total_a_pagar) - parseFloat(total_anticipos);
                saldo_pendiente = roundUsingToFixed(saldo_pendiente, 2);
                return saldo_pendiente;
            }
        </script>

        @if (session()->has('success'))
            <script>
                toastr.success("{{ session('success') }}");
            </script>
        @endif

        @if (session()->has('message'))
            <script>
                toastr.error('Ocurrio un error inesperado.');
            </script>
        @endif
    @endpush

</x-app-layout>
