<x-app-layout>
    <x-slot name="header">
        <h2 class="">
            {{ __('Editar Obra') }}
        </h2>
    </x-slot>

    <div class="bg-white overflow-hidden">

        {{-- Form --}}
        <div class="mt-4">
            <form method="POST" action="{{ route('catalogo-de-obras.update', $obra->id) }}">
                @method('PUT')
                @csrf
                <div class="shadow">

                    {{-- Datos generales--}}
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <label for="nombre" class="form-label">Nombre <span class="_required_">*</span></label>
                                <input type="text" class="form-control @error('nombre') is-invalid @enderror" name="nombre" id="nombre" value="{{ $obra->nombre }}" autocomplete="off" placeholder="Nombre" tabindex="1">
                                <x-jet-input-error for="nombre" />
                            </div>
                            <div class="col">
                                <label for="no_control" class="form-label">No. Control <span class="_required_">*</span></label>
                                <input type="text" class="form-control @error('no_control') is-invalid @enderror" name="no_control" id="no_control" value="{{ $obra->no_control }}" autocomplete="off" placeholder="No. Control" tabindex="2">
                                <x-jet-input-error for="no_control" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="direccion" class="form-label">Dirección</label>
                                <input type="text" class="form-control @error('direccion') is-invalid @enderror" name="direccion" id="direccion" value="{{ $obra->direccion }}" autocomplete="off" placeholder="Agregar dirección" tabindex="3">
                                <x-jet-input-error for="direccion" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="comentarios" class="form-label">Comentario</label>
                                <input type="text" class="form-control @error('comentarios') is-invalid @enderror" name="comentarios" id="comentarios" value="{{ $obra->comentarios }}" autocomplete="off" placeholder="Agregar comentario" tabindex="4">
                                <x-jet-input-error for="comentarios" />
                            </div>
                        </div>
                    </div>
                    {{-- End-Datos generales--}}

                    <hr>

                    <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                        <a href="{{ route('catalogo-de-obras.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Cancelar</a>
                        <button type="submit" class="btn btn-primary text-white" tabindex="5">
                            <i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar
                        </button>
                    </div>
                </div>
            </form>
        </div>
        {{-- End-Form --}}

    </div>

    @push('scripts')
{{--        <script type="text/javascript">--}}
{{--            $(document).ready(function($){--}}

{{--            });--}}
{{--        </script>--}}
    @endpush

</x-app-layout>
