<x-app-layout>
    <x-slot name="header">
        <h2 class="">
            {{ __('Nuevo IVA') }}
        </h2>
    </x-slot>

    <div class="bg-white overflow-hidden">

        {{-- Form --}}
        <div class="mt-4">
            <form method="POST" action="{{ route('catalogo-de-iva-impuesto.store') }}">
                @csrf
                <div class="shadow">

                    {{-- Datos generales--}}
                    <div class="px-4 py-1">
                        <div class="row">
                            <div class="col">
                                <label for="iva" class="form-label">IVA <span class="_required_">*</span></label>
                                <input type="text" class="form-control @error('iva') is-invalid @enderror" name="iva" id="iva" autocomplete="off" placeholder="IVA" tabindex="1">
                                <small>Ej: 16</small>
                                <x-jet-input-error for="iva" />
                            </div>
                            <div class="col">
                                <label for="nombre" class="form-label">Nombre <span class="_required_">*</span></label>
                                <input type="text" class="form-control @error('nombre') is-invalid @enderror" name="nombre" id="nombre" autocomplete="off" placeholder="Agregar nombre" tabindex="2">
                                <small>Ej: 16%</small>
                                <x-jet-input-error for="nombre" />
                            </div>
                        </div>
                        <div class="row mt-1">
                            <div class="col">
                                <label for="descripcion" class="form-label">Descripción</label>
                                <input type="text" class="form-control" name="descripcion" id="descripcion" autocomplete="off" placeholder="Agregar descripción" tabindex="3">
                                <x-jet-input-error for="descripcion" />
                            </div>
                        </div>
                    </div>
                    {{-- End-Datos generales--}}

                    <hr>

                    <div class="px-4 py-1 pb-3 d-flex justify-content-end">
                        <a href="{{ route('catalogo-de-iva-impuesto.index') }}" class="btn btn-danger text-white me-2"><i class="fas fa-reply"></i> Cancelar</a>
                        <button type="submit" class="btn btn-primary text-white" tabindex="5"><i class="fa-sharp fa-solid fa-floppy-disk"></i>&nbsp;Guardar</button>
                    </div>
                </div>
            </form>
        </div>
        {{-- End-Form --}}

    </div>

    @push('scripts')
        <script src="{{ asset('plugins/inputmask/jquery.inputmask.min.js') }}"></script>
        <script type="text/javascript">
            $(document).ready(function($){

                $('#iva').inputmask({
                    alias: 'numeric',
                    allowMinus: false,
                    digits: 0,
                });

            });
        </script>
    @endpush

</x-app-layout>
