function validateImg(img, div_img, div_result) {

    var input = img;
    var file = input.files[0];
    var fileName = input.value;
    var maxSize = 2097152; //bytes = 2 MB.
    var extensions = new RegExp(/.jpg|.jpeg|.png/i); //Extensiones válidas
    console.log(fileName);
    var error = {
        state: false,
        msg: ''
    };

    if (file) {
        for (var i = fileName.length - 1; i >= 0; i--) {
            if (fileName[i] == '.') {

                var ext = fileName.substring(fileName[i], fileName.length);

                if (!extensions.test(ext)) {
                    error.state = true;
                    error.msg += 'La extensión del archivo no es válida.<br>';
                }

                break;
            }

        }

        if (file.size > maxSize) {
            error.state = true;
            error.msg += 'La imágen no puede ocupar más de ' + maxSize / 1048576 + ' MB.';
        }

        if (error.state) {
            input.value = '';
            document.getElementById("" + div_result + "").innerHTML = error.msg;
            document.getElementById("" + div_img + "").style.display = 'none';
            console.log('ocultar');
            return;
        } else {
            document.getElementById("" + div_result + "").innerHTML = "";
            document.getElementById("" + div_img + "").style.display = 'block';
            console.log('mostrar');
        }

        var reader = new FileReader();

        reader.onload = function (e) {
            document.getElementById("" + div_img + "").src = e.target.result;
        }
        reader.readAsDataURL(img.files[0]);
    }
}

function stripTag(content, tag) {
    var div = document.createElement('div');
    div.innerHTML = content;
    var scripts = div.getElementsByTagName(tag);
    var i = scripts.length;
    while (i--) {
        scripts[i].parentNode.removeChild(scripts[i]);
    }
    return div.innerHTML;
}

function decodeHtml(html) {
    var txt = document.createElement("textarea");
    txt.innerHTML = html;
    return txt.value;
}

function secureInput(content) {
    content = stripTag(content, 'script');
    content = decodeHtml(content);
    content = content.replace(/[;:'"<>\{\}\[\]\\\/]/gi, '');

    return content;
}


function validateForm(id_form) {
    var countErrors = 0;
    $(id_form + ' .has-error').removeClass("has-error");

    $(id_form + " input.save-required").each(function () {
        var $el = $(this);
        var val = secureInput($el.val().trim());
        if (val == "") {
            countErrors++;
            // console.log($el);
            $(this).parents("div:first").addClass("has-error");
        }
    });

    $(id_form + " select.save-required").each(function () {
        var $el = $(this);
        var val = ($el.val() != null) ? secureInput($el.val().trim()) : secureInput($el.val());

        if (val == "" || val == null || val == 0) {
            countErrors++;
            // console.log($el);
            $(this).parents("div:first").addClass("has-error");
        }
    });

    $(id_form + " textarea.save-required").each(function() {
        var $el = $(this);
        var val = secureInput($el.val().trim());
        if (val == "") {
            countErrors++;
            $(this).parents("div:first").addClass("has-error");
        }
    });

    if (countErrors > 0) {
        toastr.warning("Campos marcados con * son obligatorios");
        return false;
    }

    return true;
}

function validateEmail(email) {
    var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(email);
}

function isInt(n) {
    return n != "" && !isNaN(n) && Math.round(n) == n;
}

function soloNumeros(e) {
    var key = window.Event ? e.which : e.keyCode;
    return (key >= 48 && key <= 57);
}

//Sin numeros Negativos
function validaDecimales(e, field) {
    key = e.keyCode ? e.keyCode : e.which
    // backspace
    if (key == 8) return true
    // 0-9
    if (key > 47 && key < 58) {
        if (field.value == "") return true
        regexp = /.[-0-9]{20}$/
        return !(regexp.test(field.value))
    }
    // .
    if (key == 46) {
        if (field.value == "") return false
        regexp = /^-[0-9]+$/
        if (regexp.test(field.value)) {
            return true;
        } else {
            regexp = /^[0-9]+$/
            return regexp.test(field.value);
        }
    }
    // other key
    return false
}

// con numeros negativos
function validaDecimalesConNumNegativos(e, field) {
    key = e.keyCode ? e.keyCode : e.which
    // backspace
    if (key == 8) return true
    // 0-9
    if (key > 47 && key < 58) {
        if (field.value == "") return true
        regexp = /.[-0-9]{20}$/
        return !(regexp.test(field.value))
    }
    // - numeros Negativos
    if (key == 45) {
        if (field.value == "") return true

        regexp = /^-[0-9]+$/
        if (!regexp.test(field.value)) {
            cadena = field.value.substr(0, 1);
            if (!isNaN(cadena)) {
                field.value = "-" + field.value;
            }
        }
    }
    // .
    if (key == 46) {
        if (field.value == "") return false
        regexp = /^-[0-9]+$/
        if (regexp.test(field.value)) {
            return true;
        } else {
            regexp = /^[0-9]+$/
            return regexp.test(field.value);
        }
    }
    // other key
    return false
}

function soloLetras(e) {
    key = e.keyCode || e.which;
    tecla = String.fromCharCode(key).toLowerCase();
    letras = "áéíóúabcdefghijklmnñopqrstuvwxyz";
    especiales = [8, 37, 39, 46];

    tecla_especial = false
    for (var i in especiales) {
        if (key == especiales[i]) {
            tecla_especial = true;
            break;
        }
    }

    if (letras.indexOf(tecla) == -1 && !tecla_especial)
        return false;
}

function soloLetrasStrict(e) {
    key = e.keyCode || e.which;
    tecla = String.fromCharCode(key).toLowerCase();
    letras = "áéíóúabcdefghijklmnñopqrstuvwxyz";
    especiales = [8, 32];

    tecla_especial = false
    for (var i in especiales) {
        if (key == especiales[i]) {
            tecla_especial = true;
            break;
        }
    }

    if (letras.indexOf(tecla) == -1 && !tecla_especial)
        return false;
}

//solo letras y numeros (espacio = true | false)
function soloAlfanumerico(e, espacio) {
    var regex = new RegExp('[a-zA-Z0-9]');
    if (espacio) {
        regex = new RegExp('[a-zA-Z0-9 ]');
    }
    var key = String.fromCharCode(!e.charCode ? e.which : e.charCode);
    if (!regex.test(key)) {
        e.preventDefault();
        return false;
    }
}

function codigoPostal(cp) {
    if (cp !== '') {
        var patt = new RegExp("^[0-9]{5}$");
        return patt.test(cp);
    } else {
        return false;
    }
}

var disableSave = function (_this) {
    _this.attr("disabled", true);
};

var enabledSave = function (_this) {
    _this.attr("disabled", false);
};

/**
 * Agrega una nueva opcion al select2
 * @param idElement
 * @param idItem
 * @param textItem
 * @param isSelected
 */
function edit_Selected_V1(idElement, idItem, textItem, isSelected = false) {
    var newOption = new Option(textItem, idItem, isSelected, isSelected);
    $(idElement).append(newOption).trigger('change');
}

function roundUsingToFixed(value, digits = 2) {
    var valor = parseFloat(value);
    return parseFloat(valor.toFixed(digits));
}

function roundUsingToPrecision(value, digits = 2) {
    const precision = Math.round(value).toString().length + digits;
    return parseFloat(value.toPrecision(precision));
}

function roundUsingMathRound(value, digits = 2) {
    const scale = Math.pow(10, digits);
    return Math.round(value * scale) / scale;
}

function formatNumberComas(num) {
    return new Intl.NumberFormat('es-MX', {
        style: 'currency',
        currency: 'MXN',
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    }).format(num);
};