<?php

namespace App\Models\solicitud_clon;

use App\Models\Estatus;
use App\Models\Ingeniero;
use App\Models\Obra;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SolicitudCompraClon extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'solicitud_compras_clon';

    protected $fillable = [
        'obra_id',
        'ingeniero_id',
        'codigo',
        'codigo_nombre',
        'observaciones',
        'fecha_solicitud',
        'fecha_entrega',
        'estatus_id',
        'emails',
        'email_asunto',
        'email_contenido',
    ];

    public function obra(){
        return $this->belongsTo(Obra::class);
    }

    public function ingeniero(){
        return $this->belongsTo(Ingeniero::class);
    }

    public function SolicitudCompraProductoClon()
    {
        return $this->hasMany(SolicitudCompraProductoClon::class, 'solicitud_compra_clon_id', 'id');
    }

    public function estatus(){
        return $this->belongsTo(Estatus::class);
    }

}
