<?php

namespace App\Models;

use App\Models\solicitud_material\RelSolicitudCompraProductoPrecio;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SolicitudCompraProducto extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'solicitud_compras_productos';

    protected $fillable = [
        'solicitud_compra_id',
        'producto_id',
        'unidad_id',
        'num_duplicado_order',
        'cantidad',
        'area_de_uso',
        'marca',
        'modelo',
        'precio_lista',
        'precio_unitario',
        'importe',
        'descuento',
        'subtotal',
        'observaciones',
    ];

    public function solicitudCompra(){
        return $this->belongsTo(SolicitudCompra::class);
    }

    public function producto(){
        return $this->belongsTo(Producto::class);
    }

    public function unidad(){
        return $this->belongsTo(Unidad::class);
    }

    public function RelSolicitudProductoComentarioMaterial()
    {
        return $this->hasOne(RelSolicitudProductoComentarioMaterial::class);
    }

    public function RelSolicitudCompraProductoPrecio(){
        return $this->hasOne(RelSolicitudCompraProductoPrecio::class, 'solicitud_compra_producto_id');
    }

}
