<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RelSolicitudProductoComentarioMaterial extends Model
{
    use HasFactory;

    protected $table = 'rel_solicitud_productos_comentarios_materiales';

    protected $fillable = [
        'solicitud_compra_producto_id',
        'comentarios_materiales_id',
        'users_id',
        'solicitud_compra_id'
    ];

    public function solicitudCompraProducto(){
        return $this->belongsTo(SolicitudCompraProducto::class, 'solicitud_compra_producto_id', 'id');
    }

    public function comentariosMaterial(){
        return $this->belongsTo(ComentarioMaterial::class, 'comentarios_materiales_id', 'id');
    }

    public function user(){
        return $this->belongsTo(User::class, 'users_id');
    }
}
