<?php

namespace App\Models;

use App\Models\solicitud_clon\SolicitudCompraClon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrdenCompra extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'ordenes_compras';

    protected $fillable = [
        'solicitud_compra_id',
        'solicitud_compra_clon_id',
        'proveedor_id',
        'codigo',
        'codigo_nombre',
        'vendedor',
        'metodo_envio',
        'conticiones_de_pago',
        'comentarios',
        'comentario_gloria',
        'fecha_orden',
        'fecha_entrega',
        'fecha_embarque',
        'importe_sin_impuestos',
        'iva_impuestos_id',
        'monto_iva',
        'monto_isr',
        'total',
        'total_letras',
        'estatus_id',
        'enviado_a_pago',
        'url_descarga_pdf',
        'actiivo',
        'emails',
        'email_asunto',
        'email_contenido',
        'clave_version',
        'tipo_pago_id',
    ];

    public function solicitudCompra(){
        return $this->belongsTo(SolicitudCompra::class);
    }

    public function SolicitudCompraClon()
    {
        return $this->belongsTo(SolicitudCompraClon::class, 'solicitud_compra_clon_id');
    }

    public function proveedor(){
        return $this->belongsTo(Proveedor::class);
    }

    public function ivaImpuesto(){
        return $this->belongsTo(IvaImpuesto::class, 'iva_impuestos_id');
    }

    public function ordenCompraAnticipo()
    {
        return $this->hasMany(OrdenCompraAnticipo::class, 'orden_compra_id', 'id');
    }

    public function pagoProveedor()
    {
        return $this->hasOne(PagoProveedor::class, 'orden_compra_id', 'id');
    }

    public function estatus()
    {
        return $this->belongsTo(Estatus::class);
    }

    public function tipoPago()
    {
        return $this->belongsTo(TipoPago::class);
    }

}
