<?php namespace App\Http\Helpers;

use Carbon\Carbon;
#use phpDocumentor\Reflection\Types\Boolean;

class FunctionsHelper {

    var $numbers = [ 0=> 'Cero',
        1=>'Uno',2=>'Dos',3=>'Tres',4=>'Cuatro',5=>'Cinco',6=>'Seis',7=>'Siete',8=>'Ocho',9=>'Nueve',10=>'Diez',
        11=>'Once', 12=>'Doce',13=>'Trece',14=>'Catorce',15=>'Quince',16=>'Dieciseis',17=>'Diecisiete',18=>'Dieciocho',19=>'Diecinueve',20=>'Veinte',
        21=>'Veintiuno',22=>'Veintidos',23=>'Veintitres',24=>'Veinticuatro',25=>'Veinticinco',26=>'Veintiseis',27=>'Veintisiete',28=>'Veintiocho',29=>'Veintinueve',30=>'Treinta',
        31=>'Treinta y uno',32=>'Treinta y dos',33=>'Treinta y tres',34=>'Treinta y cuatro',35=>'Treinta y cinco',36=>'Treinta y seis',37=>'Treinta y siete',38=>'Treinta y ocho',39=>'Treinta y nueve',40=>'Cuarenta',
    ];

    var $meses = array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
    var $meses_abreviado = array("Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Sep","Oct","Nov","Dic");
    var $dias = array("Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado");

    public function normalDate($date){
        $fecha = Carbon::parse($date);
        return $fecha->format('d-m-Y');
    }

    public function formatDate($date){
        $fecha = Carbon::parse($date);
        $mes = $this->meses[($fecha->format('n')) - 1];
        $dia = $fecha->format('d');
        $anio = $fecha->format('Y');
        $date_string = $dia .' de '. $mes .' de '. $anio;
        return $date_string;
    }

    public function formatDateFormat1($date){
        $fecha = Carbon::parse($date);
        $mes = $this->meses[($fecha->format('n')) - 1];
        $dia = $fecha->format('d');
        $anio = $fecha->format('Y');
        $date_string = $dia .'-'. $mes .'-'. $anio;
        return $date_string;
    }

    public function formatDateFormat2($date){
        $fecha = Carbon::parse($date);
        $dia_semana = $this->dias[$fecha->format('w')];
        $mes = $this->meses[($fecha->format('n')) - 1];
        $dia = $fecha->format('d');
        $anio = $fecha->format('Y');
        return $dia_semana . ', ' . $dia .' de '. $mes .' de '. $anio;
    }

    public function formatDateFormat22($date){
        $fecha = Carbon::parse($date);
        $mes = $this->meses[($fecha->format('n')) - 1];
        $dia = $fecha->format('d');
        $anio = $fecha->format('Y');
        $date_string = $dia .'-'. substr($mes,0,3) .'-'. $anio;
        return $date_string;
    }

    /**
     * Convierte una fecha de tipo string al formato mes-año
     * Ej. reduce(false) 2024-04-29 to Abril-2024
     * Ej. reduce(true) 2024-04-29 to Abr-24
     * @param String   $date  Fecha que se formateara
     * @param Boolean  $reduce  Indica si se quiere retornar en formato corto
     *
     * @return String
     */
    public function formatDateFormat3($date, $reduce = false){
        $fecha = Carbon::parse($date);
        $mes = $this->meses[($fecha->format('n')) - 1];
        $mes = $reduce?substr($mes,0,3):$mes;
        $anio = $fecha->format($reduce?'y':'Y');
        $date_string =  $mes .'-'. $anio;
        return $date_string;
    }

    public function formatDateTime($date){
        $fecha = Carbon::parse($date);
        $mes = $this->meses_abreviado[($fecha->format('n')) - 1];
        $dia = $fecha->format('d');
        $anio = $fecha->format('Y');
        $date_string = $dia .'/'. $mes .'/'. $anio . ' '. $fecha->format('h:i A');
        return $date_string;
    }

    public function formatDateTime2($date){
        $fecha = Carbon::parse($date);
        $mes = $fecha->format('m');
        $dia = $fecha->format('d');
        $anio = $fecha->format('Y');
        $date_string = $dia .'-'. $mes .'-'. $anio . ' '. $fecha->format('h:i:s A ');
        return $date_string;
    }

    public function formatDateAbrev($date){
        $fecha = Carbon::parse($date);
        $mes = $this->meses_abreviado[($fecha->format('n')) - 1];
        $dia = $fecha->format('d');
        $anio = $fecha->format('Y');
        $date_string = $dia .'/'. $mes .'/'. $anio;
        return $date_string;
    }

    function truncate($x, $digits) {
        if($x > 0){
            return round($x - 5 * pow(10, -($digits + 1)), $digits);
        } else {
            return 0;
        }

    }

    public function toPrecision($number, $precision) {
        if ($number == 0) return 0;
        $exponent = floor(log10(abs($number)) + 1);
        $significand =
            round(
                ($number / pow(10, $exponent))
                * pow(10, $precision)
            )
            / pow(10, $precision);
        return $significand * pow(10, $exponent);
    }

    //Obtiene la edad real a partir de la fecha de nacimiento
    public function getEdad($fecha_nacimiento) {
        if($fecha_nacimiento)
        {
            return $edad = Carbon::parse($fecha_nacimiento)->age;
        }

        return null;
    }

    public function getPreciosUnidad($detalles, $cotizacion_detalles_esquema, $digitosDecimal, $i){
        if($detalles){
            foreach ($detalles as $detalle) {
                $detalle = (object) $detalle;
                $descripcion = ($detalle->unidad_principal) ? 'Precio lista (Unidad principal)' : 'Precio lista (Unidad secundaria)';
                $cotizacion_detalles_esquema[$i]['descripcion'] = $descripcion;
                $cotizacion_detalles_esquema[$i]['valores'][] = '$ '. number_format($detalle->precio_unitario, $digitosDecimal);
                $i++;
            }
        }

        return ['cotizacion_detalles_esquema' => $cotizacion_detalles_esquema, 'contador' => $i];
    }

    public function getFicahTecnicaUnidad($ficha_tecnica){
        $collection = collect($ficha_tecnica)->sortByDesc('unidad_principal');
        $flatMap = $collection->filter(function ($item) {
            $item = (object) $item;
            return $item;
        });

        $flatMap = $flatMap->values();
        $ficha_tecnica = $flatMap[0];
        return $ficha_tecnica;
    }

    public function getSumaFiltroByFichaTecnica($fichaTecnica, $filtro){

        $collection = collect($fichaTecnica)->sortByDesc('unidad_principal');
        $sum = $collection->filter(function ($item) {
            $item = (object) $item;
            return $item;
        })->map(function($ficha) use($filtro){
            if(isset($ficha['filtros'][$filtro]))
                return $ficha['filtros'][$filtro]['nombre'];

            return 0;
        })->sum();

        return $sum;
    }

    public function getDescripcionUnidad($unidad_detalle_id, $lista_unidades){
        $descripcion_inventario = '';
        foreach ($lista_unidades as $unidad_item){
            $unidad_item = (object) $unidad_item;
            if($unidad_item->filtros['unidad']['unidad_detalle_id'] == $unidad_detalle_id){
                $descripcion_inventario =  $unidad_item->descripcion;
            }
        }

        return $descripcion_inventario;
    }

    public function getPlanosUnidad($archivos){
        $planos = [];

        if($archivos)
            foreach ($archivos as $archivo){
                $planos[$archivo->tipo_archivo->capi_clave] = $archivo['archivo'];
            }

        return $planos;
    }

    public function getPropietarioFirst($propietarios){
        $propietario = collect($propietarios)->first();
        return $propietario;
    }

    public function getPropietarioDireccioFirst($direcciones){
        $direccion = collect($direcciones)->first();
        return $direccion;
    }

    public function getDataDireccionPersonal($direcciones){

    }

    public function getRangosFechas($filtroFechas){
        if(!empty($filtroFechas)){
            $fechaInicio = '';
            $fechaFin = '';
            $tipo = '';

            switch ($filtroFechas) {

                case 2:
                    $fechaInicio = Carbon::now()->startOfMonth()->format('Y-m-d');
                    $fechaFin = Carbon::now()->lastOfMonth()->format('Y-m-d');
                    $tipo = "Este mes";
                    break;

                case 3:
                    $fechaInicio = Carbon::now()->startOfMonth()->subMonth()->format('Y-m-d');
                    $fechaFin = Carbon::now()->subMonth()->lastOfMonth()->format('Y-m-d');
                    $tipo = "Mes pasado";
                    break;

                case 4:
                    $fechaInicio = Carbon::now()->startOfYear()->format('Y-m-d');
                    $fechaFin = Carbon::now()->endOfYear()->format('Y-m-d');
                    $tipo = "Este año";
                    break;

                case 5:
                    $fechaInicio = Carbon::now()->startOfYear()->subYear()->format('Y-m-d');
                    $fechaFin = Carbon::now()->subYear()->endOfYear()->format('Y-m-d');
                    $tipo = "Año pasado";
                    break;

                case 1:
                default:
                    $tipo = 'Todos';
                    break;

            }

            return [
                'error' => false,
                'tipo'=> $tipo,
                'fechaInicio' => date($fechaInicio),
                'fechaFin' => date($fechaFin)
            ];

        } else {

            return [
                'error' => true,
                'mensaje' => 'No se pudo obtener el rango de fechas'
            ];

        }

    }

    public function direccionDefaultValues(){
        return (object) [
            'direccion' => null,
            'numero_exterior' => null,
            'numero_interior' => null,
            'codigo_postal' => null,
            'calle' => null,
            'colonia' => null,
            'ciudad' => null,
            'alcaldia_municipio' => null,
            'estado' => ['opcion' => null],
            'pais' => ['opcion' => null],
        ];
    }

    public function getSeparacion($pagos, $monto_separacion_default = 0)
    {
        if ($pagos) {
            $pagos = collect($pagos);

            $pagos_separacion = $pagos->filter(function ($item) {
                $item = (object)$item;
                if (!$item->separacion) {
                    return $item;
                }
            });

            $pagos_separacion = $pagos_separacion->values();
            $separacion = $pagos_separacion->sum('monto_pago');

            if ($separacion > 0)
                return $separacion;

        }

        return $monto_separacion_default;
    }


    public function getDescripcionUnidadPrincipal($ficha_tecnica, $configuracion){
        $filtros = (object) $ficha_tecnica['filtros'];

        $descripcion_detallado = '';
        if($configuracion){
            foreach ($configuracion  as $config){
                $config = (object) $config;

                if($config->type === 'filtros' && $config->text != 'Estatus' && $config->key)
                    $descripcion_detallado .=  $config->text .": <strong>". $filtros->{$config->key}['nombre'] ."</strong>, ";

            }
        }else{
            $descripcion_detallado = "Unidad : <strong>". $filtros->unidad['nombre'] ."</strong>";
        }


        return $descripcion_detallado;
    }

    function mapJoinCuentasXCobrar($cuentas_pagos) {
        $cuentas_pagos = collect($cuentas_pagos)->map(function ($item){
            return $item->cotizacion_pago_detalle;
        });

        if($cuentas_pagos) {
            $cuentas_pagos = join(" / ", $cuentas_pagos->pluck('descripcion')->unique()->toArray());
            $cuentas_pagos = str_replace('Construcción', 'Mensualidad', $cuentas_pagos);
            $cuentas_pagos = str_replace('Escrituración', 'Contra entrega', $cuentas_pagos);
        } else
            $cuentas_pagos = '-';

        return $cuentas_pagos;
    }

    function ajusteDescripcion($descripcion) {

        if($descripcion === "Construcción")
            $descripcion = "Mensualidad";

        if($descripcion === "Escrituración")
            $descripcion = "Contra entrega";

        return $descripcion;

    }

    function eliminar_acentos($cadena){

        //Reemplazamos la A y a
        $cadena = str_replace(
            array('Á', 'À', 'Â', 'Ä', 'á', 'à', 'ä', 'â', 'ª'),
            array('A', 'A', 'A', 'A', 'a', 'a', 'a', 'a', 'a'),
            $cadena
        );

        //Reemplazamos la E y e
        $cadena = str_replace(
            array('É', 'È', 'Ê', 'Ë', 'é', 'è', 'ë', 'ê'),
            array('E', 'E', 'E', 'E', 'e', 'e', 'e', 'e'),
            $cadena );

        //Reemplazamos la I y i
        $cadena = str_replace(
            array('Í', 'Ì', 'Ï', 'Î', 'í', 'ì', 'ï', 'î'),
            array('I', 'I', 'I', 'I', 'i', 'i', 'i', 'i'),
            $cadena );

        //Reemplazamos la O y o
        $cadena = str_replace(
            array('Ó', 'Ò', 'Ö', 'Ô', 'ó', 'ò', 'ö', 'ô'),
            array('O', 'O', 'O', 'O', 'o', 'o', 'o', 'o'),
            $cadena );

        //Reemplazamos la U y u
        $cadena = str_replace(
            array('Ú', 'Ù', 'Û', 'Ü', 'ú', 'ù', 'ü', 'û'),
            array('U', 'U', 'U', 'U', 'u', 'u', 'u', 'u'),
            $cadena );

        //Reemplazamos la N, n, C y c
        $cadena = str_replace(
            array('Ñ', 'ñ', 'Ç', 'ç'),
            array('N', 'n', 'C', 'c'),
            $cadena
        );

        return $cadena;
    }

}
