<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Helpers\Consts;
use App\Http\Helpers\FunctionsHelper;
use App\Models\SolicitudCompra;
use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

class ExportExcelController extends Controller
{
    public function exportar_excel_solicitud($id)
    {
        $solicitud_compra = SolicitudCompra::with([
            'obra',
            'ingeniero',
            'estatus',
            'solicitudCompraProducto',
            'solicitudCompraProducto.producto',
            'solicitudCompraProducto.unidad',
            'solicitudCompraProducto.RelSolicitudProductoComentarioMaterial.comentariosMaterial',
        ])->where('id', $id)
            ->whereNull('deleted_at')
            ->first();

        $solicitud_compra_clave_version = $solicitud_compra->clave_version;
        $orden_compra_solicitud_compra_clon_id = null;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        $sheet->setTitle('Requisición de compra');

        // Crea un objeto de dibujo
        $drawing = new Drawing();
        $drawing->setName('Logo');
        $drawing->setDescription('Logo');
        $logo_path = public_path('Logotipo/Logotipo_Original.png');
        $drawing->setPath($logo_path);
        // Establece las coordenadas y el tamaño
        $drawing->setCoordinates('A1'); // Inserta la imagen en la celda A1
        $drawing->setOffsetX(25); // Desplazamiento horizontal
        $drawing->setOffsetY(5); // Desplazamiento vertical
        $drawing->setWidth(100); // Ancho de la imagen
        $drawing->setHeight(100); // Alto de la imagen
        // Vincula el dibujo a la hoja
        $drawing->setWorksheet($sheet);

        $sheet->mergeCells('C1:H1');
        $sheet->setCellValue('C1', 'ARISTA AR SA DE CV');
        $sheet->mergeCells('J1:M1');
        $sheet->setCellValue('J1', 'REQUISICIÓN DE COMPRA');

        $sheet->mergeCells('C2:H2');
        $sheet->setCellValue('C2', 'CALLE 19 X 56 NUMERO 363 PLAN DE AYALA NORTE, YUCATAN, CP. 97118');
        $sheet->mergeCells('J2:K2');
        $sheet->setCellValue('J2', 'REQUISICIÓN SEMANAL N.');
        $sheet->mergeCells('L2:M2');
        $sheet->setCellValue('L2', $solicitud_compra->codigo);

        $sheet->mergeCells('C3:H3');
        $sheet->setCellValue('C3', 'RFC: AAR080509D22');
        $sheet->mergeCells('J3:K3');
        $sheet->setCellValue('J3', 'OBRA:');
        $sheet->mergeCells('L3:M3');
        $sheet->setCellValue('L3', $solicitud_compra->obra->nombre);

        $sheet->mergeCells('C4:H4');
        $sheet->setCellValue('C4', 'Tel.:999 944 5327');
        $sheet->mergeCells('J4:K4');
        $sheet->setCellValue('J4', 'ELABORÓ:');
        $sheet->mergeCells('L4:M4');
        $sheet->setCellValue('L4', $solicitud_compra->ingeniero->nombre);

        $sheet->mergeCells('J5:K5');
        $sheet->setCellValue('J5', 'FECHA SOLICITADA:');
        $sheet->mergeCells('L5:M5');
        $funciones_helper = new FunctionsHelper();
        $fecha_solicitud = $funciones_helper->formatDateFormat2($solicitud_compra->fecha_solicitud);
        $sheet->setCellValue('L5', $fecha_solicitud);


        // Agregar datos a la hoja de cálculo
        $sheet->setCellValue('A7', 'CÓDIGO');
        $sheet->setCellValue('B7', 'MATERIAL');
        $sheet->setCellValue('C7', 'UNIDAD');
        $sheet->setCellValue('D7', 'CANTIDAD');
        $sheet->setCellValue('E7', 'ÁREA DE USO');
        $sheet->setCellValue('F7', 'MARCA');
        $sheet->setCellValue('G7', 'MODELO');
        $sheet->setCellValue('H7', 'OBSERVACIONES');
        $sheet->setCellValue('I7', 'COMENTARIO GRUPAL');

        $lista_materiales = [];
        if ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V1 || ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id == null)) {
            $lista_materiales = $solicitud_compra->solicitudCompraProducto;
        } else if ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id !== null) {
            $lista_materiales = $solicitud_compra->SolicitudCompraProductoClon;
        }

        $row = 8;// Initialize row counter
        foreach ($lista_materiales as $key => $material) {
            $comentario_Material_grupal = "--";
            if ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V1 || ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id == null)) {
                $comentario_Material_grupal = (!empty($material->RelSolicitudProductoComentarioMaterial)) ? $material->RelSolicitudProductoComentarioMaterial->comentariosMaterial->comentario : "";
            }else if ($solicitud_compra_clave_version === Consts::SOLICITUD_COMPRA_V2 && $orden_compra_solicitud_compra_clon_id !== null) {
                $comentario_Material_grupal = (!empty($material->RelSolicitudProductoComentarioMaterialClon)) ? $material->RelSolicitudProductoComentarioMaterialClon->ComentarioMaterialClon->comentario : "";
            }

            $sheet->setCellValue('A'.$row, $material->producto->codigo);
            $sheet->setCellValue('B'.$row, $material->producto->nombre);
            $sheet->setCellValue('C'.$row, $material->unidad->nombre);
            $sheet->setCellValue('D'.$row, $material->cantidad);
            $sheet->setCellValue('E'.$row, $material->area_de_uso);
            $sheet->setCellValue('F'.$row, $material->marca);
            $sheet->setCellValue('G'.$row, $material->modelo);
            $sheet->setCellValue('H'.$row, $material->observaciones);
            $sheet->setCellValue('I'.$row, $comentario_Material_grupal);

            $row++;
        }

        $row += 1;
        $sheet->mergeCells('J'.$row.':M'.$row);
        $sheet->setCellValue('J'.$row, 'FECHA DE ENTREGA SOLICITADA');

        $row += 1;
        $sheet->mergeCells('J'.$row.':M'.$row);
        $fecha_entrega = $funciones_helper->formatDateFormat2($solicitud_compra->fecha_entrega);
        $sheet->setCellValue('J'.$row, $fecha_entrega);

        $sheet->getColumnDimension('A')->setAutoSize(true);
        $sheet->getColumnDimension('B')->setAutoSize(true);
        $sheet->getColumnDimension('C')->setAutoSize(true);
        $sheet->getColumnDimension('D')->setAutoSize(true);
        $sheet->getColumnDimension('E')->setAutoSize(true);
        $sheet->getColumnDimension('F')->setAutoSize(true);
        $sheet->getColumnDimension('G')->setAutoSize(true);
        $sheet->getColumnDimension('H')->setAutoSize(true);
        $sheet->getColumnDimension('I')->setAutoSize(true);
        $sheet->getColumnDimension('J')->setAutoSize(true);
        $sheet->getColumnDimension('K')->setAutoSize(true);
        $sheet->getColumnDimension('L')->setAutoSize(true);
        $sheet->getColumnDimension('M')->setAutoSize(true);

        // Crear un objeto writer para guardar el archivo
        $writer = new Xlsx($spreadsheet);

        // Definir la ubicación y nombre del archivo
        $filename = 'REQUISICIÓN DE COMPRA.xlsx';
        $path = storage_path("app/public/exports_excel_temp/".$filename);

        $writer->save($path);

        // Descargar el archivo
        return response()->download($path, $filename);
    }
}
